/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    long labelHandle;
    long imageHandle;
    long pageHandle;
    Control control;
    TabFolder parent;
    String toolTipText;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        this.parent = tabFolder;
        this.createWidget(tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        this.parent = tabFolder;
        this.createWidget(n2);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int n) {
        this.parent.createItem(this, n);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        int n;
        this.checkWidget();
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        return new Rectangle(n2, n3, n4, n);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    long gtk_enter_notify_event(long l, long l2) {
        this.parent.gtk_enter_notify_event(l, l2);
        return 0L;
    }

    long gtk_mnemonic_activate(long l, long l2) {
        return this.parent.gtk_mnemonic_activate(l, l2);
    }

    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.closures[14], false);
    }

    void register() {
        super.register();
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.pageHandle = 0L;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int n = this.parent.indexOf(this);
        if (n == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    public void setControl(Control control) {
        int n;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n2 = this.parent.indexOf(this);
        if (n2 != (n = this.parent.getSelectionIndex()) && control3 != null) {
            Control control4;
            if (n != -1 && (control4 = this.parent.getItem(n).getControl()) == control3) {
                return;
            }
            control3.setVisible(false);
            return;
        }
        if (control3 != null) {
            control3.setBounds(this.parent.getClientArea());
            control3.setVisible(true);
        }
        if (control2 != null) {
            control2.setVisible(false);
        }
    }

    void setFontDescription(long l) {
        this.setFontDescription(this.labelHandle, l);
        this.setFontDescription(this.imageHandle, l);
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.labelHandle, gdkColor, false);
        this.setForegroundColor(this.imageHandle, gdkColor, false);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            long l = imageList.getPixbuf(n);
            this.gtk_image_set_from_pixbuf(this.imageHandle, l);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    void setOrientation(boolean bl) {
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                OS.gtk_widget_set_direction(this.handle, n);
            }
            if (this.labelHandle != 0L) {
                OS.gtk_widget_set_direction(this.labelHandle, n);
            }
            if (this.imageHandle != 0L) {
                OS.gtk_widget_set_direction(this.imageHandle, n);
            }
            if (this.pageHandle != 0L) {
                OS.gtk_widget_set_direction(this.pageHandle, n);
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

