/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    MenuItem selectedItem;
    Decorations parent;
    long imItem;
    long imSeparator;
    long imHandle;
    ImageList imageList;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget(0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean bl) {
        if (bl == this.gtk_widget_get_mapped(this.handle)) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                TrayItem trayItem;
                if (OS.GTK_VERSION >= OS.VERSION(2, 8, 0) && (this.parent._getShell().style & 0x4000) != 0) {
                    OS.gtk_menu_shell_set_take_focus(this.handle, false);
                }
                long l = this.hasLocation ? this.display.menuPositionProc : 0L;
                this.hasLocation = false;
                long l2 = 0L;
                if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0) && (trayItem = this.display.currentTrayItem) != null && !trayItem.isDisposed()) {
                    l2 = trayItem.handle;
                    l = OS.gtk_status_icon_position_menu_func();
                }
                OS.gtk_menu_popup(this.handle, 0L, 0L, l, l2, 0, this.display.getLastEventTime());
            } else {
                this.sendEvent(23);
            }
        } else {
            OS.gtk_menu_popdown(this.handle);
        }
    }

    void addAccelerators(long l) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.addAccelerators(l);
        }
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 2) != 0) {
            this.handle = OS.gtk_menu_bar_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            long l = this.parent.vboxHandle;
            OS.gtk_container_add(l, this.handle);
            OS.gtk_box_set_child_packing(l, this.handle, false, true, 0, 0);
        } else {
            this.handle = OS.gtk_menu_new();
            if (this.handle == 0L) {
                this.error(2);
            }
        }
    }

    void createIMMenu(long l) {
        Object[] objectArray;
        boolean bl = false;
        long l2 = OS.gtk_settings_get_default();
        if (l2 != 0L) {
            objectArray = new int[1];
            OS.g_object_get(l2, OS.gtk_show_input_method_menu, objectArray, 0L);
            boolean bl2 = bl = objectArray[0] != 0;
        }
        if (l == 0L || !bl) {
            this.imHandle = 0L;
            if (this.imItem != 0L) {
                OS.gtk_widget_destroy(this.imItem);
                this.imItem = 0L;
            }
            if (this.imSeparator != 0L) {
                OS.gtk_widget_destroy(this.imSeparator);
                this.imSeparator = 0L;
            }
            return;
        }
        if (this.imHandle == l) {
            return;
        }
        this.imHandle = l;
        if (this.imSeparator == 0L) {
            this.imSeparator = OS.gtk_separator_menu_item_new();
            OS.gtk_widget_show(this.imSeparator);
            OS.gtk_menu_shell_insert(this.handle, this.imSeparator, -1);
        }
        if (this.imItem == 0L) {
            objectArray = Converter.wcsToMbcs(null, SWT.getMessage("SWT_InputMethods"), true);
            this.imItem = OS.gtk_image_menu_item_new_with_label((byte[])objectArray);
            OS.gtk_widget_show(this.imItem);
            OS.gtk_menu_shell_insert(this.handle, this.imItem, -1);
        }
        long l3 = OS.gtk_menu_new();
        OS.gtk_im_multicontext_append_menuitems(l, l3);
        OS.gtk_menu_item_set_submenu(this.imItem, l3);
    }

    void createWidget(int n) {
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.parent.addMenu(this);
    }

    void fixMenus(Decorations decorations) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].fixMenus(decorations);
        }
        this.parent.removeMenu(this);
        decorations.addMenu(this);
        this.parent = decorations;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!this.gtk_widget_get_mapped(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l = this.gtk_widget_get_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l, nArray, nArray2);
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n = nArray[0] + gtkAllocation.x;
        int n2 = nArray2[0] + gtkAllocation.y;
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        return new Rectangle(n, n2, n3, n4);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.gtk_widget_get_sensitive(this.handle);
    }

    public MenuItem getItem(int n) {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            this.error(8);
        }
        int n2 = OS.g_list_length(l);
        if (this.imSeparator != 0L) {
            --n2;
        }
        if (this.imItem != 0L) {
            --n2;
        }
        if (0 > n || n >= n2) {
            this.error(6);
        }
        long l2 = OS.g_list_nth_data(l, n);
        OS.g_list_free(l);
        if (l2 == 0L) {
            this.error(8);
        }
        return (MenuItem)this.display.getWidget(l2);
    }

    public int getItemCount() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return 0;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        if (this.imSeparator != 0L) {
            --n;
        }
        if (this.imItem != 0L) {
            --n;
        }
        return n;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return new MenuItem[0];
        }
        int n = OS.g_list_length(l);
        if (this.imSeparator != 0L) {
            --n;
        }
        if (this.imItem != 0L) {
            --n;
        }
        MenuItem[] menuItemArray = new MenuItem[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l2 = OS.g_list_nth_data(l, i);
            MenuItem menuItem = (MenuItem)this.display.getWidget(l2);
            if (menuItem == null) continue;
            menuItemArray[n2++] = menuItem;
        }
        OS.g_list_free(l);
        if (n2 != menuItemArray.length) {
            MenuItem[] menuItemArray2 = new MenuItem[n2];
            System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n2);
            menuItemArray = menuItemArray2;
        }
        return menuItemArray;
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                string = string + menuItemArray[i].getNameText() + ", ";
            }
            string = string + menuItemArray[n - 1].getNameText();
        }
        return string;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] menuArray;
        this.checkWidget();
        if ((this.style & 8) != 0 && (menuArray = this.display.popups) != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                if (menuArray[i] != this) continue;
                return true;
            }
        }
        return this.gtk_widget_get_mapped(this.handle);
    }

    long gtk_hide(long l) {
        if ((this.style & 8) != 0 && this.display.activeShell != null) {
            this.display.activeShell = this.getShell();
        }
        this.sendEvent(23);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(false)) continue;
            }
        }
        return 0L;
    }

    long gtk_show(long l) {
        if ((this.style & 8) != 0) {
            if (this.display.activeShell != null) {
                this.display.activeShell = this.getShell();
            }
            return 0L;
        }
        this.sendEvent(22);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(true)) continue;
            }
        }
        return 0L;
    }

    long gtk_show_help(long l, long l2) {
        if (this.sendHelpEvent(l2)) {
            OS.gtk_menu_shell_deactivate(this.handle);
            return 1L;
        }
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.closures[45], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.closures[24], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.closures[46], false);
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (menuItemArray[i] != menuItem) continue;
            return i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    long menuPositionProc(long l, long l2, long l3, long l4, long l5) {
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(l, gtkRequisition);
        int n = OS.gdk_screen_height();
        int n2 = this.y;
        if (n2 + gtkRequisition.height > n) {
            n2 = Math.max(0, n2 - gtkRequisition.height);
        }
        int n3 = OS.gdk_screen_width();
        int n4 = this.x;
        if ((this.style & 0x4000000) != 0) {
            if (n4 - gtkRequisition.width >= 0) {
                n4 -= gtkRequisition.width;
            }
        } else if (n4 + gtkRequisition.width > n3) {
            n4 -= gtkRequisition.width;
        }
        if (l2 != 0L) {
            OS.memmove(l2, new int[]{n4}, 4L);
        }
        if (l3 != 0L) {
            OS.memmove(l3, new int[]{n2}, 4L);
        }
        if (l4 != 0L) {
            OS.memmove(l4, new int[]{1}, 4L);
        }
        return 0L;
    }

    void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            if (menuItem == null || menuItem.isDisposed()) continue;
            menuItem.release(false);
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
        this.imHandle = 0L;
        this.imSeparator = 0L;
        this.imItem = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    void removeAccelerators(long l) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.removeAccelerators(l);
        }
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    void reskinChildren(int n) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.reskin(n);
        }
        super.reskinChildren(n);
    }

    boolean sendHelpEvent(long l) {
        if (this.selectedItem != null && !this.selectedItem.isDisposed() && this.selectedItem.hooks(28)) {
            this.selectedItem.postEvent(28);
            return true;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return true;
        }
        return this.parent.sendHelpEvent(l);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        OS.gtk_widget_set_sensitive(this.handle, bl);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setOrientation(int n) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(n);
    }

    void _setOrientation(int n) {
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= ~n2;
        this.style |= n & n2;
        this.setOrientation(false);
    }

    void setOrientation(boolean bl) {
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                OS.gtk_widget_set_direction(this.handle, n);
            }
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                menuItemArray[i].setOrientation(bl);
            }
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

