/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import parquet.Preconditions;
import parquet.hadoop.metadata.FileMetaData;
import parquet.schema.MessageType;

public class GlobalMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageType schema;
    private final Map<String, Set<String>> keyValueMetaData;
    private final Set<String> createdBy;

    public GlobalMetaData(MessageType schema, Map<String, Set<String>> keyValueMetaData, Set<String> createdBy) {
        this.schema = Preconditions.checkNotNull(schema, "schema");
        this.keyValueMetaData = Collections.unmodifiableMap(Preconditions.checkNotNull(keyValueMetaData, "keyValueMetaData"));
        this.createdBy = createdBy;
    }

    public MessageType getSchema() {
        return this.schema;
    }

    public String toString() {
        return "GlobalMetaData{schema: " + this.schema + ", metadata: " + this.keyValueMetaData + "}";
    }

    public Map<String, Set<String>> getKeyValueMetaData() {
        return this.keyValueMetaData;
    }

    public Set<String> getCreatedBy() {
        return this.createdBy;
    }

    public FileMetaData merge() {
        String createdByString = this.createdBy.size() == 1 ? this.createdBy.iterator().next() : this.createdBy.toString();
        HashMap<String, String> mergedKeyValues = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : this.keyValueMetaData.entrySet()) {
            if (entry.getValue().size() > 1) {
                throw new RuntimeException("could not merge metadata: key " + entry.getKey() + " has conflicting values: " + entry.getValue());
            }
            mergedKeyValues.put(entry.getKey(), entry.getValue().iterator().next());
        }
        return new FileMetaData(this.schema, mergedKeyValues, createdByString);
    }
}

