/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.oozie.util.XLog;

public class HostnameFilter
implements Filter {
    private static final XLog LOG = XLog.getLog(HostnameFilter.class);
    static final ThreadLocal<String> HOSTNAME_TL = new ThreadLocal();

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String hostname;
            try {
                String address = request.getRemoteAddr();
                if (address != null) {
                    hostname = InetAddress.getByName(address).getCanonicalHostName();
                } else {
                    LOG.warn("Request remote address is NULL");
                    hostname = "???";
                }
            }
            catch (UnknownHostException ex) {
                LOG.warn("Request remote address could not be resolved, {0}", ex.toString(), ex);
                hostname = "???";
            }
            HOSTNAME_TL.set(hostname);
            chain.doFilter(request, response);
        }
        finally {
            HOSTNAME_TL.remove();
        }
    }

    public static String get() {
        return HOSTNAME_TL.get();
    }

    public void destroy() {
    }
}

