/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetForTimeoutJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionTimeOutXCommand
extends CoordinatorXCommand<Void> {
    private CoordinatorActionBean actionBean;
    private String user;
    private String appName;
    private JPAService jpaService = null;

    public CoordActionTimeOutXCommand(CoordinatorActionBean actionBean, String user, String appName) {
        super("coord_action_timeout", "coord_action_timeout", 1);
        this.actionBean = ParamChecker.notNull(actionBean, "ActionBean");
        this.user = ParamChecker.notEmpty(user, "user");
        this.appName = ParamChecker.notEmpty(appName, "appName");
    }

    @Override
    protected Void execute() throws CommandException {
        if (this.actionBean.getStatus() == CoordinatorAction.Status.WAITING) {
            this.actionBean.setStatus(CoordinatorAction.Status.TIMEDOUT);
            try {
                this.queue(new CoordActionNotificationXCommand(this.actionBean), 100L);
                this.actionBean.setLastModifiedTime(new Date());
                CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, this.actionBean);
                if (EventHandlerService.isEnabled()) {
                    CoordActionTimeOutXCommand.generateEvent(this.actionBean, this.user, this.appName, null);
                }
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
        }
        return null;
    }

    @Override
    public String getEntityKey() {
        return this.actionBean.getJobId();
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionBean.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.actionBean = this.jpaService.execute(new CoordActionGetForTimeoutJPAExecutor(this.actionBean.getId()));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.actionBean, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.actionBean.getStatus() != CoordinatorAction.Status.WAITING) {
            throw new PreconditionException(ErrorCode.E1100, "The coord action must have status " + CoordinatorAction.Status.WAITING + " but has status [" + this.actionBean.getStatus() + "]");
        }
    }
}

