/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.WebResult;

public class GetJobStatusServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = GetJobStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/jobStatus";

    public GetJobStatusServlet() {
    }

    public GetJobStatusServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Job job;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetJobStatusServlet.Log.JobStatusRequested", (String[])new String[0]));
        }
        String jobName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        int startLineNr = Const.toInt((String)request.getParameter("from"), (int)0);
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (Utils.isEmpty((CharSequence)id)) {
            CarteObjectEntry entry = this.getJobMap().getFirstCarteObjectEntry(jobName);
            if (entry == null) {
                job = null;
            } else {
                id = entry.getId();
                job = this.getJobMap().getJob(entry);
            }
        } else if (Utils.isEmpty((CharSequence)jobName)) {
            job = this.getJobMap().findJob(id);
        } else {
            CarteObjectEntry entry = new CarteObjectEntry(jobName, id);
            job = this.getJobMap().getJob(entry);
            if (job != null) {
                jobName = job.getJobname();
            }
        }
        Encoder encoder = ESAPI.encoder();
        if (job != null) {
            String status = job.getStatus();
            int lastLineNr = KettleLogStore.getLastBufferLineNr();
            String logText = KettleLogStore.getAppender().getBuffer(job.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
                SlaveServerJobStatus jobStatus = new SlaveServerJobStatus(jobName, id, status);
                jobStatus.setFirstLoggingLineNr(startLineNr);
                jobStatus.setLastLoggingLineNr(lastLineNr);
                jobStatus.setLogDate(job.getLogDate());
                String loggingString = HttpUtil.encodeBase64ZippedString((String)logText);
                jobStatus.setLoggingString(loggingString);
                jobStatus.setResult(job.getResult());
                try {
                    out.println(jobStatus.getXML());
                }
                catch (KettleException e) {
                    throw new ServletException("Unable to get the job status in XML format", (Throwable)e);
                }
            }
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"GetJobStatusServlet.KettleJobStatus", (String[])new String[0]) + "</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(Const.NVL((String)jobName, (String)""), "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</HEAD>");
            out.println("<BODY>");
            out.println("<H1>" + BaseMessages.getString(PKG, (String)"GetJobStatusServlet.JobStatus", (String[])new String[0]) + "</H1>");
            try {
                out.println("<table border=\"1\">");
                out.print("<tr> <th>" + BaseMessages.getString(PKG, (String)"GetJobStatusServlet.Jobname", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.TransStatus", (String[])new String[0]) + "</th> </tr>");
                out.print("<tr>");
                out.print("<td>" + Const.NVL((String)encoder.encodeForHTML(jobName), (String)"") + "</td>");
                out.print("<td>" + status + "</td>");
                out.print("</tr>");
                out.print("</table>");
                out.print("<p>");
                Point max = job.getJobMeta().getMaximum();
                max.x += 20;
                max.y += 20;
                out.print("<iframe height=\"" + max.y + "\" width=\"" + max.x + "\" seamless src=\"" + this.convertContextPath("/kettle/jobImage") + "?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\"></iframe>");
                out.print("<p>");
                if (job.isFinished()) {
                    out.print("<a href=\"" + this.convertContextPath("/kettle/startJob") + "?name=" + URLEncoder.encode(Const.NVL((String)jobName, (String)""), "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"GetJobStatusServlet.StartJob", (String[])new String[0]) + "</a>");
                    out.print("<p>");
                } else {
                    out.print("<a href=\"" + this.convertContextPath("/kettle/stopJob") + "?name=" + URLEncoder.encode(Const.NVL((String)jobName, (String)""), "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"GetJobStatusServlet.StopJob", (String[])new String[0]) + "</a>");
                    out.print("<p>");
                }
                out.println("<p>");
                out.print("<a href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(Const.NVL((String)jobName, (String)""), "UTF-8") + "&xml=y&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.ShowAsXml", (String[])new String[0]) + "</a><br>");
                out.print("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><br>");
                out.print("<p><a href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(Const.NVL((String)jobName, (String)""), "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Refresh", (String[])new String[0]) + "</a>");
                out.println("<p>");
                out.println("<textarea id=\"joblog\" cols=\"120\" rows=\"20\" wrap=\"off\" name=\"Job log\" readonly=\"readonly\">" + encoder.encodeForHTML(logText) + "</textarea>");
                out.println("<script type=\"text/javascript\"> ");
                out.println("  joblog.scrollTop=joblog.scrollHeight; ");
                out.println("</script> ");
                out.println("<p>");
            }
            catch (Exception ex) {
                out.println("<p>");
                out.println("<pre>");
                out.println(encoder.encodeForHTML(Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
            }
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"StartJobServlet.Log.SpecifiedJobNotFound", (String[])new String[]{jobName, id})));
        } else {
            out.println("<H1>Job '" + encoder.encodeForHTML(jobName) + "' could not be found.</H1>");
            out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
        }
    }

    public String toString() {
        return "Job Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/jobStatus (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

