/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.joinrows;

import java.io.File;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.joinrows.JoinRows;
import org.pentaho.di.trans.steps.joinrows.JoinRowsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="JoinRows.Injection.")
public class JoinRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = JoinRowsMeta.class;
    @Injection(name="TEMP_DIR")
    private String directory;
    @Injection(name="TEMP_FILE_PREFIX")
    private String prefix;
    @Injection(name="MAX_CACHE_SIZE")
    private int cacheSize;
    private StepMeta mainStep;
    @Injection(name="MAIN_STEP")
    private String mainStepname;
    private Condition condition = new Condition();

    public StepMeta getMainStep() {
        return this.mainStep;
    }

    public void setMainStep(StepMeta lookupFromStep) {
        this.mainStep = lookupFromStep;
    }

    public String getMainStepname() {
        return this.mainStepname;
    }

    public void setMainStepname(String lookupFromStepname) {
        this.mainStepname = lookupFromStepname;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Injection(name="CONDITION")
    public void setCondition(String conditionXML) throws Exception {
        this.condition = new Condition(conditionXML);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        JoinRowsMeta retval = (JoinRowsMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.directory = XMLHandler.getTagValue((Node)stepnode, (String)"directory");
            this.prefix = XMLHandler.getTagValue((Node)stepnode, (String)"prefix");
            this.cacheSize = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"cache_size"), (int)-1);
            this.mainStepname = XMLHandler.getTagValue((Node)stepnode, (String)"main");
            Node compare = XMLHandler.getSubNode((Node)stepnode, (String)"compare");
            Node condnode = XMLHandler.getSubNode((Node)compare, (String)"condition");
            this.condition = condnode != null ? new Condition(condnode) : new Condition();
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JoinRowsMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "out";
        this.cacheSize = 500;
        this.mainStepname = null;
    }

    @Override
    public String getXML() throws KettleException {
        StringBuilder retval = new StringBuilder(300);
        retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"prefix", (String)this.prefix));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        if (this.mainStepname == null) {
            this.mainStepname = this.getLookupStepname();
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"main", (String)this.mainStepname));
        retval.append("    <compare>").append(Const.CR);
        if (this.condition != null) {
            retval.append(this.condition.getXML());
        }
        retval.append("    </compare>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.directory = rep.getStepAttributeString(id_step, "directory");
            this.prefix = rep.getStepAttributeString(id_step, "prefix");
            this.cacheSize = (int)rep.getStepAttributeInteger(id_step, "cache_size");
            this.mainStepname = rep.getStepAttributeString(id_step, "main");
            this.condition = rep.loadConditionFromStepAttribute(id_step, "id_condition");
            if (this.condition == null) {
                this.condition = new Condition();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JoinRowsMeta.Exception.UnexpectedErrorInReadStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "directory", this.directory);
            rep.saveStepAttribute(id_transformation, id_step, "prefix", this.prefix);
            rep.saveStepAttribute(id_transformation, id_step, "cache_size", this.cacheSize);
            if (this.mainStepname == null) {
                this.mainStepname = this.getLookupStepname();
            }
            rep.saveStepAttribute(id_transformation, id_step, "main", this.mainStepname);
            rep.saveConditionStepAttribute(id_transformation, id_step, "id_condition", this.condition);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JoinRowsMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (space instanceof TransMeta) {
            TransMeta transMeta = (TransMeta)space;
            StepMeta[] steps = transMeta.getPrevSteps(transMeta.findStep(origin));
            StepMeta mainStep = transMeta.findStep(this.getMainStepname());
            rowMeta.clear();
            if (mainStep != null) {
                rowMeta.addRowMeta(transMeta.getStepFields(mainStep));
            }
            for (StepMeta step : steps) {
                if (mainStep != null && step.equals(mainStep)) continue;
                rowMeta.addRowMeta(transMeta.getStepFields(step));
            }
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String realDirectory = transMeta.environmentSubstitute(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, "[" + realDirectory + BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, "[" + realDirectory + BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryExistsButNotValid", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryDoesNotExist", (String[])new String[]{realDirectory}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.CouldNotFindFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getLookupStepname() {
        if (this.mainStep != null && this.mainStep.getName() != null && this.mainStep.getName().length() > 0) {
            return this.mainStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.mainStep = StepMeta.findStep(steps, this.mainStepname);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new JoinRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new JoinRowsData();
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }
}

