/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gettablenames;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gettablenames.GetTableNames;
import org.pentaho.di.trans.steps.gettablenames.GetTableNamesData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="GetTableNames.Injection.", groups={"FIELDS", "SETTINGS", "OUTPUT"})
public class GetTableNamesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetTableNamesMeta.class;
    private DatabaseMeta database;
    @Injection(name="SCHEMANAME", group="FIELDS")
    private String schemaname;
    @Injection(name="TABLENAMEFIELDNAME", group="OUTPUT")
    private String tablenamefieldname;
    @Injection(name="SQLCREATIONFIELDNAME", group="OUTPUT")
    private String sqlcreationfieldname;
    @Injection(name="OBJECTTYPEFIELDNAME", group="OUTPUT")
    private String objecttypefieldname;
    @Injection(name="ISSYSTEMOBJECTFIELDNAME", group="OUTPUT")
    private String issystemobjectfieldname;
    @Injection(name="INCLUDECATALOG", group="SETTINGS")
    private boolean includeCatalog;
    @Injection(name="INCLUDESCHEMA", group="SETTINGS")
    private boolean includeSchema;
    @Injection(name="INCLUDETABLE", group="SETTINGS")
    private boolean includeTable;
    @Injection(name="INCLUDEVIEW", group="SETTINGS")
    private boolean includeView;
    @Injection(name="INCLUDEPROCEDURE", group="SETTINGS")
    private boolean includeProcedure;
    @Injection(name="INCLUDESYNONYM", group="SETTINGS")
    private boolean includeSynonym;
    @Injection(name="ADDSCHEMAINOUTPUT", group="SETTINGS")
    private boolean addSchemaInOutput;
    @Injection(name="DYNAMICSCHEMA", group="FIELDS")
    private boolean dynamicSchema;
    @Injection(name="SCHENAMENAMEFIELD", group="FIELDS")
    private String schenameNameField;
    private List<? extends SharedObjectInterface> databases;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getTablenameFieldName() {
        return this.tablenamefieldname;
    }

    public void setTablenameFieldName(String tablenamefieldname) {
        this.tablenamefieldname = tablenamefieldname;
    }

    public String getSQLCreationFieldName() {
        return this.sqlcreationfieldname;
    }

    public void setSQLCreationFieldName(String sqlcreationfieldname) {
        this.sqlcreationfieldname = sqlcreationfieldname;
    }

    public String getSchemaName() {
        return this.schemaname;
    }

    public void setSchemaName(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setObjectTypeFieldName(String objecttypefieldname) {
        this.objecttypefieldname = objecttypefieldname;
    }

    public void setIsSystemObjectFieldName(String issystemobjectfieldname) {
        this.issystemobjectfieldname = issystemobjectfieldname;
    }

    public void setSystemObjectFieldName(String issystemobjectfieldname) {
        this.issystemobjectfieldname = issystemobjectfieldname;
    }

    public String getObjectTypeFieldName() {
        return this.objecttypefieldname;
    }

    public String isSystemObjectFieldName() {
        return this.issystemobjectfieldname;
    }

    public String getSchemaFieldName() {
        return this.schenameNameField;
    }

    public void setSchemaFieldName(String schenameNameField) {
        this.schenameNameField = schenameNameField;
    }

    public void setIncludeTable(boolean includetable) {
        this.includeTable = includetable;
    }

    public boolean isIncludeTable() {
        return this.includeTable;
    }

    public void setIncludeSchema(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    public boolean isIncludeSchema() {
        return this.includeSchema;
    }

    public void setIncludeCatalog(boolean includeCatalog) {
        this.includeCatalog = includeCatalog;
    }

    public boolean isIncludeCatalog() {
        return this.includeCatalog;
    }

    public void setIncludeView(boolean includeView) {
        this.includeView = includeView;
    }

    public boolean isIncludeView() {
        return this.includeView;
    }

    public void setIncludeProcedure(boolean includeProcedure) {
        this.includeProcedure = includeProcedure;
    }

    public boolean isIncludeProcedure() {
        return this.includeProcedure;
    }

    public void setIncludeSynonym(boolean includeSynonym) {
        this.includeSynonym = includeSynonym;
    }

    public boolean isIncludeSynonym() {
        return this.includeSynonym;
    }

    public void setDynamicSchema(boolean dynamicSchema) {
        this.dynamicSchema = dynamicSchema;
    }

    public boolean isDynamicSchema() {
        return this.dynamicSchema;
    }

    public void setAddSchemaInOut(boolean addSchemaInOutput) {
        this.addSchemaInOutput = addSchemaInOutput;
    }

    public boolean isAddSchemaInOut() {
        return this.addSchemaInOutput;
    }

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        this.database = DatabaseMeta.findDatabase(this.databases, (String)connectionName);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        GetTableNamesMeta retval = (GetTableNamesMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.database = null;
        this.schemaname = null;
        this.includeCatalog = false;
        this.includeSchema = false;
        this.includeTable = true;
        this.includeProcedure = true;
        this.includeView = true;
        this.includeSynonym = true;
        this.addSchemaInOutput = false;
        this.tablenamefieldname = "tablename";
        this.sqlcreationfieldname = null;
        this.objecttypefieldname = "type";
        this.issystemobjectfieldname = "is system";
        this.dynamicSchema = false;
        this.schenameNameField = null;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        String realSQLCreation;
        String sysobject;
        String realObjectType;
        String realtablename = space.environmentSubstitute(this.tablenamefieldname);
        if (!Utils.isEmpty((CharSequence)realtablename)) {
            ValueMetaString v = new ValueMetaString(realtablename);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(realObjectType = space.environmentSubstitute(this.objecttypefieldname)))) {
            ValueMetaString v = new ValueMetaString(realObjectType);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(sysobject = space.environmentSubstitute(this.issystemobjectfieldname)))) {
            ValueMetaBoolean v = new ValueMetaBoolean(sysobject);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)(realSQLCreation = space.environmentSubstitute(this.sqlcreationfieldname)))) {
            ValueMetaString v = new ValueMetaString(realSQLCreation);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("    " + XMLHandler.addTagValue((String)"tablenamefieldname", (String)this.tablenamefieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"objecttypefieldname", (String)this.objecttypefieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"issystemobjectfieldname", (String)this.issystemobjectfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"sqlcreationfieldname", (String)this.sqlcreationfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"includeCatalog", (boolean)this.includeCatalog));
        retval.append("    " + XMLHandler.addTagValue((String)"includeSchema", (boolean)this.includeSchema));
        retval.append("    " + XMLHandler.addTagValue((String)"includeTable", (boolean)this.includeTable));
        retval.append("    " + XMLHandler.addTagValue((String)"includeView", (boolean)this.includeView));
        retval.append("    " + XMLHandler.addTagValue((String)"includeProcedure", (boolean)this.includeProcedure));
        retval.append("    " + XMLHandler.addTagValue((String)"includeSynonym", (boolean)this.includeSynonym));
        retval.append("    " + XMLHandler.addTagValue((String)"addSchemaInOutput", (boolean)this.addSchemaInOutput));
        retval.append("    " + XMLHandler.addTagValue((String)"dynamicSchema", (boolean)this.dynamicSchema));
        retval.append("    " + XMLHandler.addTagValue((String)"schenameNameField", (String)this.schenameNameField));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databases = databases;
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.database = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaname = XMLHandler.getTagValue((Node)stepnode, (String)"schemaname");
            this.tablenamefieldname = XMLHandler.getTagValue((Node)stepnode, (String)"tablenamefieldname");
            this.objecttypefieldname = XMLHandler.getTagValue((Node)stepnode, (String)"objecttypefieldname");
            this.sqlcreationfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"sqlcreationfieldname");
            this.issystemobjectfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"issystemobjectfieldname");
            this.includeCatalog = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeCatalog"));
            this.includeSchema = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeSchema"));
            this.includeTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeTable"));
            this.includeView = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeView"));
            this.includeProcedure = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeProcedure"));
            this.includeSynonym = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeSynonym"));
            this.addSchemaInOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addSchemaInOutput"));
            this.dynamicSchema = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicSchema"));
            this.schenameNameField = XMLHandler.getTagValue((Node)stepnode, (String)"schenameNameField");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"GetTableNamesMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databases = databases;
            this.database = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaname = rep.getStepAttributeString(id_step, "schemaname");
            this.tablenamefieldname = rep.getStepAttributeString(id_step, "tablenamefieldname");
            this.objecttypefieldname = rep.getStepAttributeString(id_step, "objecttypefieldname");
            this.sqlcreationfieldname = rep.getStepAttributeString(id_step, "sqlcreationfieldname");
            this.issystemobjectfieldname = rep.getStepAttributeString(id_step, "issystemobjectfieldname");
            this.includeCatalog = rep.getStepAttributeBoolean(id_step, "includeCatalog");
            this.includeSchema = rep.getStepAttributeBoolean(id_step, "includeSchema");
            this.includeTable = rep.getStepAttributeBoolean(id_step, "includeTable");
            this.includeView = rep.getStepAttributeBoolean(id_step, "includeView");
            this.includeProcedure = rep.getStepAttributeBoolean(id_step, "includeProcedure");
            this.includeSynonym = rep.getStepAttributeBoolean(id_step, "includeSynonym");
            this.addSchemaInOutput = rep.getStepAttributeBoolean(id_step, "addSchemaInOutput");
            this.dynamicSchema = rep.getStepAttributeBoolean(id_step, "dynamicSchema");
            this.schenameNameField = rep.getStepAttributeString(id_step, "schenameNameField");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetTableNamesMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.database);
            rep.saveStepAttribute(id_transformation, id_step, "schemaname", this.schemaname);
            rep.saveStepAttribute(id_transformation, id_step, "tablenamefieldname", this.tablenamefieldname);
            rep.saveStepAttribute(id_transformation, id_step, "objecttypefieldname", this.objecttypefieldname);
            rep.saveStepAttribute(id_transformation, id_step, "sqlcreationfieldname", this.sqlcreationfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "issystemobjectfieldname", this.issystemobjectfieldname);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getObjectId());
            }
            rep.saveStepAttribute(id_transformation, id_step, "includeCatalog", this.includeCatalog);
            rep.saveStepAttribute(id_transformation, id_step, "includeSchema", this.includeSchema);
            rep.saveStepAttribute(id_transformation, id_step, "includeTable", this.includeTable);
            rep.saveStepAttribute(id_transformation, id_step, "includeView", this.includeView);
            rep.saveStepAttribute(id_transformation, id_step, "includeProcedure", this.includeProcedure);
            rep.saveStepAttribute(id_transformation, id_step, "includeSynonym", this.includeSynonym);
            rep.saveStepAttribute(id_transformation, id_step, "addSchemaInOutput", this.addSchemaInOutput);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicSchema", this.dynamicSchema);
            rep.saveStepAttribute(id_transformation, id_step, "schenameNameField", this.schenameNameField);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetTableNamesMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.database == null) {
            error_message = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Utils.isEmpty((CharSequence)this.tablenamefieldname)) {
            error_message = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.TablenameFieldNameMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.TablenameFieldNameOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = input.length > 0 && !this.isDynamicSchema() ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetTableNames(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetTableNamesData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.database != null) {
            return new DatabaseMeta[]{this.database};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

