/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.combinationlookup;

import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesModelerMeta;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookup;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="CombinationLookup.Injection.")
public class CombinationLookupMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesModelerMeta {
    private static Class<?> PKG = CombinationLookupMeta.class;
    public static final int DEFAULT_CACHE_SIZE = 9999;
    private List<? extends SharedObjectInterface> databases;
    @Injection(name="SCHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tablename;
    private DatabaseMeta databaseMeta;
    @Injection(name="REPLACE_FIELDS")
    private boolean replaceFields;
    @Injection(name="KEY_FIELDS")
    private String[] keyField;
    @Injection(name="KEY_LOOKUP")
    private String[] keyLookup;
    @Injection(name="USE_HASH")
    private boolean useHash;
    @Injection(name="HASH_FIELD")
    private String hashField;
    @Injection(name="TECHNICAL_KEY_FIELD")
    private String technicalKeyField;
    @Injection(name="SEQUENCE_FROM")
    private String sequenceFrom;
    @Injection(name="COMMIT_SIZE")
    private int commitSize;
    @Injection(name="PRELOAD_CACHE")
    private boolean preloadCache = false;
    @Injection(name="CACHE_SIZE")
    private int cacheSize;
    @Injection(name="AUTO_INC")
    private boolean useAutoinc;
    @Injection(name="TECHNICAL_KEY_CREATION")
    private String techKeyCreation = null;
    @Injection(name="LAST_UPDATE_FIELD")
    private String lastUpdateField;
    public static String CREATION_METHOD_AUTOINC = "autoinc";
    public static String CREATION_METHOD_SEQUENCE = "sequence";
    public static String CREATION_METHOD_TABLEMAX = "tablemax";

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase(this.databases, (String)connectionName);
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public void setTechKeyCreation(String techKeyCreation) {
        this.techKeyCreation = techKeyCreation;
    }

    public String getTechKeyCreation() {
        return this.techKeyCreation;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getHashField() {
        return this.hashField;
    }

    public void setHashField(String hashField) {
        this.hashField = hashField;
    }

    public String[] getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String[] keyField) {
        this.keyField = keyField;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public boolean replaceFields() {
        return this.replaceFields;
    }

    public void setReplaceFields(boolean replaceFields) {
        this.replaceFields = replaceFields;
    }

    public void setPreloadCache(boolean preloadCache) {
        this.preloadCache = preloadCache;
    }

    public boolean getPreloadCache() {
        return this.preloadCache;
    }

    public String getSequenceFrom() {
        return this.sequenceFrom;
    }

    public void setSequenceFrom(String sequenceFrom) {
        this.sequenceFrom = sequenceFrom;
    }

    @Override
    public String getTableName() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTechnicalKeyField() {
        return this.technicalKeyField;
    }

    public void setTechnicalKeyField(String technicalKeyField) {
        this.technicalKeyField = technicalKeyField;
    }

    public boolean isUseAutoinc() {
        return this.useAutoinc;
    }

    public void setUseAutoinc(boolean useAutoinc) {
        this.useAutoinc = useAutoinc;
    }

    public boolean useHash() {
        return this.useHash;
    }

    public void setUseHash(boolean useHash) {
        this.useHash = useHash;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys) {
        this.keyField = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
    }

    @Override
    public Object clone() {
        CombinationLookupMeta retval = (CombinationLookupMeta)super.clone();
        int nrkeys = this.keyField.length;
        retval.allocate(nrkeys);
        System.arraycopy(this.keyField, 0, retval.keyField, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        this.databases = databases;
        try {
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tablename = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String commit = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = Const.toInt((String)commit, (int)0);
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"cache_size");
            this.cacheSize = Const.toInt((String)csize, (int)0);
            this.replaceFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"replace"));
            this.preloadCache = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"preloadCache"));
            this.useHash = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"crc"));
            this.hashField = XMLHandler.getTagValue((Node)stepnode, (String)"crcfield");
            Node keys = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrkeys = XMLHandler.countNodes((Node)keys, (String)"key");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)keys, (String)"key", (int)i);
                this.keyField[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"lookup");
            }
            this.sequenceFrom = XMLHandler.getTagValue((Node)stepnode, (String)"sequence");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            Node retkey = XMLHandler.getSubNode((Node)fields, (String)"return");
            this.technicalKeyField = XMLHandler.getTagValue((Node)retkey, (String)"name");
            this.useAutoinc = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)retkey, (String)"use_autoinc"));
            this.lastUpdateField = XMLHandler.getTagValue((Node)stepnode, (String)"last_update_field");
            this.setTechKeyCreation(XMLHandler.getTagValue((Node)retkey, (String)"creation_method"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.schemaName = "";
        this.tablename = BaseMessages.getString(PKG, (String)"CombinationLookupMeta.DimensionTableName.Label", (String[])new String[0]);
        this.databaseMeta = null;
        this.commitSize = 100;
        this.cacheSize = 9999;
        this.replaceFields = false;
        this.preloadCache = false;
        this.useHash = false;
        this.hashField = "hashcode";
        int nrkeys = 0;
        this.allocate(nrkeys);
        for (int i = 0; i < nrkeys; ++i) {
            this.keyField[i] = "key" + i;
            this.keyLookup[i] = "keylookup" + i;
        }
        this.technicalKeyField = "technical/surrogate key field";
        this.useAutoinc = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaInteger v = new ValueMetaInteger(this.technicalKeyField);
        v.setLength(10);
        v.setPrecision(0);
        v.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)v);
        if (this.replaceFields) {
            for (int i = 0; i < this.keyField.length; ++i) {
                int idx = row.indexOfValue(this.keyField[i]);
                if (idx < 0) continue;
                row.removeValueMeta(idx);
            }
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(512);
        retval.append("      ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replace", (boolean)this.replaceFields));
        retval.append("      ").append(XMLHandler.addTagValue((String)"preloadCache", (boolean)this.preloadCache));
        retval.append("      ").append(XMLHandler.addTagValue((String)"crc", (boolean)this.useHash));
        retval.append("      ").append(XMLHandler.addTagValue((String)"crcfield", (String)this.hashField));
        retval.append("      <fields>").append(Const.CR);
        for (int i = 0; i < this.keyField.length; ++i) {
            retval.append("        <key>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.keyField[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"lookup", (String)this.keyLookup[i]));
            retval.append("        </key>").append(Const.CR);
        }
        retval.append("        <return>").append(Const.CR);
        retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.technicalKeyField));
        retval.append("          ").append(XMLHandler.addTagValue((String)"creation_method", (String)this.techKeyCreation));
        retval.append("          ").append(XMLHandler.addTagValue((String)"use_autoinc", (boolean)this.useAutoinc));
        retval.append("        </return>").append(Const.CR);
        retval.append("      </fields>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"sequence", (String)this.sequenceFrom));
        retval.append("      ").append(XMLHandler.addTagValue((String)"last_update_field", (String)this.lastUpdateField));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.databases = databases;
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tablename = rep.getStepAttributeString(id_step, "table");
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.cacheSize = (int)rep.getStepAttributeInteger(id_step, "cache_size");
            this.replaceFields = rep.getStepAttributeBoolean(id_step, "replace");
            this.preloadCache = rep.getStepAttributeBoolean(id_step, "preloadCache");
            this.useHash = rep.getStepAttributeBoolean(id_step, "crc");
            this.hashField = rep.getStepAttributeString(id_step, "crcfield");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                this.keyField[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
            }
            this.technicalKeyField = rep.getStepAttributeString(id_step, "return_name");
            this.useAutoinc = rep.getStepAttributeBoolean(id_step, "use_autoinc");
            this.sequenceFrom = rep.getStepAttributeString(id_step, "sequence");
            this.techKeyCreation = rep.getStepAttributeString(id_step, "creation_method");
            this.lastUpdateField = rep.getStepAttributeString(id_step, "last_update_field");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.Exception.UnexpectedErrorWhileReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tablename);
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "cache_size", this.cacheSize);
            rep.saveStepAttribute(id_transformation, id_step, "replace", this.replaceFields);
            rep.saveStepAttribute(id_transformation, id_step, "preloadCache", this.preloadCache);
            rep.saveStepAttribute(id_transformation, id_step, "crc", this.useHash);
            rep.saveStepAttribute(id_transformation, id_step, "crcfield", this.hashField);
            for (int i = 0; i < this.keyField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_name", this.keyField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_field", this.keyLookup[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "return_name", this.technicalKeyField);
            rep.saveStepAttribute(id_transformation, id_step, "sequence", this.sequenceFrom);
            rep.saveStepAttribute(id_transformation, id_step, "creation_method", this.techKeyCreation);
            rep.saveStepAttribute(id_transformation, id_step, "use_autoinc", this.useAutoinc);
            rep.saveStepAttribute(id_transformation, id_step, "last_update_field", this.lastUpdateField);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        error_message = "";
        if (this.databaseMeta != null) {
            db = new Database(CombinationLookupMeta.loggingObject, this.databaseMeta);
            try {
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tablename)) {
                    first = true;
                    error_found = false;
                    error_message = "";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tablename);
                    r = db.getTableFields(schemaTable);
                    if (r != null) {
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.MissingCompareFields", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found != false ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        if (r.indexOfValue(this.technicalKeyField) < 0) {
                            error_message = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{this.technicalKeyField}) + Const.CR;
                            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        } else {
                            error_message = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{this.technicalKeyField}) + Const.CR;
                            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
                        }
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (i = 0; i < this.keyField.length; ++i) {
                        v = prev.searchValueMeta(this.keyField[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.MissingFields", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyField[i] + Const.CR;
                    }
                    cr = error_found != false ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.AllFieldsFoundInInputStream", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    error_message = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.CouldNotReadFields", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (this.databaseMeta.supportsSequences() && CombinationLookupMeta.CREATION_METHOD_SEQUENCE.equals(this.getTechKeyCreation())) {
                    if (Utils.isEmpty((CharSequence)this.sequenceFrom)) {
                        error_message = error_message + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorNoSequenceName", (String[])new String[0]) + "!";
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else if (db.checkSequenceExists(this.sequenceFrom)) {
                        error_message = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ReadingSequenceOK", (String[])new String[]{this.sequenceFrom});
                        cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = error_message + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorReadingSequence", (String[])new String[0]) + this.sequenceFrom + "!";
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (this.techKeyCreation == null || CombinationLookupMeta.CREATION_METHOD_AUTOINC.equals(this.techKeyCreation) || CombinationLookupMeta.CREATION_METHOD_SEQUENCE.equals(this.techKeyCreation) || CombinationLookupMeta.CREATION_METHOD_TABLEMAX.equals(this.techKeyCreation)) ** GOTO lbl96
                error_message = error_message + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorTechKeyCreation", (String[])new String[0]) + ": " + this.techKeyCreation + "!";
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
lbl96:
        // 4 sources

        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Utils.isEmpty((CharSequence)this.tablename)) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tablename);
                    Database db = new Database(loggingObject, this.databaseMeta);
                    try {
                        String[] techKeyArr;
                        ValueMetaInterface v;
                        int i;
                        boolean doHash = false;
                        String cr_table = null;
                        db.connect();
                        RowMeta fields = new RowMeta();
                        ValueMetaInteger vkeyfield = new ValueMetaInteger(this.technicalKeyField);
                        vkeyfield.setLength(10);
                        vkeyfield.setPrecision(0);
                        ValueMetaInteger vhashfield = null;
                        if (this.useHash && !Utils.isEmpty((CharSequence)this.hashField)) {
                            vhashfield = new ValueMetaInteger(this.hashField);
                            vhashfield.setLength(15);
                            vhashfield.setPrecision(0);
                            doHash = true;
                        }
                        ValueMetaDate vLastUpdateField = null;
                        if (!Utils.isEmpty((CharSequence)this.lastUpdateField)) {
                            vLastUpdateField = new ValueMetaDate(this.lastUpdateField);
                        }
                        if (!db.checkTableExists(schemaTable)) {
                            fields.addValueMeta((ValueMetaInterface)vkeyfield);
                            if (this.keyField != null && this.keyLookup != null) {
                                int cnt = this.keyField.length;
                                for (i = 0; i < cnt; ++i) {
                                    String error_field = "";
                                    v = prev.searchValueMeta(this.keyField[i]);
                                    if (v == null) continue;
                                    String name = this.keyLookup[i];
                                    ValueMetaInterface newValue = v.clone();
                                    newValue.setName(name);
                                    if (name.equals(vkeyfield.getName()) || doHash && name.equals(vhashfield.getName())) {
                                        error_field = error_field + name;
                                    }
                                    if (error_field.length() > 0) {
                                        retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NameCollision", (String[])new String[]{error_field}));
                                        continue;
                                    }
                                    fields.addValueMeta(newValue);
                                }
                            }
                            if (doHash) {
                                fields.addValueMeta((ValueMetaInterface)vhashfield);
                            }
                            if (vLastUpdateField != null) {
                                fields.addValueMeta((ValueMetaInterface)vLastUpdateField);
                            }
                        } else {
                            RowMetaInterface tabFields = db.getTableFields(schemaTable);
                            this.databaseMeta.quoteReservedWords(tabFields);
                            if (tabFields.searchValueMeta(vkeyfield.getName()) == null) {
                                fields.addValueMeta((ValueMetaInterface)vkeyfield);
                            }
                            int cnt = tabFields.size();
                            for (i = 0; i < cnt; ++i) {
                                v = tabFields.getValueMeta(i);
                                fields.addValueMeta(v);
                            }
                            String[] keyLookup = this.getKeyLookup();
                            String[] keyField = this.getKeyField();
                            if (keyField != null && keyLookup != null) {
                                cnt = keyField.length;
                                for (i = 0; i < cnt; ++i) {
                                    ValueMetaInterface v2 = prev.searchValueMeta(keyField[i]);
                                    if (v2 == null) continue;
                                    ValueMetaInterface newValue = v2.clone();
                                    newValue.setName(keyLookup[i]);
                                    if (tabFields.searchValueMeta(newValue.getName()) != null) continue;
                                    fields.addValueMeta(newValue);
                                }
                            }
                            if (doHash && tabFields.searchValueMeta(vhashfield.getName()) == null) {
                                fields.addValueMeta((ValueMetaInterface)vhashfield);
                            }
                            if (vLastUpdateField != null && tabFields.searchValueMeta(vLastUpdateField.getName()) == null) {
                                fields.addValueMeta((ValueMetaInterface)vLastUpdateField);
                            }
                        }
                        cr_table = db.getDDL(schemaTable, (RowMetaInterface)fields, (String)(CREATION_METHOD_SEQUENCE.equals(this.getTechKeyCreation()) && this.sequenceFrom != null && this.sequenceFrom.length() != 0 ? null : this.technicalKeyField), CREATION_METHOD_AUTOINC.equals(this.getTechKeyCreation()), null, true);
                        String cr_index = "";
                        String cr_uniq_index = "";
                        CharSequence[] idx_fields = null;
                        if (this.useHash) {
                            if (this.hashField != null && this.hashField.length() > 0) {
                                idx_fields = new String[]{this.hashField};
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotHashFieldSpecified", (String[])new String[0]));
                            }
                        } else if (!Utils.isEmpty((CharSequence[])this.keyLookup)) {
                            int nrfields = this.keyLookup.length;
                            int maxFields = this.databaseMeta.getMaxColumnsInIndex();
                            if (maxFields > 0 && nrfields > maxFields) {
                                nrfields = maxFields;
                            }
                            idx_fields = new String[nrfields];
                            for (i = 0; i < nrfields; ++i) {
                                idx_fields[i] = this.keyLookup[i];
                            }
                        } else {
                            retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotFieldsSpecified", (String[])new String[0]));
                        }
                        if (!Utils.isEmpty((CharSequence)this.technicalKeyField) && !db.checkIndexExists(schemaTable, techKeyArr = new String[]{this.technicalKeyField})) {
                            String indexname = "idx_" + this.tablename + "_pk";
                            cr_uniq_index = db.getCreateIndexStatement(schemaTable, indexname, techKeyArr, true, true, false, true);
                            cr_uniq_index = cr_uniq_index + Const.CR;
                        }
                        if (!Utils.isEmpty((CharSequence[])idx_fields) && !db.checkIndexExists(schemaTable, (String[])idx_fields)) {
                            String indexname = "idx_" + this.tablename + "_lookup";
                            cr_index = db.getCreateIndexStatement(schemaTable, indexname, (String[])idx_fields, false, false, false, true);
                            cr_index = cr_index + Const.CR;
                        }
                        String cr_seq = "";
                        if (this.databaseMeta.supportsSequences() && !Utils.isEmpty((CharSequence)this.sequenceFrom) && !db.checkSequenceExists(this.schemaName, this.sequenceFrom)) {
                            cr_seq = cr_seq + db.getCreateSequenceStatement(this.schemaName, this.sequenceFrom, 1L, 1L, -1L, true);
                            cr_seq = cr_seq + Const.CR;
                        }
                        retval.setSQL(transMeta.environmentSubstitute(cr_table + cr_uniq_index + cr_index + cr_seq));
                    }
                    catch (KettleException e) {
                        retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotTableDefined", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotReceivingField", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotConnectionDefined", (String[])new String[0]));
        }
        return retval;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new CombinationLookup(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CombinationLookupData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) {
        for (int i = 0; i < this.keyField.length; ++i) {
            ValueMetaInterface v = prev.searchValueMeta(this.keyField[i]);
            DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tablename, this.keyLookup[i], this.keyField[i], v != null ? v.getOrigin() : "?", "", this.useHash ? BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReadAndInsert.Label", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"CombinationLookupMeta.LookupAndInsert.Label", (String[])new String[0]));
            impact.add(ii);
        }
        if (this.useHash) {
            DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tablename, this.hashField, "", "", "", BaseMessages.getString(PKG, (String)"CombinationLookupMeta.KeyLookup.Label", (String[])new String[0]));
            impact.add(ii);
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CombinationLookupMeta o = (CombinationLookupMeta)other;
        if (this.getCommitSize() != o.getCommitSize()) {
            return false;
        }
        if (this.getCacheSize() != o.getCacheSize()) {
            return false;
        }
        if (!this.getTechKeyCreation().equals(o.getTechKeyCreation())) {
            return false;
        }
        if (this.replaceFields() != o.replaceFields()) {
            return false;
        }
        if (this.useHash() != o.useHash()) {
            return false;
        }
        if (this.getPreloadCache() != o.getPreloadCache()) {
            return false;
        }
        if (this.getSequenceFrom() == null && o.getSequenceFrom() != null || this.getSequenceFrom() != null && o.getSequenceFrom() == null || this.getSequenceFrom() != null && o.getSequenceFrom() != null && !this.getSequenceFrom().equals(o.getSequenceFrom())) {
            return false;
        }
        if (this.getSchemaName() == null && o.getSchemaName() != null || this.getSchemaName() != null && o.getSchemaName() == null || this.getSchemaName() != null && o.getSchemaName() != null && !this.getSchemaName().equals(o.getSchemaName())) {
            return false;
        }
        if (this.getTableName() == null && o.getTableName() != null || this.getTableName() != null && o.getTableName() == null || this.getTableName() != null && o.getTableName() != null && !this.getTableName().equals(o.getTableName())) {
            return false;
        }
        if (this.getHashField() == null && o.getHashField() != null || this.getHashField() != null && o.getHashField() == null || this.getHashField() != null && o.getHashField() != null && !this.getHashField().equals(o.getHashField())) {
            return false;
        }
        return !(this.getTechnicalKeyField() == null && o.getTechnicalKeyField() != null || this.getTechnicalKeyField() != null && o.getTechnicalKeyField() == null) && (this.getTechnicalKeyField() == null || o.getTechnicalKeyField() == null || this.getTechnicalKeyField().equals(o.getTechnicalKeyField()));
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getLastUpdateField() {
        return this.lastUpdateField;
    }

    public void setLastUpdateField(String lastUpdateField) {
        this.lastUpdateField = lastUpdateField;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    protected RowMetaInterface getDatabaseTableFields(Database db, String schemaName, String tableName) throws KettleDatabaseException {
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        RowMetaInterface extraFields = db.getTableFields(schemaTable);
        if (extraFields == null) {
            db.connect();
            extraFields = db.getTableFields(schemaTable);
        }
        return extraFields;
    }

    Database createDatabaseObject() {
        return new Database(loggingObject, this.databaseMeta);
    }

    @Override
    public RowMeta getRowMeta(StepDataInterface stepData) {
        try {
            return (RowMeta)this.getDatabaseTableFields(this.createDatabaseObject(), this.schemaName, this.getTableName());
        }
        catch (KettleDatabaseException e) {
            this.log.logError("", (Throwable)e);
            return new RowMeta();
        }
    }

    @Override
    public List<String> getDatabaseFields() {
        return Arrays.asList(this.keyLookup);
    }

    @Override
    public List<String> getStreamFields() {
        return Arrays.asList(this.keyField);
    }
}

