/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.metrics.MetricsDuration;
import org.pentaho.di.core.util.Utils;

public class MetricsPainter {
    private GCInterface gc;
    private Long periodStart = null;
    private Long periodEnd = null;
    private int barHeight;

    public MetricsPainter(GCInterface gc, int barHeight) {
        this.setGc(gc);
        this.barHeight = barHeight;
    }

    public List<MetricsDrawArea> paint(List<MetricsDuration> durations) {
        if (Utils.isEmpty(durations)) {
            throw new IllegalArgumentException();
        }
        int width = this.getGc().getArea().x - 4;
        int height = this.getGc().getArea().y - 4;
        ArrayList<MetricsDrawArea> areas = new ArrayList<MetricsDrawArea>();
        this.determinePeriod(durations);
        if (this.periodStart == null || this.periodEnd == null || this.periodEnd <= this.periodStart) {
            return areas;
        }
        double pixelsPerMs = (double)width / (double)(this.periodEnd - this.periodStart);
        long periodInMs = this.periodEnd - this.periodStart;
        this.drawTimeScaleLine(height, pixelsPerMs, periodInMs);
        this.drawDurations(durations, areas, pixelsPerMs);
        return areas;
    }

    void drawTimeScaleLine(int height, double pixelsPerMs, long periodInMs) {
        int log10 = (int)Math.log10(periodInMs) + 1;
        int timeLineDistance = (int)Math.pow(10.0, log10 - 1) / 2;
        int incrementUnit = Math.max(timeLineDistance, 1);
        int time = timeLineDistance;
        while ((long)time <= periodInMs) {
            int x = (int)((double)time * pixelsPerMs);
            this.getGc().setForeground(PrimitiveGCInterface.EColor.LIGHTGRAY);
            this.getGc().drawLine(x, 0, x, height);
            String marker = Integer.toString(time);
            Point point = this.getGc().textExtent(marker);
            this.getGc().setForeground(PrimitiveGCInterface.EColor.DARKGRAY);
            this.getGc().drawText(marker, x - point.x / 2, 0, true);
            time += incrementUnit;
        }
    }

    private void drawDurations(List<MetricsDuration> durations, List<MetricsDrawArea> areas, double pixelsPerMs) {
        int y = 20;
        for (MetricsDuration duration : durations) {
            Long realDuration = duration.getEndDate().getTime() - duration.getDate().getTime();
            int durationWidth = (int)((double)realDuration.longValue() * pixelsPerMs);
            int x = 2 + (int)((double)(duration.getDate().getTime() - this.periodStart) * pixelsPerMs);
            this.getGc().setBackground(PrimitiveGCInterface.EColor.BACKGROUND);
            this.getGc().setForeground(PrimitiveGCInterface.EColor.LIGHTBLUE);
            this.getGc().fillGradientRectangle(x, y, durationWidth, this.barHeight, false);
            this.getGc().setForeground(PrimitiveGCInterface.EColor.BLACK);
            this.getGc().drawRectangle(x, y, durationWidth, this.barHeight);
            areas.add(new MetricsDrawArea(new Rectangle(x, y, durationWidth, this.barHeight), duration));
            LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(duration.getLogChannelId());
            String message = duration.getDescription() + " - " + loggingObject.getObjectName() + " : " + duration.getDuration() + "ms";
            if (duration.getCount() > 1L) {
                message = message + " " + duration.getCount() + " calls, avg=" + duration.getDuration() / duration.getCount();
            }
            this.getGc().setFont(PrimitiveGCInterface.EFont.GRAPH);
            this.getGc().textExtent(message);
            this.getGc().drawText(message, x + 3, y + 4, true);
            y += this.barHeight + 5;
        }
    }

    private void determinePeriod(List<MetricsDuration> durations) {
        this.periodStart = null;
        this.periodEnd = null;
        for (MetricsDuration duration : durations) {
            long periodStartTime = duration.getDate().getTime();
            if (this.periodStart == null || periodStartTime < this.periodStart) {
                this.periodStart = periodStartTime;
            }
            long periodEndTime = duration.getEndDate().getTime();
            if (this.periodEnd != null && this.periodEnd >= periodEndTime) continue;
            this.periodEnd = periodEndTime;
        }
    }

    GCInterface getGc() {
        return this.gc;
    }

    void setGc(GCInterface gc) {
        this.gc = gc;
    }

    public class MetricsDrawArea {
        private Rectangle area;
        private MetricsDuration duration;

        public MetricsDrawArea(Rectangle area, MetricsDuration duration) {
            this.area = area;
            this.duration = duration;
        }

        public MetricsDuration getDuration() {
            return this.duration;
        }

        public Rectangle getArea() {
            return this.area;
        }
    }
}

