/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.compress.CompressionPlugin;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=CompressionProvider.class)
@PluginAnnotationType(value=CompressionPlugin.class)
public class CompressionPluginType
extends BasePluginType
implements PluginTypeInterface {
    protected static CompressionPluginType pluginType;

    private CompressionPluginType() {
        super(CompressionPlugin.class, "COMPRESSION", "Compression");
        this.populateFolders("compress");
    }

    public static CompressionPluginType getInstance() {
        if (pluginType == null) {
            pluginType = new CompressionPluginType();
        }
        return pluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String xmlFile = "kettle-compression-providers.xml";
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(xmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + xmlFile);
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native kettle compression providers definition file: " + xmlFile);
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node repsNode = XMLHandler.getSubNode((Node)document, (String)"compression-providers");
            List repsNodes = XMLHandler.getNodes((Node)repsNode, (String)"compression-provider");
            for (Node repNode : repsNodes) {
                this.registerPluginFromXmlResource(repNode, "./", ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle compression providers config file: " + xmlFile, (Throwable)e);
        }
    }

    protected void registerXmlPlugins() throws KettlePluginException {
    }

    public void handlePluginAnnotation(Class<?> clazz, Annotation annotation, List<String> libraries, boolean nativePluginType, URL pluginFolder) throws KettlePluginException {
        super.handlePluginAnnotation(clazz, annotation, libraries, nativePluginType, pluginFolder);
    }

    public String[] getNaturalCategoriesOrder() {
        return new String[0];
    }

    protected String extractCategory(Annotation annotation) {
        return "";
    }

    protected String extractDesc(Annotation annotation) {
        return ((CompressionPlugin)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((CompressionPlugin)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((CompressionPlugin)annotation).name();
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((CompressionPlugin)annotation).isSeparateClassLoaderNeeded();
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((CompressionPlugin)annotation).i18nPackageName();
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return ((CompressionPlugin)annotation).documentationUrl();
    }

    protected String extractCasesUrl(Annotation annotation) {
        return ((CompressionPlugin)annotation).casesUrl();
    }

    protected String extractForumUrl(Annotation annotation) {
        return ((CompressionPlugin)annotation).forumUrl();
    }

    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((CompressionPlugin)annotation).classLoaderGroup();
    }
}

