/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ExecutorInterface;
import org.pentaho.di.core.JndiUtil;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleVariablesList;
import org.pentaho.di.core.auth.AuthenticationConsumerPluginType;
import org.pentaho.di.core.auth.AuthenticationProviderPluginType;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.lifecycle.KettleLifecycleSupport;
import org.pentaho.di.core.logging.LogTablePluginType;
import org.pentaho.di.core.plugins.CartePluginType;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PartitionerPluginType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.RowDistributionPluginType;

public class KettleEnvironment {
    private static Class<?> PKG = Const.class;
    private static AtomicReference<SettableFuture<Boolean>> initialized = new AtomicReference<Object>(null);
    private static KettleLifecycleSupport kettleLifecycleSupport;

    public static void init() throws KettleException {
        KettleEnvironment.init(true);
    }

    public static void init(boolean simpleJndi) throws KettleException {
        SettableFuture<Boolean> ready = SettableFuture.create();
        if (initialized.compareAndSet(null, ready)) {
            try {
                if (!KettleClientEnvironment.isInitialized()) {
                    KettleClientEnvironment.init();
                }
                if (simpleJndi) {
                    JndiUtil.initJNDI();
                }
                PluginRegistry.addPluginType((PluginTypeInterface)RowDistributionPluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)StepPluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)PartitionerPluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)JobEntryPluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)LogTablePluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)RepositoryPluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)LifecyclePluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)KettleLifecyclePluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)ImportRulePluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)CartePluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)AuthenticationProviderPluginType.getInstance());
                PluginRegistry.addPluginType((PluginTypeInterface)AuthenticationConsumerPluginType.getInstance());
                PluginRegistry.init();
                KettleVariablesList.init();
                KettleEnvironment.initLifecycleListeners();
                ready.set((Object)true);
            }
            catch (Throwable t) {
                ready.setException(t);
                throw t instanceof KettleException ? (KettleException)t : new KettleException(t);
            }
        }
        ready = initialized.get();
        try {
            ready.get();
        }
        catch (Throwable t) {
            throw t instanceof KettleException ? (KettleException)t : new KettleException(t);
        }
    }

    private static void initLifecycleListeners() throws KettleException {
        kettleLifecycleSupport = new KettleLifecycleSupport();
        kettleLifecycleSupport.onEnvironmentInit();
        final KettleLifecycleSupport s = kettleLifecycleSupport;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                KettleEnvironment.shutdown(s);
            }
        });
    }

    public static void shutdown() {
        KettleEnvironment.shutdown(kettleLifecycleSupport);
    }

    private static void shutdown(KettleLifecycleSupport kettleLifecycleSupport) {
        try {
            kettleLifecycleSupport.onEnvironmentShutdown();
        }
        catch (Throwable t) {
            System.err.println(BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleEnvironmentShutdownListeners", (String[])new String[0]));
            t.printStackTrace();
        }
    }

    public static boolean isInitialized() {
        Future future = (Future)initialized.get();
        try {
            return future != null && (Boolean)future.get() != false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void loadPluginRegistry() throws KettlePluginException {
    }

    public static void setExecutionInformation(ExecutorInterface executor, Repository repository) {
        IUser userInfo;
        executor.setExecutingUser(System.getProperty("user.name"));
        if (repository != null && (userInfo = repository.getUserInfo()) != null) {
            executor.setExecutingUser(userInfo.getLogin());
        }
    }
}

