/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.repository.ObjectId;
import org.w3c.dom.Node;

public class Condition
implements Cloneable,
XMLInterface {
    public static final String XML_TAG = "condition";
    public static final String[] operators = new String[]{"-", "OR", "AND", "NOT", "OR NOT", "AND NOT", "XOR"};
    public static final int OPERATOR_NONE = 0;
    public static final int OPERATOR_OR = 1;
    public static final int OPERATOR_AND = 2;
    public static final int OPERATOR_NOT = 3;
    public static final int OPERATOR_OR_NOT = 4;
    public static final int OPERATOR_AND_NOT = 5;
    public static final int OPERATOR_XOR = 6;
    public static final String[] functions = new String[]{"=", "<>", "<", "<=", ">", ">=", "REGEXP", "IS NULL", "IS NOT NULL", "IN LIST", "CONTAINS", "STARTS WITH", "ENDS WITH", "LIKE", "TRUE"};
    public static final int FUNC_EQUAL = 0;
    public static final int FUNC_NOT_EQUAL = 1;
    public static final int FUNC_SMALLER = 2;
    public static final int FUNC_SMALLER_EQUAL = 3;
    public static final int FUNC_LARGER = 4;
    public static final int FUNC_LARGER_EQUAL = 5;
    public static final int FUNC_REGEXP = 6;
    public static final int FUNC_NULL = 7;
    public static final int FUNC_NOT_NULL = 8;
    public static final int FUNC_IN_LIST = 9;
    public static final int FUNC_CONTAINS = 10;
    public static final int FUNC_STARTS_WITH = 11;
    public static final int FUNC_ENDS_WITH = 12;
    public static final int FUNC_LIKE = 13;
    public static final int FUNC_TRUE = 14;
    private ObjectId id = null;
    private boolean negate = false;
    private int operator = 0;
    private String left_valuename;
    private int function;
    private String right_valuename;
    private ValueMetaAndData right_exact;
    private ObjectId id_right_exact;
    private int left_fieldnr = -2;
    private int right_fieldnr = -2;
    private List<Condition> list = new ArrayList<Condition>();
    private String right_string;
    private String[] inList;

    public Condition() {
    }

    public Condition(String valuename, int function, String valuename2, ValueMetaAndData exact) {
        this();
        this.left_valuename = valuename;
        this.function = function;
        this.right_valuename = valuename2;
        this.right_exact = exact;
        this.clearFieldPositions();
    }

    public Condition(int operator, String valuename, int function, String valuename2, ValueMetaAndData exact) {
        this();
        this.operator = operator;
        this.left_valuename = valuename;
        this.function = function;
        this.right_valuename = valuename2;
        this.right_exact = exact;
        this.clearFieldPositions();
    }

    public Condition(boolean negate, String valuename, int function, String valuename2, ValueMetaAndData exact) {
        this(valuename, function, valuename2, exact);
        this.negate = negate;
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public Object clone() {
        Condition retval = null;
        retval = new Condition();
        retval.negate = this.negate;
        retval.operator = this.operator;
        if (this.isComposite()) {
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition c = this.getCondition(i);
                Condition cCopy = (Condition)c.clone();
                retval.addCondition(cCopy);
            }
        } else {
            retval.negate = this.negate;
            retval.left_valuename = this.left_valuename;
            retval.operator = this.operator;
            retval.right_valuename = this.right_valuename;
            retval.function = this.function;
            retval.right_exact = this.right_exact != null ? (ValueMetaAndData)this.right_exact.clone() : null;
        }
        return retval;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getOperatorDesc() {
        return Const.rightPad(operators[this.operator], 7);
    }

    public static final int getOperator(String description) {
        if (description == null) {
            return 0;
        }
        for (int i = 1; i < operators.length; ++i) {
            if (!operators[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public static final String[] getOperators() {
        String[] retval = new String[operators.length - 1];
        for (int i = 1; i < operators.length; ++i) {
            retval[i - 1] = operators[i];
        }
        return retval;
    }

    public static final String[] getRealOperators() {
        return new String[]{"OR", "AND", "OR NOT", "AND NOT", "XOR"};
    }

    public void setLeftValuename(String left_valuename) {
        this.left_valuename = left_valuename;
    }

    public String getLeftValuename() {
        return this.left_valuename;
    }

    public int getFunction() {
        return this.function;
    }

    public void setFunction(int function) {
        this.function = function;
    }

    public String getFunctionDesc() {
        return functions[this.function];
    }

    public static final int getFunction(String description) {
        for (int i = 1; i < functions.length; ++i) {
            if (!functions[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public void setRightValuename(String right_valuename) {
        this.right_valuename = right_valuename;
    }

    public String getRightValuename() {
        return this.right_valuename;
    }

    public void setRightExact(ValueMetaAndData right_exact) {
        this.right_exact = right_exact;
    }

    public ValueMetaAndData getRightExact() {
        return this.right_exact;
    }

    public String getRightExactString() {
        if (this.right_exact == null) {
            return null;
        }
        return this.right_exact.toString();
    }

    public ObjectId getRightExactID() {
        return this.id_right_exact;
    }

    public void setRightExactID(ObjectId id_right_exact) {
        this.id_right_exact = id_right_exact;
    }

    public boolean isAtomic() {
        return this.list.size() == 0;
    }

    public boolean isComposite() {
        return this.list.size() != 0;
    }

    public boolean isNegated() {
        return this.negate;
    }

    public void setNegated(boolean negate) {
        this.negate = negate;
    }

    public void negate() {
        this.setNegated(!this.isNegated());
    }

    public boolean isEmpty() {
        return this.isAtomic() && this.left_valuename == null;
    }

    public void clearFieldPositions() {
        this.left_fieldnr = -2;
        this.right_fieldnr = -2;
    }

    public boolean evaluate(RowMetaInterface rowMeta, Object[] r) {
        boolean retval = false;
        try {
            if (this.isAtomic()) {
                Object field2;
                if (this.function == 14) {
                    return !this.negate;
                }
                if (this.left_valuename != null && this.left_valuename.length() > 0 && this.left_fieldnr < -1) {
                    this.left_fieldnr = rowMeta.indexOfValue(this.left_valuename);
                }
                if (this.right_valuename != null && this.right_valuename.length() > 0 && this.right_fieldnr < -1) {
                    this.right_fieldnr = rowMeta.indexOfValue(this.right_valuename);
                }
                ValueMetaInterface fieldMeta = null;
                Object field = null;
                if (this.left_fieldnr < 0) {
                    return false;
                }
                fieldMeta = rowMeta.getValueMeta(this.left_fieldnr);
                field = r[this.left_fieldnr];
                ValueMetaInterface fieldMeta2 = this.right_exact != null ? this.right_exact.getValueMeta() : null;
                Object object = field2 = this.right_exact != null ? this.right_exact.getValueData() : null;
                if (field2 == null && this.right_fieldnr >= 0) {
                    fieldMeta2 = rowMeta.getValueMeta(this.right_fieldnr);
                    field2 = r[this.right_fieldnr];
                }
                switch (this.function) {
                    case 0: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) == 0;
                        break;
                    }
                    case 1: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) != 0;
                        break;
                    }
                    case 2: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) < 0;
                        break;
                    }
                    case 3: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) <= 0;
                        break;
                    }
                    case 4: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) > 0;
                        break;
                    }
                    case 5: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) >= 0;
                        break;
                    }
                    case 6: {
                        if (fieldMeta.isNull(field) || field2 == null) {
                            retval = false;
                            break;
                        }
                        retval = Pattern.matches(fieldMeta2.getCompatibleString(field2), fieldMeta.getCompatibleString(field));
                        break;
                    }
                    case 7: {
                        retval = fieldMeta.isNull(field);
                        break;
                    }
                    case 8: {
                        retval = !fieldMeta.isNull(field);
                        break;
                    }
                    case 9: {
                        if (this.inList == null || this.right_fieldnr >= 0) {
                            this.inList = Const.splitString(fieldMeta2.getString(field2), ';', true);
                            for (int i = 0; i < this.inList.length; ++i) {
                                this.inList[i] = this.inList[i] == null ? null : this.inList[i].replace("\\", "");
                            }
                            Arrays.sort(this.inList);
                        }
                        String searchString = fieldMeta.getCompatibleString(field);
                        int inIndex = -1;
                        if (searchString != null) {
                            inIndex = Arrays.binarySearch(this.inList, searchString);
                        }
                        retval = inIndex >= 0;
                        break;
                    }
                    case 10: {
                        retval = fieldMeta.getCompatibleString(field) != null ? fieldMeta.getCompatibleString(field).indexOf(fieldMeta2.getCompatibleString(field2)) >= 0 : false;
                        break;
                    }
                    case 11: {
                        retval = fieldMeta.getCompatibleString(field) != null ? fieldMeta.getCompatibleString(field).startsWith(fieldMeta2.getCompatibleString(field2)) : false;
                        break;
                    }
                    case 12: {
                        String string = fieldMeta.getCompatibleString(field);
                        if (!Utils.isEmpty(string)) {
                            if (this.right_string == null && field2 != null) {
                                this.right_string = fieldMeta2.getCompatibleString(field2);
                            }
                            if (this.right_string != null) {
                                retval = string.endsWith(fieldMeta2.getCompatibleString(field2));
                                break;
                            }
                            retval = false;
                            break;
                        }
                        retval = false;
                        break;
                    }
                    case 13: {
                        if (fieldMeta.isNull(field) || field2 == null) {
                            retval = false;
                            break;
                        }
                        String regex = fieldMeta2.getCompatibleString(field2);
                        regex = regex.replace("%", ".*");
                        regex = regex.replace("?", ".");
                        retval = Pattern.matches(regex, fieldMeta.getCompatibleString(field));
                        break;
                    }
                }
                if (this.isNegated()) {
                    retval = !retval;
                }
            } else {
                Condition cb0 = this.list.get(0);
                retval = cb0.evaluate(rowMeta, r);
                block26: for (int i = 1; i < this.list.size(); ++i) {
                    Condition cb = this.list.get(i);
                    switch (cb.getOperator()) {
                        case 1: {
                            retval = retval || cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 2: {
                            retval = retval && cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 4: {
                            retval = retval || !cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 5: {
                            retval = retval && !cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 6: {
                            retval ^= cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                    }
                }
                if (this.isNegated()) {
                    retval = !retval;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error evaluation condition [" + this.toString() + "]", e);
        }
        return retval;
    }

    public void addCondition(Condition cb) {
        if (this.isAtomic() && this.getLeftValuename() != null) {
            Condition current = new Condition(this.getLeftValuename(), this.getFunction(), this.getRightValuename(), this.getRightExact());
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.list.add(current);
        } else if (this.isComposite() && this.list.size() > 0 && cb.getOperator() == 0) {
            cb.setOperator(2);
        }
        this.list.add(cb);
    }

    public void addCondition(int idx, Condition cb) {
        if (this.isAtomic() && this.getLeftValuename() != null) {
            Condition current = new Condition(this.getLeftValuename(), this.getFunction(), this.getRightValuename(), this.getRightExact());
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.list.add(current);
        } else if (this.isComposite() && idx > 0 && cb.getOperator() == 0) {
            cb.setOperator(2);
        }
        this.list.add(idx, cb);
    }

    public void removeCondition(int nr) {
        if (this.isComposite()) {
            boolean moveUp;
            Condition c = this.list.get(nr);
            this.list.remove(nr);
            boolean bl = moveUp = this.isAtomic() || this.nrConditions() == 1;
            if (this.nrConditions() == 1) {
                c = this.getCondition(0);
            }
            if (moveUp) {
                this.setLeftValuename(c.getLeftValuename());
                this.setFunction(c.getFunction());
                this.setRightValuename(c.getRightValuename());
                this.setRightExact(c.getRightExact());
                this.setNegated(this.isNegated() ^ c.isNegated());
            }
        }
    }

    public boolean simplify() {
        Condition condition;
        if (this.nrConditions() == 1 && (condition = this.getCondition(0)).isAtomic()) {
            return this.simplify(condition, this);
        }
        boolean changed = false;
        for (int i = 0; i < this.nrConditions(); ++i) {
            Condition condition2 = this.getCondition(i);
            changed |= condition2.simplify();
            if (i != 0) continue;
            condition2.setOperator(0);
        }
        return changed;
    }

    private boolean simplify(Condition condition, Condition parent) {
        if (condition.isAtomic() && parent.nrConditions() == 1) {
            parent.setLeftValuename(condition.getLeftValuename());
            parent.setFunction(condition.getFunction());
            parent.setRightValuename(condition.getRightValuename());
            parent.setRightExact(condition.getRightExact());
            parent.setNegated(condition.isNegated() ^ parent.isNegated());
            parent.list.clear();
            return true;
        }
        return false;
    }

    public int nrConditions() {
        return this.list.size();
    }

    public Condition getCondition(int i) {
        return this.list.get(i);
    }

    public void setCondition(int i, Condition subCondition) {
        this.list.set(i, subCondition);
    }

    public String toString() {
        return this.toString(0, true, true);
    }

    public String toString(int level, boolean show_negate, boolean show_operator) {
        String retval = "";
        if (this.isAtomic()) {
            for (int i = 0; i < level; ++i) {
                retval = retval + "  ";
            }
            retval = show_operator && this.getOperator() != 0 ? retval + this.getOperatorDesc() + " " : retval + "        ";
            retval = this.isNegated() && (show_negate || level > 0) ? retval + "NOT ( " : retval + "      ";
            if (this.function == 14) {
                retval = retval + " TRUE";
            } else {
                retval = retval + this.left_valuename + " " + this.getFunctionDesc();
                if (this.function != 7 && this.function != 8) {
                    retval = this.right_valuename != null ? retval + " " + this.right_valuename : retval + " [" + (this.getRightExactString() == null ? "" : this.getRightExactString()) + "]";
                }
            }
            if (this.isNegated() && (show_negate || level > 0)) {
                retval = retval + " )";
            }
            retval = retval + Const.CR;
        } else {
            int i;
            if (this.isNegated() && (show_negate || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval = retval + "  ";
                }
                retval = retval + "NOT" + Const.CR;
            }
            if (this.getOperator() != 0 && (show_operator || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval = retval + "  ";
                }
                retval = retval + this.getOperatorDesc() + Const.CR;
            }
            for (i = 0; i < level; ++i) {
                retval = retval + "  ";
            }
            retval = retval + "(" + Const.CR;
            for (i = 0; i < this.list.size(); ++i) {
                Condition cb = this.list.get(i);
                retval = retval + cb.toString(level + 1, true, i > 0);
            }
            for (i = 0; i < level; ++i) {
                retval = retval + "  ";
            }
            retval = retval + ")" + Const.CR;
        }
        return retval;
    }

    @Override
    public String getXML() throws KettleValueException {
        return this.getXML(0);
    }

    public String getXML(int level) throws KettleValueException {
        String retval = "";
        String indent1 = Const.rightPad(" ", level);
        String indent2 = Const.rightPad(" ", level + 1);
        String indent3 = Const.rightPad(" ", level + 2);
        retval = retval + indent1 + XMLHandler.openTag(XML_TAG) + Const.CR;
        retval = retval + indent2 + XMLHandler.addTagValue("negated", this.isNegated());
        if (this.getOperator() != 0) {
            retval = retval + indent2 + XMLHandler.addTagValue("operator", Const.rtrim(this.getOperatorDesc()));
        }
        if (this.isAtomic()) {
            retval = retval + indent2 + XMLHandler.addTagValue("leftvalue", this.getLeftValuename());
            retval = retval + indent2 + XMLHandler.addTagValue("function", this.getFunctionDesc());
            retval = retval + indent2 + XMLHandler.addTagValue("rightvalue", this.getRightValuename());
            if (this.getRightExact() != null) {
                retval = retval + indent2 + this.getRightExact().getXML();
            }
        } else {
            retval = retval + indent2 + "<conditions>" + Const.CR;
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition c = this.getCondition(i);
                retval = retval + c.getXML(level + 2);
            }
            retval = retval + indent3 + "</conditions>" + Const.CR;
        }
        retval = retval + indent2 + XMLHandler.closeTag(XML_TAG) + Const.CR;
        return retval;
    }

    public Condition(String xml) throws KettleXMLException {
        this(XMLHandler.loadXMLString(xml, XML_TAG));
    }

    public Condition(Node condnode) throws KettleXMLException {
        this();
        this.list = new ArrayList<Condition>();
        try {
            String str_negated = XMLHandler.getTagValue(condnode, "negated");
            this.setNegated("Y".equalsIgnoreCase(str_negated));
            String str_operator = XMLHandler.getTagValue(condnode, "operator");
            this.setOperator(Condition.getOperator(str_operator));
            Node conditions = XMLHandler.getSubNode(condnode, "conditions");
            int nrconditions = XMLHandler.countNodes(conditions, XML_TAG);
            if (nrconditions == 0) {
                this.setLeftValuename(XMLHandler.getTagValue(condnode, "leftvalue"));
                this.setFunction(Condition.getFunction(XMLHandler.getTagValue(condnode, "function")));
                this.setRightValuename(XMLHandler.getTagValue(condnode, "rightvalue"));
                Node exactnode = XMLHandler.getSubNode(condnode, "value");
                if (exactnode != null) {
                    ValueMetaAndData exact = new ValueMetaAndData(exactnode);
                    this.setRightExact(exact);
                }
            } else {
                for (int i = 0; i < nrconditions; ++i) {
                    Node subcondnode = XMLHandler.getSubNodeByNr(conditions, XML_TAG, i);
                    Condition c = new Condition(subcondnode);
                    this.addCondition(c);
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to create condition using xml: " + Const.CR + condnode, e);
        }
    }

    public String[] getUsedFields() {
        Hashtable<String, String> fields = new Hashtable<String, String>();
        this.getUsedFields(fields);
        String[] retval = new String[fields.size()];
        Enumeration<String> keys = fields.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            retval[i] = keys.nextElement();
            ++i;
        }
        return retval;
    }

    public void getUsedFields(Hashtable<String, String> fields) {
        if (this.isAtomic()) {
            if (this.getLeftValuename() != null) {
                fields.put(this.getLeftValuename(), "-");
            }
            if (this.getRightValuename() != null) {
                fields.put(this.getRightValuename(), "-");
            }
        } else {
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition subc = this.getCondition(i);
                subc.getUsedFields(fields);
            }
        }
    }

    public List<Condition> getChildren() {
        return this.list;
    }
}

