/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.RandomHash;
import com.cloudera.sqoop.util.StoredAsProperty;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.util.CredentialsUtil;
import org.apache.sqoop.util.LoggingUtils;
import org.apache.sqoop.util.password.CredentialProviderHelper;
import org.apache.sqoop.validation.AbortOnFailureHandler;
import org.apache.sqoop.validation.AbsoluteValidationThreshold;
import org.apache.sqoop.validation.RowCountValidator;

public class SqoopOptions
implements Cloneable {
    public static final Log LOG = LogFactory.getLog((String)SqoopOptions.class.getName());
    public static final String METASTORE_PASSWORD_KEY = "sqoop.metastore.client.record.password";
    public static final String DEF_HIVE_HOME = "/usr/lib/hive";
    public static final String DEF_HCAT_HOME = "/usr/lib/hive-hcatalog";
    public static final String DEF_HCAT_HOME_OLD = "/usr/lib/hcatalog";
    public static final boolean METASTORE_PASSWORD_DEFAULT = false;
    @StoredAsProperty(value="hadoop.job.history.user.location")
    private String hadoopJobHistoryUserLocation;
    @StoredAsProperty(value="verbose")
    private boolean verbose;
    @StoredAsProperty(value="mapreduce.job.name")
    private String mapreduceJobName;
    @StoredAsProperty(value="db.connect.string")
    private String connectString;
    @StoredAsProperty(value="db.table")
    private String tableName;
    private String[] columns;
    @StoredAsProperty(value="db.username")
    private String username;
    @StoredAsProperty(value="db.export.staging.table")
    private String stagingTableName;
    @StoredAsProperty(value="db.clear.staging.table")
    private boolean clearStagingTable;
    @StoredAsProperty(value="db.export.call")
    private String call;
    private Properties connectionParams;
    private String password;
    @StoredAsProperty(value="db.password.file")
    private String passwordFilePath;
    @StoredAsProperty(value="db.password.alias")
    private String passwordAlias;
    @StoredAsProperty(value="null.string")
    private String nullStringValue;
    @StoredAsProperty(value="input.null.string")
    private String inNullStringValue;
    @StoredAsProperty(value="null.non-string")
    private String nullNonStringValue;
    @StoredAsProperty(value="input.null.non-string")
    private String inNullNonStringValue;
    @StoredAsProperty(value="codegen.output.dir")
    private String codeOutputDir;
    @StoredAsProperty(value="codegen.compile.dir")
    private String jarOutputDir;
    @StoredAsProperty(value="codegen.auto.compile.dir")
    private boolean jarDirIsAuto;
    private String hadoopMapRedHome;
    @StoredAsProperty(value="db.split.column")
    private String splitByCol;
    @StoredAsProperty(value="db.where.clause")
    private String whereClause;
    @StoredAsProperty(value="db.query")
    private String sqlQuery;
    @StoredAsProperty(value="db.query.boundary")
    private String boundaryQuery;
    @StoredAsProperty(value="jdbc.driver.class")
    private String driverClassName;
    @StoredAsProperty(value="hdfs.warehouse.dir")
    private String warehouseDir;
    @StoredAsProperty(value="hdfs.target.dir")
    private String targetDir;
    @StoredAsProperty(value="hdfs.append.dir")
    private boolean append;
    @StoredAsProperty(value="hdfs.delete-target.dir")
    private boolean delete;
    @StoredAsProperty(value="hdfs.file.format")
    private SqoopOptions.FileLayout layout;
    @StoredAsProperty(value="direct.import")
    private boolean direct;
    @StoredAsProperty(value="db.batch")
    private boolean batchMode;
    private String tmpDir;
    private String hiveHome;
    @StoredAsProperty(value="hive.import")
    private boolean hiveImport;
    @StoredAsProperty(value="hive.overwrite.table")
    private boolean overwriteHiveTable;
    @StoredAsProperty(value="hive.fail.table.exists")
    private boolean failIfHiveTableExists;
    @StoredAsProperty(value="hive.table.name")
    private String hiveTableName;
    @StoredAsProperty(value="hive.database.name")
    private String hiveDatabaseName;
    @StoredAsProperty(value="hive.drop.delims")
    private boolean hiveDropDelims;
    @StoredAsProperty(value="hive.delims.replacement")
    private String hiveDelimsReplacement;
    @StoredAsProperty(value="hive.partition.key")
    private String hivePartitionKey;
    @StoredAsProperty(value="hive.partition.value")
    private String hivePartitionValue;
    @StoredAsProperty(value="hcatalog.table.name")
    private String hCatTableName;
    @StoredAsProperty(value="hcatalog.database.name")
    private String hCatDatabaseName;
    @StoredAsProperty(value="hcatalog.create.table")
    private boolean hCatCreateTable;
    @StoredAsProperty(value="hcatalog.storage.stanza")
    private String hCatStorageStanza;
    private String hCatHome;
    private boolean skipDistCache;
    @StoredAsProperty(value="hcatalog.partition.keys")
    private String hCatalogPartitionKeys;
    @StoredAsProperty(value="hcatalog.partition.values")
    private String hCatalogPartitionValues;
    private Properties mapColumnJava;
    private Properties mapColumnHive;
    private String[] dbOutColumns;
    @StoredAsProperty(value="codegen.java.packagename")
    private String packageName;
    @StoredAsProperty(value="codegen.java.classname")
    private String className;
    @StoredAsProperty(value="codegen.jar.file")
    private String existingJarFile;
    @StoredAsProperty(value="mapreduce.num.mappers")
    private int numMappers;
    @StoredAsProperty(value="enable.compression")
    private boolean useCompression;
    @StoredAsProperty(value="compression.codec")
    private String compressionCodec;
    @StoredAsProperty(value="import.direct.split.size")
    private long directSplitSize;
    @StoredAsProperty(value="import.max.inline.lob.size")
    private long maxInlineLobSize;
    @StoredAsProperty(value="import.fetch.size")
    private Integer fetchSize;
    @StoredAsProperty(value="export.source.dir")
    private String exportDir;
    @StoredAsProperty(value="export.update.col")
    private String updateKeyCol;
    @StoredAsProperty(value="export.new.update")
    private SqoopOptions.UpdateMode updateMode;
    private DelimiterSet inputDelimiters;
    private DelimiterSet outputDelimiters;
    private boolean areOutputDelimsManuallySet;
    private boolean areInputDelimsManuallySet;
    private Configuration conf;
    public static final int DEFAULT_NUM_MAPPERS = 4;
    private String[] extraArgs;
    @StoredAsProperty(value="hbase.table")
    private String hbaseTable;
    @StoredAsProperty(value="hbase.col.family")
    private String hbaseColFamily;
    @StoredAsProperty(value="hbase.row.key.col")
    private String hbaseRowKeyCol;
    @StoredAsProperty(value="hbase.bulk.load.enabled")
    private boolean hbaseBulkLoadEnabled;
    @StoredAsProperty(value="hbase.create.table")
    private boolean hbaseCreateTable;
    @StoredAsProperty(value="incremental.col")
    private String incrementalTestCol;
    @StoredAsProperty(value="incremental.mode")
    private SqoopOptions.IncrementalMode incrementalMode;
    @StoredAsProperty(value="incremental.last.value")
    private String incrementalLastValue;
    @StoredAsProperty(value="import.all_tables.exclude")
    private String allTablesExclude;
    @StoredAsProperty(value="merge.old.path")
    private String mergeOldPath;
    @StoredAsProperty(value="merge.new.path")
    private String mergeNewPath;
    @StoredAsProperty(value="merge.key.col")
    private String mergeKeyCol;
    @StoredAsProperty(value="mainframe.input.dataset.name")
    private String mainframeInputDatasetName;
    private String accumuloHome;
    private String zookeeperHome;
    @StoredAsProperty(value="accumulo.table")
    private String accumuloTable;
    @StoredAsProperty(value="accumulo.col.family")
    private String accumuloColFamily;
    @StoredAsProperty(value="accumulo.row.key.col")
    private String accumuloRowKeyCol;
    @StoredAsProperty(value="accumulo.visibility")
    private String accumuloVisibility;
    @StoredAsProperty(value="accumulo.batch.size")
    private long accumuloBatchSize;
    @StoredAsProperty(value="accumulo.max.latency")
    private long accumuloMaxLatency;
    @StoredAsProperty(value="accumulo.create.table")
    private boolean accumuloCreateTable;
    @StoredAsProperty(value="accumulo.user")
    private String accumuloUser;
    @StoredAsProperty(value="accumulo.password")
    private String accumuloPassword;
    @StoredAsProperty(value="accumulo.instance")
    private String accumuloInstance;
    @StoredAsProperty(value="accumulo.zookeepers")
    private String accumuloZookeepers;
    @StoredAsProperty(value="relaxed.isolation")
    private boolean relaxedIsolation;
    @StoredAsProperty(value="reset.onemapper")
    private boolean autoResetToOneMapper;
    private String jobName;
    private Map<String, String> jobStorageDescriptor;
    private com.cloudera.sqoop.SqoopOptions parent;
    private static String curNonce;
    @StoredAsProperty(value="connection.manager")
    private String connManagerClassName;
    private SqoopTool activeSqoopTool;
    private boolean isValidationEnabled;
    private Class validatorClass;
    private Class validationThresholdClass;
    private Class validationFailureHandlerClass;

    public SqoopOptions() {
        this.initDefaults(null);
    }

    public SqoopOptions(Configuration conf) {
        this.initDefaults(conf);
    }

    public SqoopOptions(String connect, String table) {
        this.initDefaults(null);
        this.connectString = connect;
        this.tableName = table;
    }

    private boolean getBooleanProperty(Properties props, String propName, boolean defaultValue) {
        String str = props.getProperty(propName, Boolean.toString(defaultValue)).toLowerCase();
        return "true".equals(str) || "yes".equals(str) || "1".equals(str);
    }

    private long getLongProperty(Properties props, String propName, long defaultValue) {
        String str = props.getProperty(propName, Long.toString(defaultValue)).toLowerCase();
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            LOG.warn((Object)("Could not parse integer value for config parameter " + propName));
            return defaultValue;
        }
    }

    private int getIntProperty(Properties props, String propName, int defaultVal) {
        long longVal = this.getLongProperty(props, propName, defaultVal);
        return (int)longVal;
    }

    private char getCharProperty(Properties props, String propName, char defaultVal) {
        int intVal = this.getIntProperty(props, propName, defaultVal);
        return (char)intVal;
    }

    private DelimiterSet getDelimiterProperties(Properties props, String prefix, DelimiterSet defaults) {
        if (null == defaults) {
            defaults = new DelimiterSet();
        }
        char field = this.getCharProperty(props, prefix + ".field", defaults.getFieldsTerminatedBy());
        char record = this.getCharProperty(props, prefix + ".record", defaults.getLinesTerminatedBy());
        char enclose = this.getCharProperty(props, prefix + ".enclose", defaults.getEnclosedBy());
        char escape = this.getCharProperty(props, prefix + ".escape", defaults.getEscapedBy());
        boolean required = this.getBooleanProperty(props, prefix + ".enclose.required", defaults.isEncloseRequired());
        return new DelimiterSet(field, record, enclose, escape, required);
    }

    private void setDelimiterProperties(Properties props, String prefix, DelimiterSet values) {
        this.putProperty(props, prefix + ".field", Integer.toString(values.getFieldsTerminatedBy()));
        this.putProperty(props, prefix + ".record", Integer.toString(values.getLinesTerminatedBy()));
        this.putProperty(props, prefix + ".enclose", Integer.toString(values.getEnclosedBy()));
        this.putProperty(props, prefix + ".escape", Integer.toString(values.getEscapedBy()));
        this.putProperty(props, prefix + ".enclose.required", Boolean.toString(values.isEncloseRequired()));
    }

    private String[] listToArray(String strList) {
        return strList.split(",");
    }

    private String arrayToList(String[] array) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String elem : array) {
            if (!first) {
                sb.append(",");
            }
            sb.append(elem);
            first = false;
        }
        return sb.toString();
    }

    private void putProperty(Properties props, String k, String v) {
        if (null == v) {
            props.remove(k);
        } else {
            props.setProperty(k, v);
        }
    }

    private String[] getArgArrayProperty(Properties props, String prefix, String[] defaults) {
        String curProp;
        String curStr;
        int cur = 0;
        ArrayList<String> al = new ArrayList<String>();
        while (null != (curStr = props.getProperty(curProp = prefix + "." + cur, null))) {
            al.add(curStr);
            ++cur;
        }
        if (cur == 0) {
            return defaults;
        }
        return al.toArray(new String[0]);
    }

    private void setArgArrayProperties(Properties props, String prefix, String[] values) {
        if (null == values) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            this.putProperty(props, prefix + "." + i, values[i]);
        }
    }

    private void setPropertiesAsNestedProperties(Properties props, String prefix, Properties values) {
        String nestedPropertyPrefix = prefix + ".";
        if (null == values || values.size() == 0) {
            for (String name : props.stringPropertyNames()) {
                if (!name.startsWith(nestedPropertyPrefix)) continue;
                props.remove(name);
            }
        } else {
            for (String name : values.stringPropertyNames()) {
                this.putProperty(props, nestedPropertyPrefix + name, values.getProperty(name));
            }
        }
    }

    private Properties getPropertiesAsNetstedProperties(Properties props, String prefix) {
        Properties nestedProps = new Properties();
        String nestedPropertyPrefix = prefix + ".";
        int index = nestedPropertyPrefix.length();
        if (props != null && props.size() > 0) {
            for (String name : props.stringPropertyNames()) {
                if (!name.startsWith(nestedPropertyPrefix)) continue;
                String shortName = name.substring(index);
                nestedProps.put(shortName, props.get(name));
            }
        }
        return nestedProps;
    }

    public void loadProperties(Properties props) {
        String colListStr;
        try {
            Field[] fields;
            for (Field f : fields = SqoopOptions.class.getDeclaredFields()) {
                if (!f.isAnnotationPresent(StoredAsProperty.class)) continue;
                Class<?> typ = f.getType();
                StoredAsProperty storedAs = f.getAnnotation(StoredAsProperty.class);
                String propName = storedAs.value();
                if (typ.equals(Integer.TYPE)) {
                    f.setInt(this, this.getIntProperty(props, propName, f.getInt(this)));
                    continue;
                }
                if (typ.equals(Boolean.TYPE)) {
                    f.setBoolean(this, this.getBooleanProperty(props, propName, f.getBoolean(this)));
                    continue;
                }
                if (typ.equals(Long.TYPE)) {
                    f.setLong(this, this.getLongProperty(props, propName, f.getLong(this)));
                    continue;
                }
                if (typ.equals(String.class)) {
                    f.set(this, props.getProperty(propName, (String)f.get(this)));
                    continue;
                }
                if (typ.equals(Integer.class)) {
                    String value = props.getProperty(propName, f.get(this) == null ? "null" : f.get(this).toString());
                    f.set(this, value.equals("null") ? null : new Integer(value));
                    continue;
                }
                if (typ.isEnum()) {
                    f.set(this, Enum.valueOf(typ, props.getProperty(propName, f.get(this).toString())));
                    continue;
                }
                throw new RuntimeException("Could not retrieve property " + propName + " for type: " + typ);
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Illegal access to field in property setter", iae);
        }
        this.loadPasswordProperty(props);
        if (this.jarDirIsAuto) {
            String localUsername = System.getProperty("user.name", "unknown");
            this.jarOutputDir = SqoopOptions.getNonceJarDir(this.tmpDir + "sqoop-" + localUsername + "/compile");
        }
        if (null != (colListStr = props.getProperty("db.column.list", null))) {
            this.columns = this.listToArray(colListStr);
        }
        this.inputDelimiters = this.getDelimiterProperties(props, "codegen.input.delimiters", this.inputDelimiters);
        this.outputDelimiters = this.getDelimiterProperties(props, "codegen.output.delimiters", this.outputDelimiters);
        this.extraArgs = this.getArgArrayProperty(props, "tool.arguments", this.extraArgs);
        this.connectionParams = this.getPropertiesAsNetstedProperties(props, "db.connect.params");
        this.mapColumnHive = this.getPropertiesAsNetstedProperties(props, "map.column.hive");
        this.mapColumnJava = this.getPropertiesAsNetstedProperties(props, "map.column.java");
        this.areOutputDelimsManuallySet = true;
        this.areInputDelimsManuallySet = true;
        if (this.verbose) {
            LoggingUtils.setDebugLevel();
        }
    }

    private void loadPasswordProperty(Properties props) {
        this.passwordFilePath = props.getProperty("db.password.file");
        if (this.passwordFilePath != null) {
            try {
                this.password = CredentialsUtil.fetchPasswordFromLoader(this.passwordFilePath, this.getConf());
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to fetch password from file.", e);
            }
        }
        this.passwordAlias = props.getProperty("db.password.alias");
        if (this.passwordAlias != null) {
            try {
                this.setPassword(CredentialProviderHelper.resolveAlias(this.getConf(), this.passwordAlias));
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to resolve credentials.", e);
            }
        }
        if (this.getBooleanProperty(props, "db.require.password", false)) {
            this.setPasswordFromConsole();
        } else {
            this.password = props.getProperty("db.password", this.password);
        }
    }

    public Properties writeProperties() {
        Properties props = new Properties();
        try {
            Field[] fields;
            for (Field f : fields = SqoopOptions.class.getDeclaredFields()) {
                if (!f.isAnnotationPresent(StoredAsProperty.class)) continue;
                Class<?> typ = f.getType();
                StoredAsProperty storedAs = f.getAnnotation(StoredAsProperty.class);
                String propName = storedAs.value();
                if (typ.equals(Integer.TYPE)) {
                    this.putProperty(props, propName, Integer.toString(f.getInt(this)));
                    continue;
                }
                if (typ.equals(Boolean.TYPE)) {
                    this.putProperty(props, propName, Boolean.toString(f.getBoolean(this)));
                    continue;
                }
                if (typ.equals(Long.TYPE)) {
                    this.putProperty(props, propName, Long.toString(f.getLong(this)));
                    continue;
                }
                if (typ.equals(String.class)) {
                    this.putProperty(props, propName, (String)f.get(this));
                    continue;
                }
                if (typ.equals(Integer.class)) {
                    this.putProperty(props, propName, f.get(this) == null ? "null" : f.get(this).toString());
                    continue;
                }
                if (typ.isEnum()) {
                    this.putProperty(props, propName, f.get(this).toString());
                    continue;
                }
                throw new RuntimeException("Could not set property " + propName + " for type: " + typ);
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Illegal access to field in property setter", iae);
        }
        this.writePasswordProperty(props);
        this.putProperty(props, "db.column.list", this.arrayToList(this.columns));
        this.setDelimiterProperties(props, "codegen.input.delimiters", this.inputDelimiters);
        this.setDelimiterProperties(props, "codegen.output.delimiters", this.outputDelimiters);
        this.setArgArrayProperties(props, "tool.arguments", this.extraArgs);
        this.setPropertiesAsNestedProperties(props, "db.connect.params", this.connectionParams);
        this.setPropertiesAsNestedProperties(props, "map.column.hive", this.mapColumnHive);
        this.setPropertiesAsNestedProperties(props, "map.column.java", this.mapColumnJava);
        return props;
    }

    private void writePasswordProperty(Properties props) {
        if (this.getPasswordFilePath() != null) {
            this.putProperty(props, "db.password.file", this.getPasswordFilePath());
            return;
        }
        if (this.getPasswordAlias() != null) {
            this.putProperty(props, "db.password.alias", this.getPasswordAlias());
            return;
        }
        if (this.getConf().getBoolean(METASTORE_PASSWORD_KEY, false)) {
            this.putProperty(props, "db.password", this.password);
            this.putProperty(props, "db.require.password", "false");
        } else if (this.password != null) {
            this.putProperty(props, "db.require.password", "true");
        } else {
            this.putProperty(props, "db.require.password", "false");
        }
    }

    public Object clone() {
        try {
            SqoopOptions other = (SqoopOptions)super.clone();
            if (null != this.columns) {
                other.columns = Arrays.copyOf(this.columns, this.columns.length);
            }
            if (null != this.dbOutColumns) {
                other.dbOutColumns = Arrays.copyOf(this.dbOutColumns, this.dbOutColumns.length);
            }
            if (null != this.inputDelimiters) {
                other.inputDelimiters = (DelimiterSet)this.inputDelimiters.clone();
            }
            if (null != this.outputDelimiters) {
                other.outputDelimiters = (DelimiterSet)this.outputDelimiters.clone();
            }
            if (null != this.conf) {
                other.conf = new Configuration(this.conf);
            }
            if (null != this.extraArgs) {
                other.extraArgs = Arrays.copyOf(this.extraArgs, this.extraArgs.length);
            }
            if (null != this.connectionParams) {
                other.setConnectionParams(this.connectionParams);
            }
            if (null != this.mapColumnHive) {
                other.mapColumnHive = (Properties)this.mapColumnHive.clone();
            }
            if (null != this.mapColumnJava) {
                other.mapColumnJava = (Properties)this.mapColumnJava.clone();
            }
            return other;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String getTempDir() {
        return this.tmpDir;
    }

    private static String getNonceJarDir(String tmpBase) {
        int MAX_DIR_CREATE_ATTEMPTS = 32;
        if (null != curNonce) {
            return curNonce;
        }
        File baseDir = new File(tmpBase);
        File hashDir = null;
        for (int attempts = 0; attempts < 32; ++attempts) {
            hashDir = new File(baseDir, RandomHash.generateMD5String());
            while (hashDir.exists()) {
                hashDir = new File(baseDir, RandomHash.generateMD5String());
            }
            if (!hashDir.mkdirs()) continue;
            hashDir.deleteOnExit();
            break;
        }
        if (hashDir == null || !hashDir.exists()) {
            throw new RuntimeException("Could not create temporary directory: " + hashDir + "; check for a directory permissions issue on /tmp.");
        }
        LOG.debug((Object)("Generated nonce dir: " + hashDir.toString()));
        curNonce = hashDir.toString();
        return curNonce;
    }

    public static void clearNonceDir() {
        LOG.warn((Object)"Clearing nonce directory");
        curNonce = null;
    }

    public static String getHiveHomeDefault() {
        String hiveHome = System.getenv("HIVE_HOME");
        if ((hiveHome = System.getProperty("hive.home", hiveHome)) == null) {
            hiveHome = DEF_HIVE_HOME;
        }
        return hiveHome;
    }

    public static String getHCatHomeDefault() {
        String hcatHome = System.getenv("HCAT_HOME");
        if ((hcatHome = System.getProperty("hcat.home", hcatHome)) == null) {
            File file = new File(DEF_HCAT_HOME);
            hcatHome = file.exists() ? DEF_HCAT_HOME : DEF_HCAT_HOME_OLD;
        }
        return hcatHome;
    }

    private void initDefaults(Configuration baseConfiguration) {
        this.hadoopJobHistoryUserLocation = "none";
        this.hadoopMapRedHome = System.getenv("HADOOP_MAPRED_HOME");
        this.accumuloHome = SqoopOptions.getAccumuloHomeDefault();
        this.zookeeperHome = SqoopOptions.getZookeeperHomeDefault();
        this.hiveHome = SqoopOptions.getHiveHomeDefault();
        this.hCatHome = SqoopOptions.getHCatHomeDefault();
        this.inputDelimiters = new DelimiterSet('\u0000', '\u0000', '\u0000', '\u0000', false);
        this.outputDelimiters = new DelimiterSet();
        this.codeOutputDir = System.getProperty("sqoop.src.dir", ".");
        String myTmpDir = System.getProperty("test.build.data", "/tmp/");
        if (!myTmpDir.endsWith(File.separator)) {
            myTmpDir = myTmpDir + File.separator;
        }
        this.tmpDir = myTmpDir;
        String localUsername = System.getProperty("user.name", "unknown");
        this.jarOutputDir = SqoopOptions.getNonceJarDir(this.tmpDir + "sqoop-" + localUsername + "/compile");
        this.jarDirIsAuto = true;
        this.layout = SqoopOptions.FileLayout.TextFile;
        this.areOutputDelimsManuallySet = false;
        this.areInputDelimsManuallySet = false;
        this.numMappers = 4;
        this.useCompression = false;
        this.compressionCodec = null;
        this.directSplitSize = 0L;
        this.maxInlineLobSize = 0x1000000L;
        this.fetchSize = null;
        this.conf = null == baseConfiguration ? new Configuration() : baseConfiguration;
        this.extraArgs = null;
        this.dbOutColumns = null;
        this.incrementalMode = SqoopOptions.IncrementalMode.None;
        this.updateMode = SqoopOptions.UpdateMode.UpdateOnly;
        this.mapColumnHive = new Properties();
        this.mapColumnJava = new Properties();
        this.accumuloBatchSize = 10240000L;
        this.accumuloMaxLatency = 5000L;
        this.verbose = false;
        this.isValidationEnabled = false;
        this.validatorClass = RowCountValidator.class;
        this.validationThresholdClass = AbsoluteValidationThreshold.class;
        this.validationFailureHandlerClass = AbortOnFailureHandler.class;
        this.relaxedIsolation = false;
    }

    public static char toChar(String charish) throws InvalidOptionsException {
        if (null == charish || charish.length() == 0) {
            throw new InvalidOptionsException("Character argument expected.\nTry --help for usage instructions.");
        }
        if (charish.startsWith("\\0x") || charish.startsWith("\\0X")) {
            if (charish.length() == 3) {
                throw new InvalidOptionsException("Base-16 value expected for character argument.\nTry --help for usage instructions.");
            }
            String valStr = charish.substring(3);
            int val = Integer.parseInt(valStr, 16);
            return (char)val;
        }
        if (charish.startsWith("\\0")) {
            if (charish.equals("\\0")) {
                return '\u0000';
            }
            String valStr = charish.substring(2);
            int val = Integer.parseInt(valStr, 8);
            return (char)val;
        }
        if (charish.startsWith("\\")) {
            if (charish.length() == 1) {
                return '\\';
            }
            if (charish.length() > 2) {
                throw new InvalidOptionsException("Cannot understand character argument: " + charish + "\nTry --help for usage instructions.");
            }
            char escapeWhat = charish.charAt(1);
            switch (escapeWhat) {
                case 'b': {
                    return '\b';
                }
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 't': {
                    return '\t';
                }
                case '\"': {
                    return '\"';
                }
                case '\'': {
                    return '\'';
                }
                case '\\': {
                    return '\\';
                }
            }
            throw new InvalidOptionsException("Cannot understand character argument: " + charish + "\nTry --help for usage instructions.");
        }
        if (charish.length() > 1) {
            LOG.warn((Object)("Character argument " + charish + " has multiple characters; " + "only the first will be used."));
        }
        return charish.charAt(0);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean beVerbose) {
        this.verbose = beVerbose;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(String tmp) {
        this.tmpDir = tmp;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public void setConnectString(String connectStr) {
        this.connectString = connectStr;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public String getStagingTableName() {
        return this.stagingTableName;
    }

    public void setStagingTableName(String stagingTable) {
        this.stagingTableName = stagingTable;
    }

    public boolean doClearStagingTable() {
        return this.clearStagingTable;
    }

    public void setClearStagingTable(boolean clear) {
        this.clearStagingTable = clear;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String dir) {
        this.exportDir = dir;
    }

    public String getExistingJarName() {
        return this.existingJarFile;
    }

    public void setExistingJarName(String jarFile) {
        this.existingJarFile = jarFile;
    }

    public String[] getColumns() {
        if (null == this.columns) {
            return null;
        }
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public void setColumns(String[] cols) {
        this.columns = null == cols ? null : Arrays.copyOf(cols, cols.length);
    }

    public String getSplitByCol() {
        return this.splitByCol;
    }

    public void setSplitByCol(String splitBy) {
        this.splitByCol = splitBy;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String where) {
        this.whereClause = where;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordFilePath() {
        return this.passwordFilePath;
    }

    public void setPasswordFilePath(String passwdFilePath) {
        this.passwordFilePath = passwdFilePath;
    }

    public String getPasswordAlias() {
        return this.passwordAlias;
    }

    public void setPasswordAlias(String alias) {
        this.passwordAlias = alias;
    }

    protected void parseColumnMapping(String mapping, Properties output) {
        String[] maps;
        output.clear();
        for (String map : maps = mapping.split(",")) {
            String[] details = map.split("=");
            if (details.length != 2) {
                throw new IllegalArgumentException("Malformed mapping.  Column mapping should be the form key=value[,key=value]*");
            }
            output.put(details[0], details[1]);
        }
    }

    public void setMapColumnHive(String mapColumn) {
        this.parseColumnMapping(mapColumn, this.mapColumnHive);
    }

    public void setMapColumnJava(String mapColumn) {
        this.parseColumnMapping(mapColumn, this.mapColumnJava);
    }

    public Properties getMapColumnHive() {
        return this.mapColumnHive;
    }

    public Properties getMapColumnJava() {
        return this.mapColumnJava;
    }

    private String securePasswordEntry() {
        try {
            return new String(System.console().readPassword("Enter password: ", new Object[0]));
        }
        catch (NullPointerException e) {
            LOG.error((Object)"It seems that you have launched a Sqoop metastore job via");
            LOG.error((Object)"Oozie with sqoop.metastore.client.record.password disabled.");
            LOG.error((Object)"But this configuration is not supported because Sqoop can't");
            LOG.error((Object)"prompt the user to enter the password while being executed");
            LOG.error((Object)"as Oozie tasks. Please enable sqoop.metastore.client.record");
            LOG.error((Object)".password in sqoop-site.xml, or provide the password");
            LOG.error((Object)"explicitly using --password in the command tag of the Oozie");
            LOG.error((Object)"workflow file.");
            return null;
        }
    }

    public void setPasswordFromConsole() {
        this.password = this.securePasswordEntry();
    }

    public String getMapreduceJobName() {
        return this.mapreduceJobName;
    }

    public void setMapreduceJobName(String mapredJobName) {
        this.mapreduceJobName = mapredJobName;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDirectMode(boolean isDirect) {
        this.direct = isDirect;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean mode) {
        this.batchMode = mode;
    }

    public int getNumMappers() {
        return this.numMappers;
    }

    public void setNumMappers(int m) {
        this.numMappers = m;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public String getHiveHome() {
        return this.hiveHome;
    }

    public void setHiveHome(String home) {
        this.hiveHome = home;
    }

    public boolean doHiveImport() {
        return this.hiveImport;
    }

    public void setHiveImport(boolean doImport) {
        this.hiveImport = doImport;
    }

    public boolean doOverwriteHiveTable() {
        return this.overwriteHiveTable;
    }

    public void setOverwriteHiveTable(boolean overwrite) {
        this.overwriteHiveTable = overwrite;
    }

    public boolean doHiveDropDelims() {
        return this.hiveDropDelims;
    }

    public void setHiveDropDelims(boolean dropHiveDelims) {
        this.hiveDropDelims = dropHiveDelims;
    }

    public String getHiveDelimsReplacement() {
        return this.hiveDelimsReplacement;
    }

    public void setHiveDelimsReplacement(String replacement) {
        this.hiveDelimsReplacement = replacement;
    }

    public boolean doFailIfHiveTableExists() {
        return this.failIfHiveTableExists;
    }

    public void setFailIfHiveTableExists(boolean fail) {
        this.failIfHiveTableExists = fail;
    }

    public void setHCatTableName(String ht) {
        this.hCatTableName = ht;
    }

    public String getHCatTableName() {
        return this.hCatTableName;
    }

    public void setHCatDatabaseName(String hd) {
        this.hCatDatabaseName = hd;
    }

    public String getHCatDatabaseName() {
        return this.hCatDatabaseName;
    }

    public String getHCatHome() {
        return this.hCatHome;
    }

    public void setHCatHome(String home) {
        this.hCatHome = home;
    }

    public boolean doCreateHCatalogTable() {
        return this.hCatCreateTable;
    }

    public void setCreateHCatalogTable(boolean create) {
        this.hCatCreateTable = create;
    }

    public void setHCatStorageStanza(String stanza) {
        this.hCatStorageStanza = stanza;
    }

    public String getHCatStorageStanza() {
        return this.hCatStorageStanza;
    }

    public String getCodeOutputDir() {
        if (this.codeOutputDir.endsWith(File.separator)) {
            return this.codeOutputDir;
        }
        return this.codeOutputDir + File.separator;
    }

    public void setCodeOutputDir(String outputDir) {
        this.codeOutputDir = outputDir;
    }

    public String getJarOutputDir() {
        if (this.jarOutputDir.endsWith(File.separator)) {
            return this.jarOutputDir;
        }
        return this.jarOutputDir + File.separator;
    }

    public void setJarOutputDir(String outDir) {
        this.jarOutputDir = outDir;
        this.jarDirIsAuto = false;
    }

    public String getHadoopMapRedHome() {
        return this.hadoopMapRedHome;
    }

    public void setHadoopMapRedHome(String home) {
        this.hadoopMapRedHome = home;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public void setSqlQuery(String sqlStatement) {
        this.sqlQuery = sqlStatement;
    }

    public String getBoundaryQuery() {
        return this.boundaryQuery;
    }

    public void setBoundaryQuery(String sqlStatement) {
        this.boundaryQuery = sqlStatement;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClass) {
        this.driverClassName = driverClass;
    }

    public String getWarehouseDir() {
        return this.warehouseDir;
    }

    public void setWarehouseDir(String warehouse) {
        this.warehouseDir = warehouse;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(String dir) {
        this.targetDir = dir;
    }

    public void setAppendMode(boolean doAppend) {
        this.append = doAppend;
    }

    public boolean isAppendMode() {
        return this.append;
    }

    public void setDeleteMode(boolean doDelete) {
        this.delete = doDelete;
    }

    public boolean isDeleteMode() {
        return this.delete;
    }

    public SqoopOptions.FileLayout getFileLayout() {
        return this.layout;
    }

    public void setFileLayout(SqoopOptions.FileLayout fileLayout) {
        this.layout = fileLayout;
    }

    public char getInputFieldDelim() {
        char f = this.inputDelimiters.getFieldsTerminatedBy();
        if (f == '\u0000') {
            return this.outputDelimiters.getFieldsTerminatedBy();
        }
        return f;
    }

    public void setInputFieldsTerminatedBy(char c) {
        this.inputDelimiters.setFieldsTerminatedBy(c);
    }

    public char getInputRecordDelim() {
        char r = this.inputDelimiters.getLinesTerminatedBy();
        if (r == '\u0000') {
            return this.outputDelimiters.getLinesTerminatedBy();
        }
        return r;
    }

    public void setInputLinesTerminatedBy(char c) {
        this.inputDelimiters.setLinesTerminatedBy(c);
    }

    public char getInputEnclosedBy() {
        char c = this.inputDelimiters.getEnclosedBy();
        if (c == '\u0000') {
            return this.outputDelimiters.getEnclosedBy();
        }
        return c;
    }

    public void setInputEnclosedBy(char c) {
        this.inputDelimiters.setEnclosedBy(c);
    }

    public char getInputEscapedBy() {
        char c = this.inputDelimiters.getEscapedBy();
        if (c == '\u0000') {
            return this.outputDelimiters.getEscapedBy();
        }
        return c;
    }

    public void setInputEscapedBy(char c) {
        this.inputDelimiters.setEscapedBy(c);
    }

    public boolean isInputEncloseRequired() {
        char c = this.inputDelimiters.getEnclosedBy();
        if (c == '\u0000') {
            return this.outputDelimiters.isEncloseRequired();
        }
        return this.inputDelimiters.isEncloseRequired();
    }

    public void setInputEncloseRequired(boolean required) {
        this.inputDelimiters.setEncloseRequired(required);
    }

    public char getOutputFieldDelim() {
        return this.outputDelimiters.getFieldsTerminatedBy();
    }

    public void setFieldsTerminatedBy(char c) {
        this.outputDelimiters.setFieldsTerminatedBy(c);
    }

    public char getOutputRecordDelim() {
        return this.outputDelimiters.getLinesTerminatedBy();
    }

    public void setLinesTerminatedBy(char c) {
        this.outputDelimiters.setLinesTerminatedBy(c);
    }

    public char getOutputEnclosedBy() {
        return this.outputDelimiters.getEnclosedBy();
    }

    public void setEnclosedBy(char c) {
        this.outputDelimiters.setEnclosedBy(c);
    }

    public char getOutputEscapedBy() {
        return this.outputDelimiters.getEscapedBy();
    }

    public void setEscapedBy(char c) {
        this.outputDelimiters.setEscapedBy(c);
    }

    public boolean isOutputEncloseRequired() {
        return this.outputDelimiters.isEncloseRequired();
    }

    public void setOutputEncloseRequired(boolean required) {
        this.outputDelimiters.setEncloseRequired(required);
    }

    public DelimiterSet getOutputDelimiters() {
        return this.outputDelimiters.copy();
    }

    public void setOutputDelimiters(DelimiterSet delimiters) {
        this.outputDelimiters = delimiters.copy();
    }

    public DelimiterSet getInputDelimiters() {
        return new DelimiterSet(this.getInputFieldDelim(), this.getInputRecordDelim(), this.getInputEnclosedBy(), this.getInputEscapedBy(), this.isInputEncloseRequired());
    }

    public boolean shouldUseCompression() {
        return this.useCompression || this.compressionCodec != null;
    }

    public void setUseCompression(boolean compress) {
        this.useCompression = compress;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(String codec) {
        this.compressionCodec = codec;
    }

    public String getHiveTableName() {
        if (null != this.hiveTableName) {
            return this.hiveTableName;
        }
        return this.tableName;
    }

    public void setHiveTableName(String name) {
        this.hiveTableName = name;
    }

    public String getHiveDatabaseName() {
        return this.hiveDatabaseName;
    }

    public void setHiveDatabaseName(String name) {
        this.hiveDatabaseName = name;
    }

    public String getHivePartitionKey() {
        return this.hivePartitionKey;
    }

    public void setHivePartitionKey(String hpk) {
        this.hivePartitionKey = hpk;
    }

    public String getHivePartitionValue() {
        return this.hivePartitionValue;
    }

    public void setHivePartitionValue(String hpv) {
        this.hivePartitionValue = hpv;
    }

    public long getDirectSplitSize() {
        return this.directSplitSize;
    }

    public void setDirectSplitSize(long splitSize) {
        this.directSplitSize = splitSize;
    }

    public long getInlineLobLimit() {
        return this.maxInlineLobSize;
    }

    public void setInlineLobLimit(long limit) {
        this.maxInlineLobSize = limit;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer size) {
        this.fetchSize = size;
    }

    public boolean explicitOutputDelims() {
        return this.areOutputDelimsManuallySet;
    }

    public void setExplicitOutputDelims(boolean explicit) {
        this.areOutputDelimsManuallySet = explicit;
    }

    public boolean explicitInputDelims() {
        return this.areInputDelimsManuallySet;
    }

    public void setExplicitInputDelims(boolean explicit) {
        this.areInputDelimsManuallySet = explicit;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration config) {
        this.conf = config;
    }

    public String[] getExtraArgs() {
        if (this.extraArgs == null) {
            return null;
        }
        String[] out = new String[this.extraArgs.length];
        for (int i = 0; i < this.extraArgs.length; ++i) {
            out[i] = this.extraArgs[i];
        }
        return out;
    }

    public void setExtraArgs(String[] args) {
        if (null == args) {
            this.extraArgs = null;
            return;
        }
        this.extraArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.extraArgs[i] = args[i];
        }
    }

    public void setUpdateKeyCol(String colName) {
        this.updateKeyCol = colName;
    }

    public String getUpdateKeyCol() {
        return this.updateKeyCol;
    }

    public void setUpdateMode(SqoopOptions.UpdateMode mode) {
        this.updateMode = mode;
    }

    public SqoopOptions.UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public String[] getDbOutputColumns() {
        if (null != this.dbOutColumns) {
            return Arrays.copyOf(this.dbOutColumns, this.dbOutColumns.length);
        }
        return null;
    }

    public void setDbOutputColumns(String[] outCols) {
        this.dbOutColumns = null == outCols ? null : Arrays.copyOf(outCols, outCols.length);
    }

    public void setCreateHBaseTable(boolean create) {
        this.hbaseCreateTable = create;
    }

    public boolean getCreateHBaseTable() {
        return this.hbaseCreateTable;
    }

    public void setHBaseColFamily(String colFamily) {
        this.hbaseColFamily = colFamily;
    }

    public String getHBaseColFamily() {
        return this.hbaseColFamily;
    }

    public String getHBaseRowKeyColumn() {
        return this.hbaseRowKeyCol;
    }

    public void setHBaseRowKeyColumn(String col) {
        this.hbaseRowKeyCol = col;
    }

    public boolean isBulkLoadEnabled() {
        return this.hbaseBulkLoadEnabled;
    }

    public void setHBaseBulkLoadEnabled(boolean hbaseBulkLoadEnabled) {
        this.hbaseBulkLoadEnabled = hbaseBulkLoadEnabled;
    }

    public String getHBaseTable() {
        return this.hbaseTable;
    }

    public void setHBaseTable(String table) {
        this.hbaseTable = table;
    }

    public void setIncrementalTestColumn(String colName) {
        this.incrementalTestCol = colName;
    }

    public String getIncrementalTestColumn() {
        return this.incrementalTestCol;
    }

    public void setIncrementalMode(SqoopOptions.IncrementalMode mode) {
        this.incrementalMode = mode;
    }

    public SqoopOptions.IncrementalMode getIncrementalMode() {
        return this.incrementalMode;
    }

    public void setIncrementalLastValue(String lastVal) {
        this.incrementalLastValue = lastVal;
    }

    public String getIncrementalLastValue() {
        return this.incrementalLastValue;
    }

    public void setAllTablesExclude(String exclude) {
        this.allTablesExclude = exclude;
    }

    public String getAllTablesExclude() {
        return this.allTablesExclude;
    }

    public void setJobName(String job) {
        this.jobName = job;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setStorageDescriptor(Map<String, String> descriptor) {
        this.jobStorageDescriptor = descriptor;
    }

    public Map<String, String> getStorageDescriptor() {
        return this.jobStorageDescriptor;
    }

    public com.cloudera.sqoop.SqoopOptions getParent() {
        return this.parent;
    }

    public void setParent(com.cloudera.sqoop.SqoopOptions options) {
        this.parent = options;
    }

    public void setMergeOldPath(String path) {
        this.mergeOldPath = path;
    }

    public String getMergeOldPath() {
        return this.mergeOldPath;
    }

    public void setMergeNewPath(String path) {
        this.mergeNewPath = path;
    }

    public String getMergeNewPath() {
        return this.mergeNewPath;
    }

    public void setMergeKeyCol(String col) {
        this.mergeKeyCol = col;
    }

    public String getMergeKeyCol() {
        return this.mergeKeyCol;
    }

    public void setMainframeInputDatasetName(String name) {
        this.mainframeInputDatasetName = name;
        this.tableName = name;
    }

    public String getMainframeInputDatasetName() {
        return this.mainframeInputDatasetName;
    }

    public static String getAccumuloHomeDefault() {
        String accumuloHome = System.getenv("ACCUMULO_HOME");
        accumuloHome = System.getProperty("accumulo.home", accumuloHome);
        return accumuloHome;
    }

    public static String getZookeeperHomeDefault() {
        String zookeeperHome = System.getenv("ZOOKEEPER_HOME");
        zookeeperHome = System.getProperty("zookeeper.home", zookeeperHome);
        return zookeeperHome;
    }

    public String getAccumuloHome() {
        return this.accumuloHome;
    }

    public void setAccumuloHome(String home) {
        this.accumuloHome = home;
    }

    public String getZookeeperHome() {
        return this.zookeeperHome;
    }

    public void setZookeeperHome(String home) {
        this.zookeeperHome = home;
    }

    public void setCreateAccumuloTable(boolean create) {
        this.accumuloCreateTable = create;
    }

    public boolean getCreateAccumuloTable() {
        return this.accumuloCreateTable;
    }

    public void setAccumuloBatchSize(long batchSize) {
        this.accumuloBatchSize = batchSize;
    }

    public long getAccumuloBatchSize() {
        return this.accumuloBatchSize;
    }

    public void setAccumuloColFamily(String colFamily) {
        this.accumuloColFamily = colFamily;
    }

    public String getAccumuloColFamily() {
        return this.accumuloColFamily;
    }

    public void setAccumuloMaxLatency(long maxLatency) {
        this.accumuloMaxLatency = maxLatency;
    }

    public long getAccumuloMaxLatency() {
        return this.accumuloMaxLatency;
    }

    public String getAccumuloRowKeyColumn() {
        return this.accumuloRowKeyCol;
    }

    public void setAccumuloRowKeyColumn(String col) {
        this.accumuloRowKeyCol = col;
    }

    public String getAccumuloVisibility() {
        return this.accumuloVisibility;
    }

    public void setAccumuloVisibility(String vis) {
        this.accumuloVisibility = vis;
    }

    public String getAccumuloTable() {
        return this.accumuloTable;
    }

    public void setAccumuloTable(String table) {
        this.accumuloTable = table;
    }

    public String getAccumuloUser() {
        return this.accumuloUser;
    }

    public void setAccumuloUser(String user) {
        this.accumuloUser = user;
    }

    public String getAccumuloPassword() {
        return this.accumuloPassword;
    }

    public void setAccumuloPassword(String passwd) {
        this.accumuloPassword = passwd;
    }

    public String getAccumuloInstance() {
        return this.accumuloInstance;
    }

    public void setAccumuloInstance(String instance) {
        this.accumuloInstance = instance;
    }

    public String getAccumuloZookeepers() {
        return this.accumuloZookeepers;
    }

    public void setAccumuloZookeepers(String zookeepers) {
        this.accumuloZookeepers = zookeepers;
    }

    public void setConnManagerClassName(String connManagerClass) {
        this.connManagerClassName = connManagerClass;
    }

    public String getConnManagerClassName() {
        return this.connManagerClassName;
    }

    public SqoopTool getActiveSqoopTool() {
        return this.activeSqoopTool;
    }

    public void setActiveSqoopTool(SqoopTool tool) {
        this.activeSqoopTool = tool;
    }

    public void setNullStringValue(String nullString) {
        this.nullStringValue = nullString;
    }

    public String getNullStringValue() {
        return this.nullStringValue;
    }

    public void setInNullStringValue(String inNullString) {
        this.inNullStringValue = inNullString;
    }

    public String getInNullStringValue() {
        return this.inNullStringValue;
    }

    public void setNullNonStringValue(String nullNonString) {
        this.nullNonStringValue = nullNonString;
    }

    public String getNullNonStringValue() {
        return this.nullNonStringValue;
    }

    public void setInNullNonStringValue(String inNullNonString) {
        this.inNullNonStringValue = inNullNonString;
    }

    public String getInNullNonStringValue() {
        return this.inNullNonStringValue;
    }

    public void setConnectionParams(Properties params) {
        this.connectionParams = new Properties();
        this.connectionParams.putAll((Map<?, ?>)params);
    }

    public Properties getConnectionParams() {
        return this.connectionParams;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.isValidationEnabled = validationEnabled;
    }

    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    public Class getValidatorClass() {
        return this.validatorClass;
    }

    public void setValidatorClass(Class validatorClazz) {
        this.validatorClass = validatorClazz;
    }

    public Class getValidationThresholdClass() {
        return this.validationThresholdClass;
    }

    public void setValidationThresholdClass(Class validationThresholdClazz) {
        this.validationThresholdClass = validationThresholdClazz;
    }

    public Class getValidationFailureHandlerClass() {
        return this.validationFailureHandlerClass;
    }

    public void setValidationFailureHandlerClass(Class validationFailureHandlerClazz) {
        this.validationFailureHandlerClass = validationFailureHandlerClazz;
    }

    public String getCall() {
        return this.call;
    }

    public void setCall(String theCall) {
        this.call = theCall;
    }

    public String getHadoopJobHistoryUserLocation() {
        return this.hadoopJobHistoryUserLocation;
    }

    public void setHadoopJobHistoryUserLocation(String hadoopJobHistoryUserLocation) {
        this.hadoopJobHistoryUserLocation = hadoopJobHistoryUserLocation;
    }

    public void setSkipDistCache(boolean skip) {
        this.skipDistCache = skip;
    }

    public boolean isSkipDistCache() {
        return this.skipDistCache;
    }

    public void setRelaxedIsolation(boolean b) {
        this.relaxedIsolation = true;
    }

    public boolean getRelaxedIsolation() {
        return this.relaxedIsolation;
    }

    public void setAutoResetToOneMapper(boolean b) {
        this.autoResetToOneMapper = b;
    }

    public boolean getAutoResetToOneMapper() {
        return this.autoResetToOneMapper;
    }

    public String getHCatalogPartitionKeys() {
        return this.hCatalogPartitionKeys;
    }

    public void setHCatalogPartitionKeys(String hpks) {
        this.hCatalogPartitionKeys = hpks;
    }

    public String getHCatalogPartitionValues() {
        return this.hCatalogPartitionValues;
    }

    public void setHCatalogPartitionValues(String hpvs) {
        this.hCatalogPartitionValues = hpvs;
    }

    public static class InvalidOptionsException
    extends Exception {
        private String message;

        public InvalidOptionsException(String msg) {
            this.message = msg;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }
}

