/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.rest.JsonSLAEvent;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
@Entity
@NamedQueries(value={@NamedQuery(name="GET_SLA_EVENT_NEWER_SEQ_LIMITED", query="select OBJECT(w) from SLAEventBean w where w.event_id > :id order by w.event_id"), @NamedQuery(name="GET_SLA_EVENTS", query="select OBJECT(w) from SLAEventBean w")})
public class SLAEventBean
extends JsonSLAEvent
implements Writable,
PersistenceCapable {
    @Basic
    @Column(name="job_status")
    private String jobStatusStr = null;
    @Basic
    @Column(name="app_type")
    private String appTypeStr = null;
    @Basic
    @Column(name="expected_start")
    private Timestamp expectedStartTS = null;
    @Basic
    @Column(name="expected_end")
    private Timestamp expectedEndTS = null;
    @Basic
    @Column(name="status_timestamp")
    private Timestamp statusTimestampTS = null;
    @Basic
    @Column(name="event_type")
    private String eventType = null;
    private static int pcInheritedFieldCount = JsonSLAEvent.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonSLAEvent;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$SLAEventBean;

    public String getJobStatusStr() {
        return SLAEventBean.pcGetjobStatusStr(this);
    }

    public void setJobStatusStr(String jobStatusStr) {
        SLAEventBean.pcSetjobStatusStr(this, jobStatusStr);
    }

    @Override
    public SLAEvent.Status getJobStatus() {
        return SLAEvent.Status.valueOf((String)SLAEventBean.pcGetjobStatusStr(this));
    }

    @Override
    public void setJobStatus(SLAEvent.Status jobStatus) {
        super.setJobStatus(jobStatus);
        SLAEventBean.pcSetjobStatusStr(this, jobStatus.toString());
    }

    public String getAppTypeStr() {
        return SLAEventBean.pcGetappTypeStr(this);
    }

    public void setAppTypeStr(String appTypeStr) {
        SLAEventBean.pcSetappTypeStr(this, appTypeStr);
    }

    @Override
    public SLAEvent.SlaAppType getAppType() {
        return SLAEvent.SlaAppType.valueOf((String)SLAEventBean.pcGetappTypeStr(this));
    }

    @Override
    public void setAppType(SLAEvent.SlaAppType appType) {
        super.setAppType(appType);
        SLAEventBean.pcSetappTypeStr(this, appType.toString());
    }

    public Timestamp getExpectedStartTS() {
        return SLAEventBean.pcGetexpectedStartTS(this);
    }

    @Override
    public Date getExpectedStart() {
        return DateUtils.toDate(SLAEventBean.pcGetexpectedStartTS(this));
    }

    @Override
    public void setExpectedStart(Date expectedStart) {
        super.setExpectedStart(expectedStart);
        SLAEventBean.pcSetexpectedStartTS(this, DateUtils.convertDateToTimestamp(expectedStart));
    }

    public Timestamp getExpectedEndTS() {
        return SLAEventBean.pcGetexpectedEndTS(this);
    }

    @Override
    public Date getExpectedEnd() {
        return DateUtils.toDate(SLAEventBean.pcGetexpectedEndTS(this));
    }

    @Override
    public void setExpectedEnd(Date expectedEnd) {
        super.setExpectedEnd(expectedEnd);
        SLAEventBean.pcSetexpectedEndTS(this, DateUtils.convertDateToTimestamp(expectedEnd));
    }

    public Timestamp getStatusTimestampTS() {
        return SLAEventBean.pcGetstatusTimestampTS(this);
    }

    @Override
    public Date getStatusTimestamp() {
        return DateUtils.toDate(SLAEventBean.pcGetstatusTimestampTS(this));
    }

    @Override
    public void setStatusTimestamp(Date statusTimestamp) {
        super.setStatusTimestamp(statusTimestamp);
        SLAEventBean.pcSetstatusTimestampTS(this, DateUtils.convertDateToTimestamp(statusTimestamp));
    }

    public String getEventType() {
        return SLAEventBean.pcGeteventType(this);
    }

    public void setEventType(String eventType) {
        SLAEventBean.pcSeteventType(this, eventType);
    }

    public void readFields(DataInput arg0) throws IOException {
    }

    public void write(DataOutput arg0) throws IOException {
    }

    public String toString() {
        return MessageFormat.format("Event id[{0}] status[{1}]", this.getEvent_id(), this.getJobStatus());
    }

    public Element toXml() {
        Element retElem = null;
        retElem = this.getJobStatus() == SLAEvent.Status.CREATED ? this.getRegistrationEvent("event") : this.getStatusEvent("event");
        return retElem;
    }

    private Element getRegistrationEvent(String tag) {
        Element eReg = new Element(tag);
        eReg.addContent((Content)this.createATagElement("sequence-id", String.valueOf(this.getEvent_id())));
        Element e = new Element("registration");
        e.addContent((Content)this.createATagElement("sla-id", this.getSlaId()));
        e.addContent((Content)this.createATagElement("app-type", this.getAppType().toString()));
        e.addContent((Content)this.createATagElement("app-name", this.getAppName()));
        e.addContent((Content)this.createATagElement("user", this.getUser()));
        e.addContent((Content)this.createATagElement("group", this.getGroupName()));
        e.addContent((Content)this.createATagElement("parent-sla-id", String.valueOf(this.getParentSlaId())));
        e.addContent((Content)this.createATagElement("expected-start", this.getDateString(this.getExpectedStart())));
        e.addContent((Content)this.createATagElement("expected-end", this.getDateString(this.getExpectedEnd())));
        e.addContent((Content)this.createATagElement("status-timestamp", this.getDateString(this.getStatusTimestamp())));
        e.addContent((Content)this.createATagElement("notification-msg", this.getNotificationMsg()));
        e.addContent((Content)this.createATagElement("alert-contact", this.getAlertContact()));
        e.addContent((Content)this.createATagElement("dev-contact", this.getDevContact()));
        e.addContent((Content)this.createATagElement("qa-contact", this.getQaContact()));
        e.addContent((Content)this.createATagElement("se-contact", this.getSeContact()));
        e.addContent((Content)this.createATagElement("alert-percentage", this.getAlertPercentage()));
        e.addContent((Content)this.createATagElement("alert-frequency", this.getAlertFrequency()));
        e.addContent((Content)this.createATagElement("upstream-apps", this.getUpstreamApps()));
        e.addContent((Content)this.createATagElement("job-status", this.getJobStatus().toString()));
        e.addContent((Content)this.createATagElement("job-data", this.getJobData()));
        eReg.addContent((Content)e);
        return eReg;
    }

    private Element getStatusEvent(String tag) {
        Element eStat = new Element(tag);
        eStat.addContent((Content)this.createATagElement("sequence-id", String.valueOf(this.getEvent_id())));
        Element e = new Element("status");
        e.addContent((Content)this.createATagElement("sla-id", this.getSlaId()));
        e.addContent((Content)this.createATagElement("status-timestamp", this.getDateString(this.getStatusTimestamp())));
        e.addContent((Content)this.createATagElement("job-status", this.getJobStatus().toString()));
        e.addContent((Content)this.createATagElement("job-data", this.getJobData()));
        e.addContent((Content)this.createATagElement("user", this.getUser()));
        e.addContent((Content)this.createATagElement("group", this.getGroupName()));
        e.addContent((Content)this.createATagElement("app-name", this.getAppName()));
        eStat.addContent((Content)e);
        return eStat;
    }

    private Element createATagElement(String tag, String content) {
        if (content == null) {
            content = "";
        }
        Element e = new Element(tag);
        e.addContent(content);
        return e;
    }

    private String getDateString(Date d) {
        try {
            return DateUtils.formatDateOozieTZ(d);
        }
        catch (Exception e) {
            e.printStackTrace();
            XLog.getLog(this.getClass()).error((Object)("Date formatting error " + d), e);
            throw new RuntimeException("Date formatting error " + d + e);
        }
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonSLAEvent != null ? class$Lorg$apache$oozie$client$rest$JsonSLAEvent : (class$Lorg$apache$oozie$client$rest$JsonSLAEvent = SLAEventBean.class$("org.apache.oozie.client.rest.JsonSLAEvent"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"appTypeStr", "eventType", "expectedEndTS", "expectedStartTS", "jobStatusStr", "statusTimestampTS"};
        Class[] classArray = new Class[6];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLAEventBean.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLAEventBean.class$("java.lang.String"));
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLAEventBean.class$("java.sql.Timestamp"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLAEventBean.class$("java.sql.Timestamp"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SLAEventBean.class$("java.lang.String"));
        classArray[5] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = SLAEventBean.class$("java.sql.Timestamp"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$SLAEventBean != null ? class$Lorg$apache$oozie$SLAEventBean : (class$Lorg$apache$oozie$SLAEventBean = SLAEventBean.class$("org.apache.oozie.SLAEventBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"SLAEventBean", (PersistenceCapable)new SLAEventBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.appTypeStr = null;
        this.eventType = null;
        this.expectedEndTS = null;
        this.expectedStartTS = null;
        this.jobStatusStr = null;
        this.statusTimestampTS = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        SLAEventBean sLAEventBean = new SLAEventBean();
        if (bl) {
            sLAEventBean.pcClearFields();
        }
        sLAEventBean.pcStateManager = stateManager;
        sLAEventBean.pcCopyKeyFieldsFromObjectId(object);
        return sLAEventBean;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        SLAEventBean sLAEventBean = new SLAEventBean();
        if (bl) {
            sLAEventBean.pcClearFields();
        }
        sLAEventBean.pcStateManager = stateManager;
        return sLAEventBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 6 + JsonSLAEvent.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.appTypeStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.eventType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.expectedEndTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.expectedStartTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.jobStatusStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.statusTimestampTS = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appTypeStr);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.eventType);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.expectedEndTS);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.expectedStartTS);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jobStatusStr);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.statusTimestampTS);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(SLAEventBean sLAEventBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(sLAEventBean, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.appTypeStr = sLAEventBean.appTypeStr;
                return;
            }
            case 1: {
                this.eventType = sLAEventBean.eventType;
                return;
            }
            case 2: {
                this.expectedEndTS = sLAEventBean.expectedEndTS;
                return;
            }
            case 3: {
                this.expectedStartTS = sLAEventBean.expectedStartTS;
                return;
            }
            case 4: {
                this.jobStatusStr = sLAEventBean.jobStatusStr;
                return;
            }
            case 5: {
                this.statusTimestampTS = sLAEventBean.statusTimestampTS;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        SLAEventBean sLAEventBean = (SLAEventBean)object;
        if (sLAEventBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(sLAEventBean, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetappTypeStr(SLAEventBean sLAEventBean) {
        if (sLAEventBean.pcStateManager == null) {
            return sLAEventBean.appTypeStr;
        }
        int n = pcInheritedFieldCount + 0;
        sLAEventBean.pcStateManager.accessingField(n);
        return sLAEventBean.appTypeStr;
    }

    private static final void pcSetappTypeStr(SLAEventBean sLAEventBean, String string) {
        if (sLAEventBean.pcStateManager == null) {
            sLAEventBean.appTypeStr = string;
            return;
        }
        sLAEventBean.pcStateManager.settingStringField((PersistenceCapable)sLAEventBean, pcInheritedFieldCount + 0, sLAEventBean.appTypeStr, string, 0);
    }

    private static final String pcGeteventType(SLAEventBean sLAEventBean) {
        if (sLAEventBean.pcStateManager == null) {
            return sLAEventBean.eventType;
        }
        int n = pcInheritedFieldCount + 1;
        sLAEventBean.pcStateManager.accessingField(n);
        return sLAEventBean.eventType;
    }

    private static final void pcSeteventType(SLAEventBean sLAEventBean, String string) {
        if (sLAEventBean.pcStateManager == null) {
            sLAEventBean.eventType = string;
            return;
        }
        sLAEventBean.pcStateManager.settingStringField((PersistenceCapable)sLAEventBean, pcInheritedFieldCount + 1, sLAEventBean.eventType, string, 0);
    }

    private static final Timestamp pcGetexpectedEndTS(SLAEventBean sLAEventBean) {
        if (sLAEventBean.pcStateManager == null) {
            return sLAEventBean.expectedEndTS;
        }
        int n = pcInheritedFieldCount + 2;
        sLAEventBean.pcStateManager.accessingField(n);
        return sLAEventBean.expectedEndTS;
    }

    private static final void pcSetexpectedEndTS(SLAEventBean sLAEventBean, Timestamp timestamp) {
        if (sLAEventBean.pcStateManager == null) {
            sLAEventBean.expectedEndTS = timestamp;
            return;
        }
        sLAEventBean.pcStateManager.settingObjectField((PersistenceCapable)sLAEventBean, pcInheritedFieldCount + 2, (Object)sLAEventBean.expectedEndTS, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetexpectedStartTS(SLAEventBean sLAEventBean) {
        if (sLAEventBean.pcStateManager == null) {
            return sLAEventBean.expectedStartTS;
        }
        int n = pcInheritedFieldCount + 3;
        sLAEventBean.pcStateManager.accessingField(n);
        return sLAEventBean.expectedStartTS;
    }

    private static final void pcSetexpectedStartTS(SLAEventBean sLAEventBean, Timestamp timestamp) {
        if (sLAEventBean.pcStateManager == null) {
            sLAEventBean.expectedStartTS = timestamp;
            return;
        }
        sLAEventBean.pcStateManager.settingObjectField((PersistenceCapable)sLAEventBean, pcInheritedFieldCount + 3, (Object)sLAEventBean.expectedStartTS, (Object)timestamp, 0);
    }

    private static final String pcGetjobStatusStr(SLAEventBean sLAEventBean) {
        if (sLAEventBean.pcStateManager == null) {
            return sLAEventBean.jobStatusStr;
        }
        int n = pcInheritedFieldCount + 4;
        sLAEventBean.pcStateManager.accessingField(n);
        return sLAEventBean.jobStatusStr;
    }

    private static final void pcSetjobStatusStr(SLAEventBean sLAEventBean, String string) {
        if (sLAEventBean.pcStateManager == null) {
            sLAEventBean.jobStatusStr = string;
            return;
        }
        sLAEventBean.pcStateManager.settingStringField((PersistenceCapable)sLAEventBean, pcInheritedFieldCount + 4, sLAEventBean.jobStatusStr, string, 0);
    }

    private static final Timestamp pcGetstatusTimestampTS(SLAEventBean sLAEventBean) {
        if (sLAEventBean.pcStateManager == null) {
            return sLAEventBean.statusTimestampTS;
        }
        int n = pcInheritedFieldCount + 5;
        sLAEventBean.pcStateManager.accessingField(n);
        return sLAEventBean.statusTimestampTS;
    }

    private static final void pcSetstatusTimestampTS(SLAEventBean sLAEventBean, Timestamp timestamp) {
        if (sLAEventBean.pcStateManager == null) {
            sLAEventBean.statusTimestampTS = timestamp;
            return;
        }
        sLAEventBean.pcStateManager.settingObjectField((PersistenceCapable)sLAEventBean, pcInheritedFieldCount + 5, (Object)sLAEventBean.statusTimestampTS, (Object)timestamp, 0);
    }
}

