/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportParameterValidationException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.ExternalElementType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ProcessingDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.function.sys.AttributeExpressionsEvaluator;
import org.pentaho.reporting.engine.classic.core.function.sys.CellFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.sys.MetaDataStyleEvaluator;
import org.pentaho.reporting.engine.classic.core.function.sys.SheetNameFunction;
import org.pentaho.reporting.engine.classic.core.function.sys.StyleExpressionsEvaluator;
import org.pentaho.reporting.engine.classic.core.function.sys.StyleResolvingEvaluator;
import org.pentaho.reporting.engine.classic.core.function.sys.WizardItemHideFunction;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;
import org.pentaho.reporting.engine.classic.core.sorting.SortingDataFactory;
import org.pentaho.reporting.engine.classic.core.states.DataFactoryManager;
import org.pentaho.reporting.engine.classic.core.states.DefaultGroupSizeRecorder;
import org.pentaho.reporting.engine.classic.core.states.DefaultGroupingState;
import org.pentaho.reporting.engine.classic.core.states.DesignTimeDataFactory;
import org.pentaho.reporting.engine.classic.core.states.EmptyDataFactory;
import org.pentaho.reporting.engine.classic.core.states.EmptyGroupSizeRecorder;
import org.pentaho.reporting.engine.classic.core.states.FunctionStorage;
import org.pentaho.reporting.engine.classic.core.states.FunctionStorageKey;
import org.pentaho.reporting.engine.classic.core.states.GroupSizeRecorder;
import org.pentaho.reporting.engine.classic.core.states.GroupStartRecord;
import org.pentaho.reporting.engine.classic.core.states.GroupingState;
import org.pentaho.reporting.engine.classic.core.states.IgnoreEverythingReportErrorHandler;
import org.pentaho.reporting.engine.classic.core.states.InitialLayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.engine.classic.core.states.ProcessStateHandle;
import org.pentaho.reporting.engine.classic.core.states.ReportDefinitionImpl;
import org.pentaho.reporting.engine.classic.core.states.ReportProcessingErrorHandler;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.StateUtilities;
import org.pentaho.reporting.engine.classic.core.states.StructureFunctionComparator;
import org.pentaho.reporting.engine.classic.core.states.SubLayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.SubReportStorage;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabProcessorFunction;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.datarow.InlineDataRowRuntime;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginReportHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndSubReportHandler;
import org.pentaho.reporting.engine.classic.core.states.process.MasterReportProcessPreprocessor;
import org.pentaho.reporting.engine.classic.core.states.process.ReportProcessStore;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessPreprocessor;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.LongSequence;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.wizard.ProxyDataSchemaDefinition;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;

public class ProcessState
implements ReportState {
    public static final int ARTIFICIAL_EVENT_CODE = Integer.MIN_VALUE;
    private static final Log logger = LogFactory.getLog(ProcessState.class);
    private int currentGroupIndex;
    private int currentPresentationGroupIndex;
    private ReportDefinitionImpl report;
    private int currentSubReport;
    private InlineSubreportMarker[] subReports;
    private ProcessState suspendedState;
    private ProcessState parentSubReportState;
    private FunctionStorage functionStorage;
    private FunctionStorage structureFunctionStorage;
    private DataFactoryManager dataFactoryManager;
    private InternalProcessHandle processHandle;
    private DefaultFlowController flowController;
    private LayoutProcess layoutProcess;
    private ReportStateKey processKey;
    private AdvanceHandler advanceHandler;
    private ReportProcessingErrorHandler errorHandler;
    private int sequenceCounter;
    private boolean inItemGroup;
    private InlineSubreportMarker currentSubReportMarker;
    private boolean inlineProcess;
    private FastStack<GroupStartRecord> groupStarts;
    private boolean structuralPreprocessingNeeded;
    private HashSet<Integer> processLevels;
    private SubReportStorage subReportStorage;
    private String query;
    private Integer queryLimit;
    private Integer queryTimeout;
    private GroupSizeRecorder recorder;
    private boolean reportInstancesShareConnection;
    private AdvanceHandler postSummaryRowAdvanceHandler;
    private int replayStoredCrosstabGroup;
    private LongSequence groupSequenceCounter;
    private LongSequence crosstabColumnSequenceCounter;
    private boolean designtime;
    private PerformanceMonitorContext performanceMonitorContext;
    private ReportProcessStore processStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initializeForMasterReport(MasterReport report, ProcessingContext processingContext, OutputFunction outputFunction) throws ReportProcessingException {
        ReportParameterValues parameterValues;
        ArgumentNullException.validate((String)"report", (Object)report);
        ArgumentNullException.validate((String)"processingContext", (Object)processingContext);
        ArgumentNullException.validate((String)"outputFunction", (Object)outputFunction);
        ReportParameterDefinition parameters = report.getParameterDefinition();
        DefaultParameterContext parameterContext = new DefaultParameterContext(report);
        this.initializeProcessingContext(processingContext, report);
        this.designtime = processingContext.getOutputProcessorMetaData().isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
        if (!this.designtime) {
            try {
                ReportParameterValidator reportParameterValidator = parameters.getValidator();
                ValidationResult validationResult = reportParameterValidator.validate(new ValidationResult(), parameters, parameterContext);
                if (!validationResult.isEmpty()) {
                    throw new ReportParameterValidationException("The parameters provided for this report are not valid.", validationResult);
                }
                parameterValues = validationResult.getParameterValues();
            }
            finally {
                parameterContext.close();
            }
        } else {
            parameterValues = new ReportParameterValues();
        }
        PerformanceMonitorContext rawPerformanceMonitorContext = (PerformanceMonitorContext)ClassicEngineBoot.getInstance().getObjectFactory().get(PerformanceMonitorContext.class);
        this.performanceMonitorContext = new InternalPerformanceMonitorContext(rawPerformanceMonitorContext);
        InitialLayoutProcess layoutProcess = new InitialLayoutProcess(outputFunction, this.performanceMonitorContext);
        this.reportInstancesShareConnection = "true".equals(processingContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ReportInstancesShareConnections"));
        this.processLevels = new HashSet();
        this.groupStarts = new FastStack();
        this.errorHandler = IgnoreEverythingReportErrorHandler.INSTANCE;
        this.advanceHandler = BeginReportHandler.HANDLER;
        this.currentSubReport = -1;
        this.currentGroupIndex = -1;
        this.currentPresentationGroupIndex = -1;
        this.processStore = new ReportProcessStore();
        this.functionStorage = new FunctionStorage();
        this.structureFunctionStorage = new FunctionStorage();
        this.sequenceCounter = 0;
        this.processKey = new ReportStateKey(null, -1, 0, -1, -1, this.sequenceCounter, false, false);
        this.dataFactoryManager = new DataFactoryManager();
        this.subReportStorage = new SubReportStorage();
        this.processHandle = new InternalProcessHandle(this.dataFactoryManager, this.performanceMonitorContext);
        this.crosstabColumnSequenceCounter = new LongSequence(10, -1L);
        this.groupSequenceCounter = new LongSequence(10, -1L);
        this.groupSequenceCounter.set(0, -1L);
        DefaultFlowController startFlowController = new DefaultFlowController(processingContext, report.getDataSchemaDefinition(), StateUtilities.computeParameterValueSet(report, parameterValues), this.performanceMonitorContext);
        MasterReportProcessPreprocessor processPreprocessor = new MasterReportProcessPreprocessor(startFlowController);
        MasterReport processedReport = processPreprocessor.invokePreDataProcessing(report);
        DefaultFlowController flowController = processPreprocessor.getFlowController();
        Object dataCacheEnabledRaw = processedReport.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
        boolean dataCacheEnabled = !this.designtime && !Boolean.FALSE.equals(dataCacheEnabledRaw);
        SortingDataFactory sortingDataFactory = new SortingDataFactory(this.lookupDataFactory(processedReport), this.performanceMonitorContext);
        CachingDataFactory dataFactory = new CachingDataFactory(sortingDataFactory, dataCacheEnabled);
        dataFactory.initialize(new ProcessingDataFactoryContext(processingContext, dataFactory));
        FunctionStorageKey functionStorageKey = FunctionStorageKey.createKey(null, processedReport);
        this.dataFactoryManager.store(functionStorageKey, dataFactory, true);
        this.flowController = flowController;
        Integer queryLimitDefault = IntegerCache.getInteger(processedReport.getQueryLimit());
        Integer queryTimeoutDefault = IntegerCache.getInteger(processedReport.getQueryTimeout());
        String queryDefined = this.designtime ? "design-time-query" : processedReport.getQuery();
        Object queryRaw = this.evaluateExpression(processedReport.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query"), queryDefined);
        Object queryLimitRaw = this.evaluateExpression(processedReport.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit"), queryLimitDefault);
        Object queryTimeoutRaw = this.evaluateExpression(processedReport.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-timeout"), queryTimeoutDefault);
        List<SortConstraint> sortOrder = this.lookupSortOrder(processedReport);
        this.query = (String)ConverterRegistry.convert(queryRaw, String.class, processedReport.getQuery());
        this.queryLimit = (Integer)ConverterRegistry.convert(queryLimitRaw, Integer.class, queryLimitDefault);
        this.queryTimeout = (Integer)ConverterRegistry.convert(queryTimeoutRaw, Integer.class, queryTimeoutDefault);
        DefaultFlowController postQueryFlowController = flowController.performQuery(dataFactory, this.query, this.queryLimit, this.queryTimeout, processingContext.getResourceBundleFactory(), sortOrder);
        MasterReportProcessPreprocessor postProcessor = new MasterReportProcessPreprocessor(postQueryFlowController);
        MasterReport fullReport = postProcessor.invokePreProcessing(processedReport);
        postQueryFlowController = postProcessor.getFlowController();
        if (!this.isStructureRunNeeded(processedReport)) {
            this.structuralPreprocessingNeeded = false;
        } else {
            this.structuralPreprocessingNeeded = true;
            this.processLevels.add(Integer.MAX_VALUE);
            postQueryFlowController.requireStructuralProcessing();
        }
        Expression[] expressions = this.designtime ? new Expression[]{} : fullReport.getExpressions().getExpressions();
        this.flowController = postQueryFlowController.activateExpressions(expressions, false);
        this.report = new ReportDefinitionImpl(fullReport, fullReport.getPageDefinition());
        this.layoutProcess = new SubLayoutProcess(layoutProcess, this.computeStructureFunctions(fullReport.getStructureFunctions(), this.getFlowController().getReportContext().getOutputProcessorMetaData()), fullReport.getObjectID());
        this.recorder = StateUtilities.computeLevels(this.flowController, this.layoutProcess, this.processLevels) ? new DefaultGroupSizeRecorder() : new EmptyGroupSizeRecorder();
        this.processKey = this.createKey();
        return flowController.isQueryLimitReached();
    }

    private List<SortConstraint> lookupSortOrder(ReportDefinition report) {
        Object attribute = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "computed-sort-constraints");
        if (attribute instanceof List) {
            return (List)attribute;
        }
        return Collections.emptyList();
    }

    private void initializeProcessingContext(ProcessingContext processingContext, MasterReport report) {
        Configuration configuration = this.wrapForCompatibility(processingContext);
        processingContext.getOutputProcessorMetaData().initialize(this.mapStaticMetaData(configuration, report));
    }

    private Configuration mapStaticMetaData(Configuration configuration, MasterReport report) {
        HierarchicalConfiguration hc = new HierarchicalConfiguration(configuration);
        this.setConfigurationIfDefined((ModifiableConfiguration)hc, "org.pentaho.reporting.engine.classic.core.layout.fontrenderer.ComplexTextLayout", report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "complex-text"));
        this.setConfigurationIfDefined((ModifiableConfiguration)hc, "org.pentaho.reporting.engine.classic.core.WatermarkPrintedOnTopOfContent", report.getWatermark().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "printed-on-top"));
        return hc;
    }

    private void setConfigurationIfDefined(ModifiableConfiguration config, String configKey, Object value) {
        if (value == null) {
            return;
        }
        try {
            String valueText = ConverterRegistry.toAttributeValue(value);
            config.setConfigProperty(configKey, valueText);
        }
        catch (BeanException e) {
            logger.info((Object)String.format("Ignoring invalid attribute-value override for configuration '%s' with value '%s'", configKey, value));
        }
    }

    private Configuration wrapForCompatibility(ProcessingContext processingContext) {
        int compatibilityLevel = processingContext.getCompatibilityLevel();
        if (compatibilityLevel < 0) {
            return processingContext.getConfiguration();
        }
        if (compatibilityLevel < ClassicEngineBoot.computeVersionId(3, 999, 999)) {
            HierarchicalConfiguration config = new HierarchicalConfiguration(processingContext.getConfiguration());
            config.setConfigProperty("org.pentaho.reporting.engine.classic.core.legacy.WrapProgressMarkerInSection", "true");
            config.setConfigProperty("org.pentaho.reporting.engine.classic.core.legacy.StrictCompatibility", "true");
            return config;
        }
        return processingContext.getConfiguration();
    }

    private boolean isDesigntime() {
        return this.designtime;
    }

    private boolean isReportsShareConnections(ReportDefinition report) {
        Object attribute = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "shared-connections");
        if (Boolean.TRUE.equals(attribute)) {
            return true;
        }
        if (Boolean.FALSE.equals(attribute)) {
            return false;
        }
        return this.reportInstancesShareConnection;
    }

    public void initializeForSubreport(InlineSubreportMarker[] subReports, int subReportIndex, ProcessState parentState) throws ReportProcessingException {
        boolean needPreProcessing;
        SubReport initialSubReport;
        if (parentState == null) {
            throw new NullPointerException();
        }
        this.designtime = parentState.designtime;
        this.crosstabColumnSequenceCounter = new LongSequence(10, -1L);
        this.groupSequenceCounter = new LongSequence(10, -1L);
        this.groupSequenceCounter.set(0, -1L);
        this.recorder = (GroupSizeRecorder)parentState.recorder.clone();
        this.recorder.reset();
        this.performanceMonitorContext = parentState.performanceMonitorContext;
        this.reportInstancesShareConnection = parentState.reportInstancesShareConnection;
        this.groupStarts = new FastStack();
        this.parentSubReportState = parentState;
        this.advanceHandler = BeginReportHandler.HANDLER;
        this.errorHandler = parentState.errorHandler;
        this.functionStorage = parentState.functionStorage;
        this.structureFunctionStorage = parentState.structureFunctionStorage;
        this.processStore = parentState.processStore;
        this.currentGroupIndex = -1;
        this.currentPresentationGroupIndex = -1;
        this.currentSubReport = subReportIndex;
        this.subReports = (InlineSubreportMarker[])subReports.clone();
        this.dataFactoryManager = parentState.dataFactoryManager;
        this.subReportStorage = parentState.subReportStorage;
        this.structuralPreprocessingNeeded = parentState.structuralPreprocessingNeeded;
        this.processLevels = parentState.processLevels;
        this.sequenceCounter = parentState.getSequenceCounter() + 1;
        this.currentSubReportMarker = subReports[subReportIndex];
        this.inlineProcess = parentState.isInlineProcess() || this.currentSubReportMarker.getProcessType() == SubReportProcessType.INLINE;
        SubReport subreportFromMarker = this.currentSubReportMarker.getSubreport();
        FunctionStorageKey functionStorageKey = FunctionStorageKey.createKey(this.parentSubReportState.getProcessKey(), subreportFromMarker);
        if (this.subReportStorage.contains(functionStorageKey)) {
            initialSubReport = this.subReportStorage.restore(functionStorageKey);
            initialSubReport.reconnectParent(subreportFromMarker.getParentSection());
            this.applyCurrentStyleAndAttributes(subreportFromMarker, initialSubReport);
            needPreProcessing = false;
        } else {
            initialSubReport = subreportFromMarker.derive(true);
            initialSubReport.reconnectParent(subreportFromMarker.getParentSection());
            needPreProcessing = true;
        }
        DefaultFlowController parentStateFlowController = parentState.getFlowController();
        ResourceBundleFactory resourceBundleFactory = parentState.getResourceBundleFactory();
        if (this.isSubReportInvisible(initialSubReport, parentStateFlowController)) {
            ReportDefinition parentReport = parentState.getReport();
            SubReport dummyReport = new SubReport(functionStorageKey.getReportId());
            this.report = new ReportDefinitionImpl(dummyReport, parentReport.getPageDefinition(), subreportFromMarker.getParentSection());
            this.flowController = parentStateFlowController.derive();
            this.advanceHandler = EndSubReportHandler.HANDLER;
            this.layoutProcess = new SubLayoutProcess(parentState.layoutProcess, this.computeStructureFunctions(initialSubReport.getStructureFunctions(), this.flowController.getReportContext().getOutputProcessorMetaData()), this.report.getObjectID());
        } else {
            StructureFunction[] functions;
            DefaultFlowController postPreProcessingFlowController;
            SubReport preDataSubReport;
            AbstractDataFactory dataFactory = this.dataFactoryManager.restore(functionStorageKey, this.isReportsShareConnections(initialSubReport));
            if (dataFactory == null) {
                SubReportProcessPreprocessor preprocessor = new SubReportProcessPreprocessor(parentStateFlowController);
                preDataSubReport = preprocessor.invokePreDataProcessing(initialSubReport);
                postPreProcessingFlowController = preprocessor.getFlowController();
                DataFactory subreportDf = this.lookupDataFactory(preDataSubReport);
                boolean dataCacheEnabled = ProcessState.isCacheEnabled(preDataSubReport);
                if (subreportDf == null) {
                    dataFactory = new EmptyDataFactory();
                } else {
                    SortingDataFactory sortingDataFactory = new SortingDataFactory(subreportDf, this.performanceMonitorContext);
                    CachingDataFactory cdataFactory = new CachingDataFactory(sortingDataFactory, dataCacheEnabled);
                    ProcessingContext context = postPreProcessingFlowController.getReportContext();
                    cdataFactory.initialize(new ProcessingDataFactoryContext(context, cdataFactory));
                    this.dataFactoryManager.store(functionStorageKey, cdataFactory, this.isReportsShareConnections(preDataSubReport));
                    dataFactory = cdataFactory;
                }
            } else {
                preDataSubReport = initialSubReport;
                postPreProcessingFlowController = parentStateFlowController;
            }
            ParameterMapping[] inputMappings = preDataSubReport.getInputMappings();
            ParameterMapping[] exportMappings = preDataSubReport.getExportMappings();
            this.flowController = postPreProcessingFlowController.performInitSubreport(dataFactory, inputMappings, resourceBundleFactory);
            Integer queryLimitDefault = IntegerCache.getInteger(preDataSubReport.getQueryLimit());
            Integer queryTimeoutDefault = IntegerCache.getInteger(preDataSubReport.getQueryTimeout());
            Object queryRaw = this.evaluateExpression(preDataSubReport.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query"), preDataSubReport.getQuery());
            Object queryLimitRaw = this.evaluateExpression(preDataSubReport.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit"), queryLimitDefault);
            Object queryTimeoutRaw = this.evaluateExpression(preDataSubReport.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-timeout"), queryTimeoutDefault);
            String queryDefined = this.designtime ? "design-time-query" : preDataSubReport.getQuery();
            this.query = (String)ConverterRegistry.convert(queryRaw, String.class, queryDefined);
            this.queryLimit = (Integer)ConverterRegistry.convert(queryLimitRaw, Integer.class, queryLimitDefault);
            this.queryTimeout = (Integer)ConverterRegistry.convert(queryTimeoutRaw, Integer.class, queryTimeoutDefault);
            List<SortConstraint> sortOrder = this.lookupSortOrder(preDataSubReport);
            DefaultFlowController postQueryFlowController = this.flowController.performSubReportQuery(this.query, this.queryLimit, this.queryTimeout, exportMappings, sortOrder);
            ProxyDataSchemaDefinition schemaDefinition = new ProxyDataSchemaDefinition(preDataSubReport.getDataSchemaDefinition(), postQueryFlowController.getMasterRow().getDataSchemaDefinition());
            postQueryFlowController = postQueryFlowController.updateDataSchema(schemaDefinition);
            SubReport fullReport = preDataSubReport;
            DefaultFlowController fullFlowController = postQueryFlowController;
            if (needPreProcessing) {
                SubReportProcessPreprocessor preprocessor = new SubReportProcessPreprocessor(postQueryFlowController);
                fullReport = preprocessor.invokePreProcessing(preDataSubReport);
                fullFlowController = preprocessor.getFlowController();
                this.subReportStorage.store(functionStorageKey, fullReport);
            }
            this.report = new ReportDefinitionImpl(fullReport, fullReport.getPageDefinition(), subreportFromMarker.getParentSection());
            Expression[] structureFunctions = this.getStructureFunctionStorage().restore(functionStorageKey);
            if (structureFunctions != null) {
                functions = new StructureFunction[structureFunctions.length];
                System.arraycopy(structureFunctions, 0, functions, 0, structureFunctions.length);
                this.layoutProcess = new SubLayoutProcess(parentState.layoutProcess, functions, this.report.getObjectID());
            } else {
                functions = this.computeStructureFunctions(fullReport.getStructureFunctions(), fullFlowController.getReportContext().getOutputProcessorMetaData());
                this.layoutProcess = new SubLayoutProcess(parentState.layoutProcess, functions, this.report.getObjectID());
            }
            boolean preserve = true;
            Expression[] expressions = this.getFunctionStorage().restore(functionStorageKey);
            if (expressions == null) {
                expressions = this.designtime ? new Expression[]{} : fullReport.getExpressions().getExpressions();
                preserve = false;
            }
            this.flowController = fullFlowController.activateExpressions(expressions, preserve);
            this.flowController = this.flowController.refreshDataRow();
            if (this.report.getParentSection() == null) {
                throw new InvalidReportStateException();
            }
            if (this.report.getParentSection().getReportDefinition() != this.parentSubReportState.getReport()) {
                throw new InvalidReportStateException();
            }
            int processingLevel = this.flowController.getReportContext().getProcessingLevel();
            if (processingLevel == -2 && this.parentSubReportState.isInItemGroup() && this.parentSubReportState.getReport().getDetailsFooter().getComputedStyle() == null) {
                throw new InvalidReportStateException();
            }
        }
        StateUtilities.computeLevels(this.flowController, this.layoutProcess, this.processLevels);
        this.processKey = this.createKey();
    }

    @Override
    public ReportProcessStore getProcessStore() {
        return this.processStore;
    }

    private DataFactory lookupDataFactory(AbstractReportDefinition report) {
        if (this.designtime) {
            return new DesignTimeDataFactory();
        }
        return report.getDataFactory();
    }

    private void applyCurrentStyleAndAttributes(SubReport subreportFromMarker, SubReport report) {
        report.getStyle().copyFrom(subreportFromMarker.getStyle());
        report.copyAttributes(subreportFromMarker.getAttributes());
    }

    private boolean isSubReportInvisible(SubReport report, DefaultFlowController flowController) {
        int processingLevel = flowController.getReportContext().getProcessingLevel();
        if (processingLevel != -2) {
            return false;
        }
        if (this.designtime) {
            return false;
        }
        OutputProcessorMetaData metaData = flowController.getReportContext().getOutputProcessorMetaData();
        if (metaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME)) {
            Object attribute = report.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI");
            return Boolean.TRUE.equals(attribute);
        }
        SimpleStyleSheet computedStyle = report.getComputedStyle();
        return !computedStyle.getBooleanStyleProperty(ElementStyleKeys.VISIBLE);
    }

    private static boolean isCacheEnabled(ReportDefinition reportDefinition) {
        while (reportDefinition != null) {
            Object dataCacheEnabledRaw = reportDefinition.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
            if (Boolean.FALSE.equals(dataCacheEnabledRaw)) {
                return false;
            }
            Section parentSection = reportDefinition.getParentSection();
            if (parentSection == null) break;
            reportDefinition = parentSection.getReportDefinition();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluateExpression(Expression expression, Object defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        if (this.designtime) {
            return defaultValue;
        }
        Expression evalExpression = expression.getInstance();
        InlineDataRowRuntime runtime = new InlineDataRowRuntime();
        runtime.setState(this);
        ExpressionRuntime oldRuntime = evalExpression.getRuntime();
        try {
            evalExpression.setRuntime(runtime);
            Object object = evalExpression.getValue();
            return object;
        }
        catch (Exception e) {
            logger.debug((Object)("Failed to evaluate expression " + expression), (Throwable)e);
            Object object = defaultValue;
            return object;
        }
        finally {
            evalExpression.setRuntime(oldRuntime);
        }
    }

    public int[] getRequiredRuntimeLevels() {
        this.processLevels.add(IntegerCache.getInteger(-2));
        int[] retval = new int[this.processLevels.size()];
        Integer[] levels = this.processLevels.toArray(new Integer[this.processLevels.size()]);
        Arrays.sort(levels, new StateUtilities.DescendingComparator());
        for (int i = 0; i < levels.length; ++i) {
            Integer level = levels[i];
            retval[i] = level;
        }
        return retval;
    }

    private StructureFunction[] computeStructureFunctions(StructureFunction[] fromReport, OutputProcessorMetaData metaData) {
        ArrayList<StructureFunction> e = new ArrayList<StructureFunction>(Arrays.asList(fromReport));
        if (this.structuralPreprocessingNeeded) {
            e.add(new CrosstabProcessorFunction());
        }
        if (!this.isDesigntime()) {
            e.add(new AttributeExpressionsEvaluator());
            e.add(new SheetNameFunction());
            e.add(new StyleExpressionsEvaluator());
            e.add(new CellFormatFunction());
            e.add(new WizardItemHideFunction());
        }
        e.add(new MetaDataStyleEvaluator());
        e.add(new StyleResolvingEvaluator());
        Collections.sort(e, new StructureFunctionComparator());
        return e.toArray(new StructureFunction[e.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubReportExecutable() {
        Expression expression = this.getReport().getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "subreport-active");
        if (expression != null) {
            InlineDataRowRuntime dataRowRuntime = new InlineDataRowRuntime();
            dataRowRuntime.setState(this);
            expression.setRuntime(dataRowRuntime);
            try {
                Object value = expression.getValue();
                if (Boolean.FALSE.equals(value)) {
                    boolean bl = false;
                    return bl;
                }
                if ("false".equals(String.valueOf(value))) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                expression.setRuntime(null);
            }
        }
        return true;
    }

    public ProcessState returnFromSubReport(LayoutProcess layoutProcess) throws ReportProcessingException {
        ProcessState state = this.deriveForAdvance();
        state.layoutProcess = (LayoutProcess)layoutProcess.clone();
        return state;
    }

    public ProcessState restart() throws ReportProcessingException {
        if (this.getParentState() != null) {
            throw new IllegalStateException("Cannot reset a state that is a subreport state");
        }
        ProcessState state = this.deriveForStorage();
        state.crosstabColumnSequenceCounter.clear();
        state.groupSequenceCounter.clear();
        state.groupSequenceCounter.set(0, -1L);
        state.recorder.reset();
        state.currentSubReport = -1;
        state.currentGroupIndex = -1;
        state.currentPresentationGroupIndex = -1;
        if (!state.groupStarts.isEmpty()) {
            throw new IllegalStateException();
        }
        state.setAdvanceHandler(BeginReportHandler.HANDLER);
        ReportState parentState = this.getParentSubReportState();
        ReportStateKey parentStateKey = parentState == null ? null : parentState.getProcessKey();
        CachingDataFactory dataFactory = state.dataFactoryManager.restore(FunctionStorageKey.createKey(parentStateKey, state.getReport()), this.isReportsShareConnections(this.report));
        if (dataFactory == null) {
            throw new ReportProcessingException("No data factory on restart()? Somewhere we went wrong.");
        }
        DefaultFlowController fc = state.getFlowController();
        DefaultFlowController cfc = fc.restart();
        DefaultFlowController qfc = cfc.performQuery(dataFactory, this.query, this.queryLimit, this.queryTimeout, fc.getMasterRow().getResourceBundleFactory(), this.lookupSortOrder(state.report));
        Expression[] expressions = this.getFunctionStorage().restore(FunctionStorageKey.createKey(null, state.getReport()));
        DefaultFlowController efc = qfc.activateExpressions(expressions, true);
        state.setFlowController(efc);
        ++state.sequenceCounter;
        state.processKey = state.createKey();
        return state;
    }

    @Override
    public ReportProcessingErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ReportProcessingErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSequenceCounter(int sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
        this.processKey = this.createKey();
    }

    public int getSequenceCounter() {
        return this.sequenceCounter;
    }

    @Override
    public InlineSubreportMarker getCurrentSubReportMarker() {
        return this.currentSubReportMarker;
    }

    @Override
    public boolean isInlineProcess() {
        return this.inlineProcess;
    }

    public SubReportProcessType getSubreportProcessingType() {
        InlineSubreportMarker cm = this.getCurrentSubReportMarker();
        if (cm == null) {
            return SubReportProcessType.BANDED;
        }
        return cm.getProcessType();
    }

    public ProcessState deriveForPagebreak() {
        try {
            ProcessState processState = this.clone();
            processState.flowController = this.flowController.derive();
            processState.report = this.report.clone();
            processState.layoutProcess = this.layoutProcess.deriveForPagebreak();
            return processState;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed but I dont know why ..");
        }
    }

    public ProcessState deriveForAdvance() {
        try {
            ProcessState processState = this.clone();
            ++processState.sequenceCounter;
            processState.processKey = processState.createKey();
            return processState;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed but I dont know why ..");
        }
    }

    public ProcessState deriveForStorage() {
        try {
            ProcessState result = this.clone();
            result.flowController = this.flowController.derive();
            result.report = this.report.clone();
            result.layoutProcess = this.layoutProcess.deriveForStorage();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed but I dont know why ..");
        }
    }

    @Override
    public ProcessState clone() throws CloneNotSupportedException {
        ProcessState result = (ProcessState)super.clone();
        result.groupSequenceCounter = (LongSequence)this.groupSequenceCounter.clone();
        result.crosstabColumnSequenceCounter = (LongSequence)this.crosstabColumnSequenceCounter.clone();
        result.groupStarts = this.groupStarts.clone();
        result.processKey = result.createKey();
        result.recorder = (GroupSizeRecorder)this.recorder.clone();
        return result;
    }

    public AdvanceHandler getAdvanceHandler() {
        return this.advanceHandler;
    }

    private ReportStateKey createKey() {
        ProcessState parent = (ProcessState)this.getParentState();
        if (parent != null) {
            return new ReportStateKey(parent.createKey(), this.getCurrentRow(), this.getEventCode(), this.getCurrentGroupIndex(), this.getCurrentSubReport(), this.sequenceCounter, this.advanceHandler.isRestoreHandler(), this.isInlineProcess());
        }
        return new ReportStateKey(null, this.getCurrentRow(), this.getEventCode(), this.getCurrentGroupIndex(), this.getCurrentSubReport(), this.sequenceCounter, this.advanceHandler.isRestoreHandler(), false);
    }

    public void setAdvanceHandler(AdvanceHandler advanceHandler) {
        if (advanceHandler == null) {
            throw new NullPointerException();
        }
        this.advanceHandler = advanceHandler;
        this.processKey = null;
    }

    public final ProcessState advance() throws ReportProcessingException {
        return this.advanceHandler.advance(this);
    }

    public final ProcessState commit() throws ReportProcessingException {
        ProcessState commit = this.advanceHandler.commit(this);
        commit.processKey = commit.createKey();
        return commit;
    }

    @Override
    public int getCurrentRow() {
        return this.flowController.getMasterRow().getCursor();
    }

    @Override
    public int getCurrentDataItem() {
        return this.flowController.getMasterRow().getRawDataCursor();
    }

    @Override
    public int getProgressLevel() {
        return this.flowController.getReportContext().getProgressLevel();
    }

    @Override
    public int getProgressLevelCount() {
        return this.flowController.getReportContext().getProgressLevelCount();
    }

    @Override
    public boolean isPrepareRun() {
        return this.flowController.getReportContext().isPrepareRun();
    }

    @Override
    public int getLevel() {
        return this.flowController.getReportContext().getProcessingLevel();
    }

    @Override
    public boolean isFinish() {
        return this.advanceHandler.isFinish();
    }

    @Override
    public int getEventCode() {
        return this.advanceHandler.getEventCode();
    }

    @Override
    public int getCurrentGroupIndex() {
        return this.currentGroupIndex;
    }

    public void enterGroup() {
        this.recorder.enterGroup();
        ++this.currentGroupIndex;
        Group group = this.report.getGroup(this.currentGroupIndex);
        this.groupStarts.push((Object)new GroupStartRecord(this.getCurrentRow(), group.getName(), group.getGeneratedName()));
        this.groupSequenceCounter.increment(this.currentGroupIndex);
        this.groupSequenceCounter.set(this.currentGroupIndex + 1, 0L);
        if (this.groupStarts.size() != this.currentGroupIndex + 1) {
            throw new IllegalStateException();
        }
    }

    public void leaveGroup() {
        this.recorder.leaveGroup();
        if (this.groupStarts.size() != this.currentGroupIndex + 1) {
            throw new IllegalStateException();
        }
        --this.currentGroupIndex;
        this.groupStarts.pop();
    }

    @Override
    public int getPresentationGroupIndex() {
        return this.currentPresentationGroupIndex;
    }

    public void enterPresentationGroup() {
        ++this.currentPresentationGroupIndex;
    }

    public void leavePresentationGroup() {
        --this.currentPresentationGroupIndex;
    }

    @Override
    public ReportDefinition getReport() {
        return this.report;
    }

    public int getCurrentSubReport() {
        return this.currentSubReport;
    }

    @Override
    public ReportState getParentState() {
        if (this.suspendedState != null) {
            return this.suspendedState;
        }
        if (this.parentSubReportState != null) {
            return this.parentSubReportState;
        }
        return null;
    }

    @Override
    public ReportState getParentSubReportState() {
        return this.parentSubReportState;
    }

    public FunctionStorage getStructureFunctionStorage() {
        return this.structureFunctionStorage;
    }

    public FunctionStorage getFunctionStorage() {
        return this.functionStorage;
    }

    @Override
    public DefaultFlowController getFlowController() {
        return this.flowController;
    }

    public void setFlowController(DefaultFlowController flowController) {
        if (flowController == null) {
            throw new NullPointerException();
        }
        this.flowController = flowController;
        this.processKey = null;
    }

    @Override
    public LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    @Override
    public ReportStateKey getProcessKey() {
        if (this.processKey == null) {
            this.processKey = this.createKey();
        }
        return this.processKey;
    }

    @Override
    public DataRow getDataRow() {
        return this.flowController.getMasterRow().getGlobalView();
    }

    @Override
    public int getNumberOfRows() {
        MasterDataRow masterRow = this.flowController.getMasterRow();
        return masterRow.getRowCount();
    }

    @Override
    public void firePageStartedEvent(int baseEvent) {
        ReportEvent event = new ReportEvent(this, 2 | baseEvent);
        this.flowController = this.flowController.fireReportEvent(event);
        this.layoutProcess.fireReportEvent(event);
    }

    @Override
    public void firePageFinishedEvent(boolean noParentPassing) {
        int eventCode = 0x400 | (noParentPassing ? 0x8000000 : 0);
        ReportEvent event = new ReportEvent(this, eventCode);
        this.flowController = this.flowController.fireReportEvent(event);
        this.layoutProcess.fireReportEvent(event);
    }

    protected void fireReportEvent() {
        int eventCode = this.advanceHandler.getEventCode();
        if ((eventCode & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new IllegalStateException("Cannot fire artificial events.");
        }
        ReportEvent event = new ReportEvent(this, eventCode);
        this.flowController = this.flowController.fireReportEvent(event);
        this.layoutProcess.fireReportEvent(event);
    }

    public static boolean isLastItemInGroup(Group rootGroup, MasterDataRow currentDataRow, MasterDataRow nextDataRow) {
        if (!currentDataRow.isAdvanceable() || nextDataRow == null) {
            return true;
        }
        DataRow nextView = nextDataRow.getGlobalView();
        Group g = rootGroup;
        while (g != null) {
            if (g.isGroupChange(nextView)) {
                return true;
            }
            Section parentSection = g.getParentSection();
            if (parentSection == null) {
                return false;
            }
            Section maybeGroup = parentSection.getParentSection();
            if (maybeGroup instanceof Group) {
                g = (Group)maybeGroup;
                continue;
            }
            g = null;
        }
        return false;
    }

    @Override
    public boolean isSubReportEvent() {
        return this.getParentSubReportState() != null;
    }

    public InlineSubreportMarker[] getSubReports() {
        return (InlineSubreportMarker[])this.subReports.clone();
    }

    public ProcessStateHandle getProcessHandle() {
        return this.processHandle;
    }

    public void setInItemGroup(boolean inItemGroup) {
        if (inItemGroup) {
            this.recorder.enterItems();
        } else {
            this.recorder.leaveItems();
        }
        this.inItemGroup = inItemGroup;
    }

    @Override
    public boolean isInItemGroup() {
        return this.inItemGroup;
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.flowController.getMasterRow().getResourceBundleFactory();
    }

    public boolean isArtifcialState() {
        return (this.advanceHandler.getEventCode() & Integer.MIN_VALUE) != 0;
    }

    @Override
    public GroupingState createGroupingState() {
        return new DefaultGroupingState(this.currentGroupIndex, (FastStack<GroupStartRecord>)this.groupStarts.clone());
    }

    private boolean isStructureRunNeeded(Section section) {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = section.getElement(i);
            Object type = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
            if (type instanceof ExternalElementType) {
                return true;
            }
            if (element instanceof CrosstabGroup) {
                return true;
            }
            if (element instanceof SubReport) {
                return true;
            }
            if (element instanceof RootLevelBand) {
                RootLevelBand band = (RootLevelBand)((Object)element);
                if (band.getSubReportCount() > 0) {
                    return true;
                }
                if (!this.isStructureRunNeeded((Section)element)) continue;
                return true;
            }
            if (!(element instanceof Section) || !this.isStructureRunNeeded((Section)element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStructuralPreprocessingNeeded() {
        return this.structuralPreprocessingNeeded;
    }

    public void advanceCursor() {
        this.recorder.advanceItems();
    }

    @Override
    public Integer getPredictedStateCount() {
        return this.recorder.getPredictedStateCount();
    }

    @Override
    public boolean isCrosstabActive() {
        return this.flowController.isCrosstabActive();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProcessState={");
        b.append("runLevel=").append(this.getLevel());
        b.append(", key=").append(this.getProcessKey());
        b.append("}");
        return b.toString();
    }

    public ProcessState recordCrosstabRowState() {
        ProcessState next = this.deriveForAdvance();
        next.flowController = this.flowController.recordCrosstabRowState();
        next.crosstabColumnSequenceCounter.clear();
        next.crosstabColumnSequenceCounter.fill(-1L);
        return next;
    }

    public ProcessState replayStoredCrosstabRowState() {
        ProcessState next = this.deriveForAdvance();
        next.replayStoredCrosstabGroup = this.currentGroupIndex + 1;
        next.suspendedState = this;
        next.flowController = this.flowController.replayStoredCrosstabRowState();
        next.processKey = next.createKey();
        return next;
    }

    public int getReplayStoredCrosstabGroup() {
        return this.replayStoredCrosstabGroup;
    }

    public AdvanceHandler getPostSummaryRowAdvanceHandler() {
        return this.postSummaryRowAdvanceHandler;
    }

    public void setPostSummaryRowAdvanceHandler(AdvanceHandler postSummaryRowAdvanceHandler) {
        this.postSummaryRowAdvanceHandler = postSummaryRowAdvanceHandler;
    }

    public ProcessState finishReplayingStoredCrosstabRowState() throws ReportProcessingException {
        ProcessState next = this.suspendedState.deriveForAdvance();
        next.layoutProcess = (LayoutProcess)this.layoutProcess.clone();
        next.flowController = this.flowController.derive();
        next.advanceHandler = this.advanceHandler;
        next.flowController.getMasterRow().validateReplayFinished();
        return next;
    }

    public void clearStoredCrosstabRowState() {
        this.flowController = this.flowController.clearRecordedCrosstabRowState();
    }

    @Override
    public long getGroupSequenceCounter(int groupIndex) {
        return this.groupSequenceCounter.get(groupIndex);
    }

    @Override
    public long getCrosstabColumnSequenceCounter(int groupIndex) {
        return this.crosstabColumnSequenceCounter.get(groupIndex);
    }

    public void crosstabResetColumnIndices() {
        this.crosstabColumnSequenceCounter.clear();
        this.crosstabColumnSequenceCounter.fill(-1L);
    }

    public void crosstabIncrementColumnCounter() {
        this.crosstabColumnSequenceCounter.increment(this.currentGroupIndex);
    }

    @Override
    public PerformanceMonitorContext getPerformanceMonitorContext() {
        return this.performanceMonitorContext;
    }

    private static class InternalPerformanceMonitorContext
    implements PerformanceMonitorContext {
        private PerformanceMonitorContext parent;
        private EventListenerList listeners;

        private InternalPerformanceMonitorContext(PerformanceMonitorContext parent) {
            this.parent = parent;
            this.listeners = new EventListenerList();
        }

        @Override
        public PerformanceLoggingStopWatch createStopWatch(String tag) {
            return this.parent.createStopWatch(tag);
        }

        @Override
        public PerformanceLoggingStopWatch createStopWatch(String tag, Object message) {
            return this.parent.createStopWatch(tag, message);
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.listeners.add(ChangeListener.class, listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.listeners.remove(ChangeListener.class, listener);
        }

        @Override
        public void close() {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
                changeListener.stateChanged(event);
            }
        }
    }

    private static class InternalProcessHandle
    implements ProcessStateHandle {
        private PerformanceMonitorContext monitorContext;
        private DataFactoryManager manager;

        private InternalProcessHandle(DataFactoryManager manager, PerformanceMonitorContext monitorContext) {
            this.manager = manager;
            this.monitorContext = monitorContext;
        }

        @Override
        public void close() {
            this.monitorContext.close();
            this.manager.close();
        }
    }
}

