/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class DrawablePanel
extends JPanel {
    private DrawableWrapper drawable;

    public DrawablePanel() {
        this.setOpaque(false);
    }

    public DrawableWrapper getDrawable() {
        return this.drawable;
    }

    public void setDrawableAsRawObject(Object o) {
        if (o == null) {
            this.setDrawable(null);
        } else if (o instanceof DrawableWrapper) {
            this.setDrawable((DrawableWrapper)o);
        } else {
            this.setDrawable(new DrawableWrapper(o));
        }
    }

    public void setDrawable(DrawableWrapper drawable) {
        this.drawable = drawable;
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.drawable == null) {
            return new Dimension(0, 0);
        }
        return this.drawable.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.drawable == null) {
            return new Dimension(0, 0);
        }
        return this.drawable.getPreferredSize();
    }

    @Override
    public boolean isOpaque() {
        if (this.drawable == null) {
            return false;
        }
        return super.isOpaque();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawable == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create(0, 0, this.getWidth(), this.getHeight());
        this.drawable.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        g2.dispose();
    }
}

