/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.internal;

import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class ActionCategory
implements Comparable {
    private String resourceBase;
    private String resourcePrefix;
    private int position;
    private ResourceBundleSupport resources;
    private String name = "";
    private boolean userDefined;

    public void initialize(SwingGuiContext context) {
        this.resources = new ResourceBundleSupport(context.getLocale(), this.resourceBase, ObjectUtilities.getClassLoader(ActionCategory.class));
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public void setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public String getDisplayName() {
        return this.resources.getString(this.resourcePrefix + "name");
    }

    public String getShortDescription() {
        return this.resources.getString(this.resourcePrefix + "description");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic(this.resourcePrefix + "mnemonic");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionCategory that = (ActionCategory)o;
        if (this.position != that.position) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.position;
        result = 29 * result + this.name.hashCode();
        return result;
    }

    public int compareTo(Object o) {
        ActionCategory other = (ActionCategory)o;
        if (this.position < other.position) {
            return -1;
        }
        if (this.position > other.position) {
            return 1;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return "ActionCategory{name='" + this.name + '\'' + ", position=" + this.position + ", resourceBase='" + this.resourceBase + '\'' + ", resourcePrefix='" + this.resourcePrefix + '\'' + ", resources=" + this.resources + '}';
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }
}

