/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowImpl;
import org.pentaho.reporting.engine.classic.core.util.BulkArrayList;

public class AbstractRowSizeCache {
    private long[] validatedSizes;
    private int validateSizesFillState;

    private int computeMaxArraySize(long[] array, int rowCount) {
        if (array == null) {
            return rowCount;
        }
        return Math.max(rowCount, array.length + 2000);
    }

    protected long[] get(BulkArrayList<TableRowImpl> rows) {
        int rowCount = rows.size();
        if (this.validatedSizes == null || this.validatedSizes.length < rowCount) {
            int growth = this.computeMaxArraySize(this.validatedSizes, rowCount);
            long[] newValidatedSizes = new long[growth];
            if (this.validatedSizes != null) {
                System.arraycopy(this.validatedSizes, 0, newValidatedSizes, 0, this.validatedSizes.length);
            }
            this.validatedSizes = newValidatedSizes;
        }
        return this.validatedSizes;
    }

    public void setFillState(int validateSizesFillState) {
        this.validateSizesFillState = validateSizesFillState;
    }

    public int getFillState() {
        return this.validateSizesFillState;
    }
}

