/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceReferenceSynchronizer;
import org.pentaho.di.trans.dataservice.serialization.SynchronizationListener;
import org.pentaho.di.trans.dataservice.ui.DataServiceDialog;
import org.pentaho.di.trans.dataservice.ui.DataServiceRemapConfirmationDialog;
import org.pentaho.di.trans.dataservice.ui.DataServiceRemapStepChooserDialog;
import org.pentaho.di.trans.dataservice.ui.UIFactory;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class DataServiceDelegate
extends DataServiceFactory {
    private static final Class<?> PKG = DataServiceDelegate.class;
    private final Supplier<Spoon> spoonSupplier;
    protected static final Supplier<Spoon> defaultSpoonSupplier = new Supplier<Spoon>(){

        public Spoon get() {
            return Spoon.getInstance();
        }
    };

    public static DataServiceDelegate withDefaultSpoonInstance(DataServiceContext context) {
        return new DataServiceDelegate(context, defaultSpoonSupplier);
    }

    public DataServiceDelegate(DataServiceContext context) {
        super(context);
        this.spoonSupplier = null;
    }

    public DataServiceDelegate(DataServiceContext context, Spoon spoon) {
        this(context, (Supplier<Spoon>)Suppliers.ofInstance((Object)spoon));
    }

    public DataServiceDelegate(DataServiceContext context, Supplier<Spoon> spoonSupplier) {
        super(context);
        this.spoonSupplier = spoonSupplier;
    }

    public void createNewDataService(String stepName) {
        TransMeta transMeta;
        StepMeta stepMeta;
        if (stepName == null && (stepMeta = this.getLastStepOfActiveTrans()) != null) {
            stepName = stepMeta.getName();
        }
        if ((transMeta = this.getSpoon().getActiveTransformation()).hasChanged()) {
            this.showSavePrompt(BaseMessages.getString(PKG, (String)"DataServiceDelegate.NewTransChanged.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataServiceDelegate.NewTransChanged.Message", (String[])new String[0]));
            if (transMeta.hasChanged()) {
                return;
            }
        }
        try {
            this.getUiFactory().getDataServiceDialogBuilder(transMeta).serviceStep(stepName).build(this).open();
        }
        catch (KettleException e) {
            this.getLogChannel().logError("Unable to create a new data service", (Throwable)e);
        }
    }

    public void editDataService(DataServiceMeta dataService) {
        TransMeta transMeta = dataService.getServiceTrans();
        if (transMeta.hasChanged()) {
            this.showSavePrompt(BaseMessages.getString(PKG, (String)"DataServiceDelegate.EditTransChanged.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataServiceDelegate.EditTransChanged.Message", (String[])new String[0]));
            if (transMeta.hasChanged()) {
                return;
            }
        }
        try {
            DataServiceDialog.Builder builder = this.getUiFactory().getDataServiceDialogBuilder(dataService.getServiceTrans());
            builder.edit(dataService).build(this).open();
        }
        catch (KettleException e) {
            this.getLogChannel().logError("Unable to edit a data service", (Throwable)e);
        }
    }

    public void suggestEdit(DataServiceMeta dataServiceMeta, String title, String text) {
        TransMeta serviceTrans = dataServiceMeta.getServiceTrans();
        if (!serviceTrans.hasChanged() && this.showPrompt(title, text)) {
            this.editDataService(dataServiceMeta);
            serviceTrans.setChanged();
        }
    }

    private void showSavePrompt(String title, String message) {
        MessageDialog dialog = this.getUiFactory().getMessageDialog(this.getShell(), title, null, message, 3, new String[]{BaseMessages.getString(PKG, (String)"DataServiceDelegate.Yes.Button", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataServiceDelegate.No.Button", (String[])new String[0])}, 0);
        if (dialog.open() == 0) {
            try {
                this.getSpoon().saveToFile((EngineMetaInterface)this.getSpoon().getActiveTransformation());
            }
            catch (KettleException e) {
                this.getLogChannel().logError("Failed to save transformation", (Throwable)e);
            }
        } else {
            this.showError(title, BaseMessages.getString(PKG, (String)"DataServiceDelegate.PleaseSave.Message", (String[])new String[0]));
        }
    }

    protected UIFactory getUiFactory() {
        return this.getContext().getUIFactory();
    }

    public SynchronizationListener createSyncService() {
        return new SynchronizationListener(this, new DataServiceReferenceSynchronizer(this.getContext()));
    }

    public void showError(String title, String text) {
        MessageBox mb = this.getUiFactory().getMessageBox(this.getShell(), 40);
        mb.setText(title);
        mb.setMessage(text);
        mb.open();
    }

    public boolean showPrompt(String title, String text) {
        MessageBox mb = this.getUiFactory().getMessageBox(this.getShell(), 200);
        mb.setText(title);
        mb.setMessage(text);
        return mb.open() == 64;
    }

    @Override
    public void save(DataServiceMeta dataService) throws MetaStoreException {
        Spoon spoon = this.getSpoon();
        super.save(dataService);
        spoon.refreshTree();
        spoon.refreshGraph();
    }

    public void removeDataService(DataServiceMeta dataService, boolean prompt) {
        if (prompt) {
            MessageBox messageBox = this.getUiFactory().getMessageBox(this.getShell(), 196);
            messageBox.setText(BaseMessages.getString(PKG, (String)"DataServiceDelegate.DeleteDataService.Title", (String[])new String[0]));
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"DataServiceDelegate.DeleteDataService.Message", (String[])new String[]{dataService.getName()}));
            int answerIndex = messageBox.open();
            if (answerIndex != 64) {
                return;
            }
        }
        this.removeDataService(dataService);
    }

    @Override
    public void removeDataService(DataServiceMeta dataService) {
        super.removeDataService(dataService);
        this.getSpoon().refreshTree();
        this.getSpoon().refreshGraph();
    }

    public void showTestDataServiceDialog(DataServiceMeta dataService) {
        this.showTestDataServiceDialog(dataService, this.getShell());
    }

    public void showTestDataServiceDialog(DataServiceMeta dataService, Shell shell) {
        try {
            this.getUiFactory().getDataServiceTestDialog(this.getUiFactory().getShell(shell), dataService, this.context).open();
        }
        catch (KettleException e) {
            this.getLogChannel().logError("Unable to create test data service dialog", (Throwable)e);
        }
    }

    @Override
    public Repository getRepository() {
        return this.getSpoon().getRepository();
    }

    public void showDriverDetailsDialog() {
        this.showDriverDetailsDialog(this.getShell());
    }

    public void showDriverDetailsDialog(Shell shell) {
        try {
            this.getUiFactory().getDriverDetailsDialog(shell).open();
        }
        catch (Exception e) {
            this.getLogChannel().logError("Unable to create driver details dialog", (Throwable)e);
        }
    }

    public DataServiceRemapConfirmationDialog.Action showRemapConfirmationDialog(DataServiceMeta dataService, List<String> remainingStepNames) {
        try {
            DataServiceRemapConfirmationDialog dialog = this.getUiFactory().getRemapConfirmationDialog(this.getShell(), dataService, remainingStepNames, this);
            dialog.open();
            return dialog.getAction();
        }
        catch (KettleException e) {
            this.getLogChannel().logError("Unable to create remap data service dialog", (Throwable)e);
            return DataServiceRemapConfirmationDialog.Action.CANCEL;
        }
    }

    public DataServiceRemapStepChooserDialog.Action showRemapStepChooserDialog(DataServiceMeta dataService, List<String> remainingStepNames, TransMeta trans) {
        try {
            DataServiceRemapStepChooserDialog dialog = this.getUiFactory().getRemapStepChooserDialog(this.getShell(), dataService, remainingStepNames, this);
            dialog.open();
            return dialog.getAction();
        }
        catch (KettleException e) {
            this.getLogChannel().logError("Unable to create remap data service dialog", (Throwable)e);
            return DataServiceRemapStepChooserDialog.Action.CANCEL;
        }
    }

    public void showRemapNoStepsDialog(Shell shell) {
        try {
            this.getUiFactory().getRemapNoStepsDialog(shell).open();
        }
        catch (KettleException e) {
            this.getLogChannel().logError("Unable to create no steps for remap dialog", (Throwable)e);
        }
    }

    public Spoon getSpoon() {
        return (Spoon)this.spoonSupplier.get();
    }

    public Shell getShell() {
        return this.getSpoon().getShell();
    }

    public Display getDisplay() {
        return (Display)Objects.firstNonNull((Object)Display.getCurrent(), (Object)Display.getDefault());
    }

    public void syncExec(Runnable runnable) {
        this.getDisplay().syncExec(runnable);
    }

    StepMeta getLastStepOfActiveTrans() {
        List steps;
        StepMeta step = null;
        TransMeta activeTrans = this.getSpoon().getActiveTransformation();
        if (activeTrans != null && (steps = activeTrans.getSteps()) != null && !steps.isEmpty()) {
            step = (StepMeta)steps.get(steps.size() - 1);
        }
        return step;
    }
}

