/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationException;
import org.pentaho.di.trans.dataservice.optimization.ValueMetaResolver;
import org.pentaho.di.trans.dataservice.optimization.mongod.MongodbPredicate;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationService;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInput;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.mongo.wrapper.field.MongoField;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MongodbInputParameterGeneration
implements ParameterGenerationService {
    private final ValueMetaResolver valueMetaResolver;
    protected LogChannelInterface log = new LogChannel((Object)this);

    public MongodbInputParameterGeneration(ValueMetaResolver resolver) {
        this.valueMetaResolver = resolver;
    }

    public MongodbInputParameterGeneration() {
        this.valueMetaResolver = new ValueMetaResolver((RowMetaInterface)new RowMeta());
    }

    @Override
    public void pushDown(Condition condition, ParameterGeneration parameterGeneration, StepInterface stepInterface) throws PushDownOptimizationException {
        if (!"MongoDbInput".equals(stepInterface.getStepMeta().getTypeId())) {
            throw new PushDownOptimizationException("Unable to push down to type " + stepInterface.getClass());
        }
        stepInterface.setVariable(parameterGeneration.getParameterName(), this.getMongodbPredicate(condition, this.getFieldMappings(stepInterface)).asFilterCriteria());
    }

    @Override
    public String getParameterDefault() {
        return "{_id:{$exists:true}}";
    }

    @Override
    public OptimizationImpactInfo preview(Condition pushDownCondition, ParameterGeneration parameterGeneration, StepInterface stepInterface) {
        OptimizationImpactInfo impactInfo = new OptimizationImpactInfo(stepInterface.getStepname());
        try {
            String jsonQuery = this.getJsonQuery(stepInterface);
            impactInfo.setQueryBeforeOptimization(jsonQuery);
            if (pushDownCondition == null) {
                impactInfo.setModified(false);
                return impactInfo;
            }
            String predicate = this.getMongodbPredicate(pushDownCondition, this.getFieldMappings(stepInterface)).asFilterCriteria();
            String modifiedQuery = parameterGeneration.setQueryParameter(jsonQuery, predicate);
            if (!modifiedQuery.equals(jsonQuery)) {
                impactInfo.setQueryAfterOptimization(modifiedQuery);
                impactInfo.setModified(true);
            }
        }
        catch (KettleException e) {
            this.log.logDetailed(String.format("Unable to optimize step '%s'", stepInterface.getStepname()));
            impactInfo.setModified(false);
            impactInfo.setErrorMsg((Exception)((Object)e));
        }
        return impactInfo;
    }

    private String getJsonQuery(StepInterface stepInterface) throws KettleException {
        String xml = stepInterface.getStepMeta().getXML();
        String jsonQuery = "";
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            NodeList nodes = doc.getElementsByTagName("json_query");
            if (nodes.getLength() > 0) {
                jsonQuery = nodes.item(0).getTextContent();
            }
        }
        catch (ParserConfigurationException e) {
            this.logFailedToGetJson(xml, e);
        }
        catch (SAXException e) {
            this.logFailedToGetJson(xml, e);
        }
        catch (IOException e) {
            this.logFailedToGetJson(xml, e);
        }
        return jsonQuery;
    }

    protected Map<String, String> getFieldMappings(StepInterface stepInterface) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        MongoDbInput mongoDbInput = (MongoDbInput)stepInterface;
        MongoDbInputMeta mongoDbInputMeta = (MongoDbInputMeta)mongoDbInput.getStepMeta().getStepMetaInterface();
        for (MongoField mongoField : mongoDbInputMeta.getMongoFields()) {
            fieldMap.put(mongoField.getName(), mongoField.getPath());
        }
        return fieldMap;
    }

    private void logFailedToGetJson(String xml, Exception e) {
        this.log.logError("Failed to read json_query from xml:  " + xml, (Throwable)e);
    }

    protected MongodbPredicate getMongodbPredicate(Condition condition, Map<String, String> fieldMappings) {
        return new MongodbPredicate(condition, this.valueMetaResolver, fieldMappings);
    }
}

