/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui;

import java.util.Iterator;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.runtime.test.RuntimeTest;
import org.pentaho.runtime.test.RuntimeTestProgressCallback;
import org.pentaho.runtime.test.RuntimeTestStatus;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.module.RuntimeTestModuleResults;
import org.pentaho.runtime.test.result.RuntimeTestResult;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;

public class ClusterTestDialog
extends Dialog {
    private static final Class<?> PKG = ClusterTestDialog.class;
    private Shell shell;
    private PropsUI props;
    private final NamedCluster namedCluster;
    private final RuntimeTester runtimeTester;
    private RuntimeTestStatus runtimeTestStatus = null;
    protected LogChannel log;

    public static ClusterTestDialog create(Shell parent, NamedCluster namedCluster, RuntimeTester clusterTester) throws KettleException {
        return new ClusterTestDialog(parent, namedCluster, clusterTester);
    }

    public ClusterTestDialog(Shell parent, NamedCluster namedCluster, RuntimeTester runtimeTester) throws KettleException {
        super(parent);
        this.namedCluster = namedCluster;
        this.runtimeTester = runtimeTester;
        this.props = PropsUI.getInstance();
        this.log = new LogChannel((Object)namedCluster);
    }

    public RuntimeTestStatus open() {
        Shell parent = this.getParent();
        final Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3297);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        int margin = 5;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = margin;
        formLayout.marginHeight = margin;
        int shellWidth = 385;
        int shellHeight = 160;
        this.shell.setSize(385, 160);
        this.shell.setMinimumSize(385, 160);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ClusterTestDialog.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        Label testingClusterLabel = new Label((Composite)this.shell, 0);
        testingClusterLabel.setText(BaseMessages.getString(PKG, (String)"ClusterTestDialog.ClusterTest.Label", (String[])new String[0]));
        testingClusterLabel.setForeground(GUIResource.getInstance().getColorCrystalTextPentaho());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment(0, margin);
        testingClusterLabel.setLayoutData((Object)fd);
        final Label testLabel = new Label((Composite)this.shell, 0);
        testLabel.setText("Testing cluster...");
        fd = new FormData();
        fd.top = new FormAttachment((Control)testingClusterLabel, 10);
        fd.right = new FormAttachment(100, -margin);
        fd.left = new FormAttachment(0, margin);
        testLabel.setLayoutData((Object)fd);
        final ProgressBar progressBar = new ProgressBar((Composite)this.shell, 65536);
        progressBar.setMinimum(0);
        fd = new FormData();
        fd.top = new FormAttachment((Control)testLabel, 10);
        fd.left = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, -margin);
        progressBar.setLayoutData((Object)fd);
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ClusterTestDialog.this.cancel();
            }
        });
        Button[] buttons = new Button[]{wCancel};
        BaseStepDialog.positionBottomRightButtons((Composite)this.shell, (Button[])buttons, (int)margin, null);
        this.shell.setBackgroundMode(2);
        Rectangle shellBounds = Spoon.getInstance().getShell().getBounds();
        this.shell.open();
        this.shell.setLocation(shellBounds.x + (shellBounds.width - 385) / 2, shellBounds.y + (shellBounds.height - 160) / 2);
        this.runtimeTester.runtimeTest((Object)this.namedCluster, new RuntimeTestProgressCallback(){
            private int numTests = -1;

            public void onProgress(final RuntimeTestStatus clusterTestStatus) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (progressBar.isDisposed()) {
                            return;
                        }
                        if (numTests == -1) {
                            numTests = clusterTestStatus.getTestsDone() + clusterTestStatus.getTestsOutstanding() + clusterTestStatus.getTestsRunning();
                            progressBar.setMaximum(numTests);
                        }
                        progressBar.setSelection(clusterTestStatus.getTestsDone());
                        for (RuntimeTestModuleResults results : clusterTestStatus.getModuleResults()) {
                            Iterator runningTests = results.getRunningTests().iterator();
                            if (!runningTests.hasNext()) continue;
                            testLabel.setText(((RuntimeTest)runningTests.next()).getName());
                        }
                        if (clusterTestStatus.isDone()) {
                            ClusterTestDialog.this.runtimeTestStatus = clusterTestStatus;
                            testLabel.setText(BaseMessages.getString((Class)PKG, (String)"ClusterTestDialog.TestsFinished", (String[])new String[0]));
                            for (RuntimeTestModuleResults results : clusterTestStatus.getModuleResults()) {
                                ClusterTestDialog.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"ClusterTestDialog.ModuleTest", (String[])new String[]{results.getName()}));
                                for (RuntimeTestResult result : results.getRuntimeTestResults()) {
                                    String clusterTestName = result.getRuntimeTest().getName();
                                    if (result.getRuntimeTestResultEntries().isEmpty()) {
                                        RuntimeTestResultEntry entry = result.getOverallStatusEntry();
                                        ClusterTestDialog.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"ClusterTestDialog.TestResult", (String[])new String[]{clusterTestName, entry.getSeverity().toString(), entry.getDescription()}));
                                        ClusterTestDialog.this.log.logBasic("\t" + entry.getMessage());
                                        if (!ClusterTestDialog.this.log.isDetailed() || entry.getException() == null) continue;
                                        ClusterTestDialog.this.log.logDetailed(ExceptionUtils.getStackTrace((Throwable)entry.getException()));
                                        continue;
                                    }
                                    for (RuntimeTestResultEntry entry : result.getRuntimeTestResultEntries()) {
                                        ClusterTestDialog.this.log.logBasic(BaseMessages.getString((Class)PKG, (String)"ClusterTestDialog.TestResult", (String[])new String[]{clusterTestName, entry.getSeverity().toString(), entry.getDescription()}));
                                        ClusterTestDialog.this.log.logBasic("\t" + entry.getMessage());
                                        if (!ClusterTestDialog.this.log.isDetailed() || entry.getException() == null) continue;
                                        ClusterTestDialog.this.log.logDetailed(ExceptionUtils.getStackTrace((Throwable)entry.getException()));
                                    }
                                }
                            }
                            ClusterTestDialog.this.dispose();
                        }
                    }
                });
            }
        });
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.runtimeTestStatus;
    }

    private void cancel() {
        this.runtimeTestStatus = null;
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

