/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.BasicAWSCredentials;
import org.apache.commons.lang.StringUtils;

public class BasicAWSCredentialsProvider
implements AWSCredentialsProvider {
    private final String accessKey;
    private final String secretKey;

    public BasicAWSCredentialsProvider(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    @Override
    public AWSCredentials getCredentials() {
        if (!StringUtils.isEmpty((String)this.accessKey) && !StringUtils.isEmpty((String)this.secretKey)) {
            return new BasicAWSCredentials(this.accessKey, this.secretKey);
        }
        throw new AmazonClientException("Access key or secret key is null");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

