/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http;

import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.metrics.MetricInputStreamEntity;
import com.cloudera.com.amazonaws.metrics.ThroughputMetricType;
import com.cloudera.com.amazonaws.metrics.internal.ServiceMetricTypeGuesser;
import com.cloudera.org.apache.http.entity.BasicHttpEntity;
import com.cloudera.org.apache.http.entity.InputStreamEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private static final Log log = LogFactory.getLog(RepeatableInputStreamRequestEntity.class);
    private IOException originalException;

    RepeatableInputStreamRequestEntity(Request<?> request) {
        this.setChunked(false);
        long contentLength = -1L;
        try {
            String contentLengthString = request.getHeaders().get("Content-Length");
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)"Unable to parse content length from request.  Buffering contents in memory.");
        }
        String contentType = request.getHeaders().get("Content-Type");
        ThroughputMetricType type = ServiceMetricTypeGuesser.guessThroughputMetricType(request, "UploadThroughput", "UploadByteCount");
        this.inputStreamRequestEntity = type == null ? new InputStreamEntity(request.getContent(), contentLength) : new MetricInputStreamEntity(type, request.getContent(), contentLength);
        this.inputStreamRequestEntity.setContentType(contentType);
        this.content = request.getContent();
        this.setContent(this.content);
        this.setContentType(contentType);
        this.setContentLength(contentLength);
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        try {
            if (!this.firstAttempt && this.isRepeatable()) {
                this.content.reset();
            }
            this.firstAttempt = false;
            this.inputStreamRequestEntity.writeTo(output);
        }
        catch (IOException ioe) {
            if (this.originalException == null) {
                this.originalException = ioe;
            }
            throw this.originalException;
        }
    }
}

