/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.annotation;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.CreateMeasure;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.BaseAnnotationMeta;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationData;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class ModelAnnotationStep
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = ModelAnnotationMeta.class;

    public ModelAnnotationStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        BaseAnnotationMeta bmeta = (BaseAnnotationMeta)smi;
        if (!bmeta.isSharedDimension()) {
            ModelAnnotationMeta meta = (ModelAnnotationMeta)bmeta;
            if (StringUtils.isNotEmpty((String)meta.sharedAnnotationGroup)) {
                meta.setModelAnnotationCategory(meta.sharedAnnotationGroup);
            }
            ModelAnnotationGroup modelAnnotations = meta.getModelAnnotations();
            if (StringUtils.isEmpty((String)meta.getModelAnnotationCategory())) {
                if (modelAnnotations == null) {
                    modelAnnotations = new ModelAnnotationGroup();
                    meta.setModelAnnotations(modelAnnotations);
                }
                modelAnnotations.addInjectedAnnotations(meta.createMeasureAnnotations);
                modelAnnotations.addInjectedAnnotations(meta.createAttributeAnnotations);
                modelAnnotations.addInjectedAnnotations(meta.createLinkDimensionAnnotations);
                meta.createCalcMeasureAnnotations.stream().forEach(calc -> calc.setDimension("Measures"));
                modelAnnotations.addInjectedAnnotations(meta.createCalcMeasureAnnotations);
            }
        }
        try {
            ModelAnnotationData modelAnnotationData = (ModelAnnotationData)sdi;
            if (bmeta.isSharedDimension() && !this.isOutputStepFound(bmeta.getTargetOutputStep())) {
                this.log.logError(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.MissingDataProvider", (String[])new String[0]));
            } else {
                modelAnnotationData.annotations = this.processAnnotations(bmeta);
            }
        }
        catch (KettleException e) {
            this.log.logError(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        boolean superInit = super.init(smi, sdi);
        return superInit;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row = this.getRow();
        if (this.first && row != null) {
            this.first = false;
        }
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.getInputRowMeta(), row);
        return true;
    }

    private ModelAnnotationGroup processAnnotations(BaseAnnotationMeta modelAnnotationMeta) throws KettleException {
        ModelAnnotationGroup currentGroup;
        if (this.isGroupLinked(modelAnnotationMeta)) {
            String groupName = this.environmentSubstitute(modelAnnotationMeta.getModelAnnotationCategory());
            currentGroup = this.fetchAnnotations(groupName, modelAnnotationMeta);
        } else {
            currentGroup = modelAnnotationMeta.getModelAnnotations();
        }
        this.validateMeasuresNumeric(currentGroup);
        ModelAnnotationGroup allAnnotations = this.getExistingAnnotations();
        if (!currentGroup.isSharedDimension()) {
            allAnnotations.addAll((Collection)currentGroup);
        }
        if (this.getTrans().getParentJob() != null) {
            this.getTrans().getParentJob().getExtensionDataMap().put("KEY_MODEL_ANNOTATIONS", allAnnotations);
        } else {
            this.getTrans().getExtensionDataMap().put("KEY_MODEL_ANNOTATIONS", allAnnotations);
        }
        return currentGroup;
    }

    private boolean isGroupLinked(BaseAnnotationMeta meta) {
        return !StringUtils.isBlank((String)this.environmentSubstitute(meta.getModelAnnotationCategory()));
    }

    protected ModelAnnotationGroup fetchAnnotations(String groupName, BaseAnnotationMeta modelAnnotationMeta) throws KettleException {
        if (StringUtils.isBlank((String)groupName)) {
            throw new IllegalArgumentException("no group");
        }
        if (this.getMetaStore() == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.NoMetastore", (String[])new String[0]));
        }
        try {
            ModelAnnotationManager mgr = this.getModelAnnotationsManager(modelAnnotationMeta);
            ModelAnnotationGroup group = mgr.readGroup(groupName, this.metaStore);
            if (group == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)(modelAnnotationMeta.isSharedDimension() ? "ModelAnnotation.Runtime.GroupNotFound" : "ModelAnnotation.Runtime.AnnotationGroupNotFound"), (String[])new String[]{groupName}));
            }
            return group;
        }
        catch (MetaStoreException e) {
            throw new KettleException((Throwable)e);
        }
    }

    protected ModelAnnotationManager getModelAnnotationsManager(BaseAnnotationMeta modelAnnotationMeta) {
        if (modelAnnotationMeta.isSharedDimension()) {
            return new ModelAnnotationManager(true);
        }
        return new ModelAnnotationManager();
    }

    private void validateMeasuresNumeric(ModelAnnotationGroup annotations) throws KettleException {
        RowMetaInterface inputRowMeta = this.getInputRowMeta();
        if (inputRowMeta == null) {
            inputRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta());
        }
        if (inputRowMeta != null) {
            for (ModelAnnotation annotation : annotations) {
                if (annotation.getType() == null || !annotation.getType().equals((Object)ModelAnnotation.Type.CREATE_MEASURE)) continue;
                for (ValueMetaInterface valueMeta : inputRowMeta.getValueMetaList()) {
                    CreateMeasure createMeasure;
                    if (valueMeta.isNumeric() || !valueMeta.getName().equals(annotation.getAnnotation().getField()) || (createMeasure = (CreateMeasure)annotation.getAnnotation()).getAggregateType().equals((Object)AggregationType.COUNT) || createMeasure.getAggregateType().equals((Object)AggregationType.COUNT_DISTINCT)) continue;
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ModelAnnotation.Runtime.NonNumericMeasure", (String[])new String[]{createMeasure.getAggregateType().name()}));
                }
            }
        }
    }

    private ModelAnnotationGroup getExistingAnnotations() {
        Object o;
        Object v = o = this.getTrans().getParentJob() == null ? this.getTrans().getExtensionDataMap().get("KEY_MODEL_ANNOTATIONS") : this.getTrans().getParentJob().getExtensionDataMap().get("KEY_MODEL_ANNOTATIONS");
        if (o == null) {
            return new ModelAnnotationGroup();
        }
        return (ModelAnnotationGroup)o;
    }

    private boolean isOutputStepFound(String outputStep) throws KettleException {
        if (!Const.isEmpty((String)outputStep)) {
            for (StepMetaDataCombi outCombi : this.getTrans().getSteps()) {
                if (!outCombi.stepname.equals(this.environmentSubstitute(outputStep))) continue;
                return true;
            }
        }
        return false;
    }
}

