/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.cache.QueryCompilationCache;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.memory.ArrayContainsMethodEvaluator;
import org.datanucleus.query.evaluator.memory.ArraySizeMethodEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected NucleusContext nucleusCtx;
    protected StoreManager storeMgr;
    QueryCompilationCache queryCompilationCache = null;
    QueryDatastoreCompilationCache queryCompilationCacheDatastore = null;
    QueryResultsCache queryResultsCache = null;
    Map<String, Map<Object, InvocationEvaluator>> queryMethodEvaluatorMap = new HashMap<String, Map<Object, InvocationEvaluator>>();

    public QueryManager(NucleusContext nucleusContext, StoreManager storeMgr) {
        this.nucleusCtx = nucleusContext;
        this.storeMgr = storeMgr;
        this.initialiseQueryCaches();
    }

    protected void initialiseQueryCaches() {
        String cacheClassName;
        PersistenceConfiguration conf = this.nucleusCtx.getPersistenceConfiguration();
        String cacheType = conf.getStringProperty("datanucleus.cache.queryCompilation.type");
        if (cacheType != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("021500", (Object)cacheType)).setFatal();
            }
            try {
                this.queryCompilationCache = (QueryCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("021502", (Object)cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("021501", (Object)cacheType, (Object)cacheClassName), e).setFatal();
            }
        }
        if ((cacheType = conf.getStringProperty("datanucleus.cache.queryCompilationDatastore.type")) != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("021500", (Object)cacheType)).setFatal();
            }
            try {
                this.queryCompilationCacheDatastore = (QueryDatastoreCompilationCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("021502", (Object)cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("021501", (Object)cacheType, (Object)cacheClassName), e).setFatal();
            }
        }
        if ((cacheType = conf.getStringProperty("datanucleus.cache.queryResults.type")) != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.nucleusCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("021500", (Object)cacheType)).setFatal();
            }
            try {
                this.queryResultsCache = (QueryResultsCache)this.nucleusCtx.getPluginManager().createExecutableExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusCtx});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("021502", (Object)cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("021501", (Object)cacheType, (Object)cacheClassName), e).setFatal();
            }
        }
    }

    public void close() {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.close();
            this.queryCompilationCache = null;
        }
        if (this.queryCompilationCacheDatastore != null) {
            this.queryCompilationCacheDatastore.close();
            this.queryCompilationCacheDatastore = null;
        }
        if (this.queryResultsCache != null) {
            this.queryResultsCache.close();
            this.queryResultsCache = null;
        }
        this.queryMethodEvaluatorMap.clear();
        this.queryMethodEvaluatorMap = null;
    }

    public Query newQuery(String language, ExecutionContext ec, Object query) {
        if (language == null) {
            return null;
        }
        String languageImpl = language;
        try {
            if (query == null) {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT};
                Object[] args = new Object[]{this.storeMgr, ec};
                Query q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(LOCALISER.msg("021034", (Object)languageImpl, (Object)ec.getStoreManager().getStoreManagerKey()));
                }
                return q;
            }
            Query q = null;
            if (query instanceof String) {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT, String.class};
                Object[] args = new Object[]{this.storeMgr, ec, query};
                q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(LOCALISER.msg("021034", (Object)languageImpl, (Object)ec.getStoreManager().getStoreManagerKey()));
                }
            } else if (query instanceof Query) {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT, query.getClass()};
                Object[] args = new Object[]{this.storeMgr, ec, query};
                q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(LOCALISER.msg("021034", (Object)languageImpl, (Object)ec.getStoreManager().getStoreManagerKey()));
                }
            } else {
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.EXECUTION_CONTEXT, Object.class};
                Object[] args = new Object[]{this.storeMgr, ec, query};
                q = (Query)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, ec.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException(LOCALISER.msg("021034", (Object)languageImpl, (Object)ec.getStoreManager().getStoreManagerKey()));
                }
            }
            return q;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NucleusException(t.getMessage(), t).setFatal();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), e).setFatal();
        }
    }

    public QueryCompilationCache getQueryCompilationCache() {
        return this.queryCompilationCache;
    }

    public synchronized void addQueryCompilation(String language, String query, QueryCompilation compilation) {
        if (this.queryCompilationCache != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCache.put(queryKey, compilation);
        }
    }

    public synchronized QueryCompilation getQueryCompilationForQuery(String language, String query) {
        String queryKey;
        QueryCompilation compilation;
        if (this.queryCompilationCache != null && (compilation = this.queryCompilationCache.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021079", (Object)query, (Object)language));
            }
            return compilation;
        }
        return null;
    }

    public QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.queryCompilationCacheDatastore;
    }

    public synchronized void addDatastoreQueryCompilation(String datastore, String language, String query, Object compilation) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.put(queryKey, compilation);
        }
    }

    public synchronized void deleteDatastoreQueryCompilation(String datastore, String language, String query) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.evict(queryKey);
        }
    }

    public synchronized Object getDatastoreQueryCompilation(String datastore, String language, String query) {
        String queryKey;
        Object compilation;
        if (this.queryCompilationCacheDatastore != null && (compilation = this.queryCompilationCacheDatastore.get(queryKey = language + ":" + query)) != null) {
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021080", (Object)query, (Object)language, (Object)datastore));
            }
            return compilation;
        }
        return null;
    }

    public QueryResultsCache getQueryResultsCache() {
        return this.queryResultsCache;
    }

    public void evictQueryResultsForType(Class cls) {
        if (this.queryResultsCache != null) {
            this.queryResultsCache.evict(cls);
        }
    }

    public synchronized void addDatastoreQueryResult(Query query, Map params, List<Object> results) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            this.queryResultsCache.put(queryKey, results);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021081", query, (Object)results.size()));
            }
        }
    }

    public synchronized List<Object> getDatastoreQueryResult(Query query, Map params) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            List<Object> results = this.queryResultsCache.get(queryKey);
            if (results != null && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021082", query, (Object)results.size()));
            }
            return results;
        }
        return null;
    }

    public InvocationEvaluator getInMemoryEvaluatorForMethod(Class type, String methodName) {
        Map<Object, InvocationEvaluator> evaluatorsForMethod;
        if (type != null && type.isArray()) {
            if (methodName.equals("size") || methodName.equals("length")) {
                return new ArraySizeMethodEvaluator();
            }
            if (methodName.equals("contains")) {
                return new ArrayContainsMethodEvaluator();
            }
        }
        if ((evaluatorsForMethod = this.queryMethodEvaluatorMap.get(methodName)) != null) {
            for (Map.Entry<Object, InvocationEvaluator> entry : evaluatorsForMethod.entrySet()) {
                Object clsKey = entry.getKey();
                if (clsKey instanceof Class && ((Class)clsKey).isAssignableFrom(type)) {
                    return entry.getValue();
                }
                if (!(clsKey instanceof String) || !((String)clsKey).equals("STATIC") || type != null) continue;
                return entry.getValue();
            }
            return null;
        }
        ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(type != null ? type.getClassLoader() : null);
        PluginManager pluginMgr = this.nucleusCtx.getPluginManager();
        ConfigurationElement[] elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.query_method_evaluators", "method", methodName);
        HashMap<Object, InvocationEvaluator> evaluators = new HashMap<Object, InvocationEvaluator>();
        InvocationEvaluator requiredEvaluator = null;
        if (elems == null) {
            return null;
        }
        for (int i = 0; i < elems.length; ++i) {
            try {
                String evalName = elems[i].getAttribute("evaluator");
                InvocationEvaluator eval = (InvocationEvaluator)pluginMgr.createExecutableExtension("org.datanucleus.query_method_evaluators", new String[]{"method", "evaluator"}, new String[]{methodName, evalName}, "evaluator", null, null);
                String elemClsName = elems[i].getAttribute("class");
                if (elemClsName != null && StringUtils.isWhitespace(elemClsName)) {
                    elemClsName = null;
                }
                if (elemClsName == null) {
                    if (type == null) {
                        requiredEvaluator = eval;
                    }
                    evaluators.put("STATIC", eval);
                    continue;
                }
                Class elemCls = clr.classForName(elemClsName);
                if (elemCls.isAssignableFrom(type)) {
                    requiredEvaluator = eval;
                }
                evaluators.put(elemCls, eval);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.queryMethodEvaluatorMap.put(methodName, evaluators);
        return requiredEvaluator;
    }
}

