/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timeline.impl.pb;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineEntityGroupIdPBImpl
extends TimelineEntityGroupId {
    YarnProtos.TimelineEntityGroupIdProto proto = null;
    YarnProtos.TimelineEntityGroupIdProto.Builder builder = null;
    private ApplicationId applicationId = null;

    public TimelineEntityGroupIdPBImpl() {
        this.builder = YarnProtos.TimelineEntityGroupIdProto.newBuilder();
    }

    public TimelineEntityGroupIdPBImpl(YarnProtos.TimelineEntityGroupIdProto proto) {
        this.proto = proto;
        this.applicationId = this.convertFromProtoFormat(proto.getAppId());
    }

    public YarnProtos.TimelineEntityGroupIdProto getProto() {
        return this.proto;
    }

    public String getTimelineEntityGroupId() {
        Preconditions.checkNotNull((Object)this.proto);
        return this.proto.getId();
    }

    protected void setTimelineEntityGroupId(String id) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setId(id);
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    protected void setApplicationId(ApplicationId appId) {
        if (appId != null) {
            Preconditions.checkNotNull((Object)this.builder);
            this.builder.setAppId(this.convertToProtoFormat(appId));
        }
        this.applicationId = appId;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    protected void build() {
        this.proto = this.builder.build();
        this.builder = null;
    }
}

