/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.java14print;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.extensions.modules.java14print.Java14PrintUtil;

public class Java14RepaginateAndPrintExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(Java14RepaginateAndPrintExportTask.class);
    private MasterReport job;
    private ReportProgressDialog progressListener;
    private StatusListener statusListener;

    public Java14RepaginateAndPrintExportTask(MasterReport job, ReportProgressDialog progressListener, StatusListener statusListener) {
        this.job = job;
        this.progressListener = progressListener;
        this.statusListener = statusListener;
    }

    @Override
    public void run() {
        try {
            Java14PrintUtil.print(this.job, new OnDemandShowProgressListener(this.progressListener));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to print the report", (Throwable)e);
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, "Export failed", (Throwable)e);
            }
        }
        finally {
            if (this.progressListener != null) {
                this.progressListener.setVisible(false);
            }
        }
    }

    private static class OnDemandShowProgressListener
    implements ReportProgressListener {
        private ReportProgressDialog dialog;

        private OnDemandShowProgressListener(ReportProgressDialog dialog) {
            this.dialog = dialog;
        }

        public void reportProcessingStarted(ReportProgressEvent event) {
            if (this.dialog != null) {
                this.dialog.setVisibleInEDT(true);
                this.dialog.reportProcessingStarted(event);
            }
        }

        public void reportProcessingUpdate(ReportProgressEvent event) {
            if (this.dialog != null) {
                this.dialog.reportProcessingUpdate(event);
            }
        }

        public void reportProcessingFinished(ReportProgressEvent event) {
            if (this.dialog != null) {
                this.dialog.reportProcessingFinished(event);
                this.dialog.setVisibleInEDT(false);
            }
        }
    }
}

