/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.BasePlanetObject;
import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.PlanetModel;

public abstract class GeoBaseShape
extends BasePlanetObject
implements GeoShape {
    public GeoBaseShape(PlanetModel planetModel) {
        super(planetModel);
    }

    @Override
    public void getBounds(Bounds bounds) {
        if (this.isWithin(this.planetModel.NORTH_POLE)) {
            bounds.noTopLatitudeBound().noLongitudeBound().addPoint(this.planetModel.NORTH_POLE);
        }
        if (this.isWithin(this.planetModel.SOUTH_POLE)) {
            bounds.noBottomLatitudeBound().noLongitudeBound().addPoint(this.planetModel.SOUTH_POLE);
        }
        if (this.isWithin(this.planetModel.MIN_X_POLE)) {
            bounds.addPoint(this.planetModel.MIN_X_POLE);
        }
        if (this.isWithin(this.planetModel.MAX_X_POLE)) {
            bounds.addPoint(this.planetModel.MAX_X_POLE);
        }
        if (this.isWithin(this.planetModel.MIN_Y_POLE)) {
            bounds.addPoint(this.planetModel.MIN_Y_POLE);
        }
        if (this.isWithin(this.planetModel.MAX_Y_POLE)) {
            bounds.addPoint(this.planetModel.MAX_Y_POLE);
        }
    }
}

