/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.util.ArrayList;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class KettleTransFromRepositoryProducer
extends AbstractKettleTransformationProducer {
    private static final long serialVersionUID = -2029785159214228120L;
    private String directoryName;
    private String transformationName;

    public KettleTransFromRepositoryProducer(String repositoryName, String directoryName, String transformationName, String stepName, String username, String password, FormulaArgument[] definedArgumentNames, FormulaParameter[] definedVariableNames) {
        super(repositoryName, stepName, username, password, definedArgumentNames, definedVariableNames);
        if (directoryName == null) {
            throw new NullPointerException();
        }
        if (transformationName == null) {
            throw new NullPointerException();
        }
        this.directoryName = directoryName;
        this.transformationName = transformationName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getTransformationName() {
        return this.transformationName;
    }

    @Override
    protected TransMeta loadTransformation(Repository repository, ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException, KettleException {
        RepositoryDirectoryInterface repositoryDirectory = repository.loadRepositoryDirectoryTree().findDirectory(this.directoryName);
        if (repositoryDirectory == null) {
            throw new ReportDataFactoryException("No such directory in repository: " + this.directoryName);
        }
        return repository.loadTransformation(this.transformationName, repositoryDirectory, null, true, null);
    }

    @Override
    public Object getQueryHash(ResourceManager resourceManager, ResourceKey resourceKey) {
        ArrayList<Object> retval = this.internalGetQueryHash();
        retval.add(this.getDirectoryName());
        retval.add(this.getTransformationName());
        return retval;
    }

    @Override
    public String getTransformationFile() {
        return null;
    }
}

