/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.hbase.factory;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.pentaho.hadoop.hbase.factory.HBase10Put;
import org.pentaho.hbase.factory.HBasePut;
import org.pentaho.hbase.factory.HBaseTable;

class HBase10Table
implements HBaseTable {
    private final Table tab;
    private BufferedMutator mutator = null;
    private boolean autoFlush = true;
    private final Connection conn;

    HBase10Table(Connection conn, String tableName) throws IOException {
        this.conn = conn;
        this.tab = conn.getTable(TableName.valueOf((String)tableName));
    }

    HBase10Table(Table tab) {
        this.tab = tab;
        this.conn = null;
    }

    private synchronized BufferedMutator getBufferedMutator() throws IOException {
        if (this.conn != null) {
            if (this.mutator == null) {
                this.mutator = this.conn.getBufferedMutator(this.tab.getName());
            }
        } else {
            throw new IOException("Can't mutate the table " + this.tab.getName());
        }
        return this.mutator;
    }

    @Override
    public void setWriteBufferSize(long bufferSize) throws IOException {
        this.tab.setWriteBufferSize(bufferSize);
    }

    @Override
    public void setAutoFlush(boolean autoFlush) throws IOException {
        this.autoFlush = autoFlush;
    }

    @Override
    public boolean isAutoFlush() throws IOException {
        return this.autoFlush;
    }

    @Override
    public ResultScanner getScanner(Scan s) throws IOException {
        return this.tab.getScanner(s);
    }

    @Override
    public Result get(Get toGet) throws IOException {
        return this.tab.get(toGet);
    }

    @Override
    public void flushCommits() throws IOException {
        this.getBufferedMutator().flush();
    }

    @Override
    public void delete(Delete toDel) throws IOException {
        this.getBufferedMutator().mutate((Mutation)toDel);
        if (this.autoFlush) {
            this.getBufferedMutator().flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.tab.close();
        if (this.mutator != null) {
            this.mutator.close();
        }
    }

    @Override
    public void put(HBasePut put) throws IOException {
        if (put == null) {
            throw new NullPointerException("NULL Put passed");
        }
        if (!(put instanceof HBase10Put)) {
            throw new IllegalArgumentException("Unexpected backed HBasePut type passed:" + put.getClass());
        }
        HBase10Put p10 = (HBase10Put)put;
        this.put(p10.getPut());
    }

    void put(Put toPut) throws IOException {
        this.getBufferedMutator().mutate((Mutation)toPut);
        if (this.autoFlush) {
            this.getBufferedMutator().flush();
        }
    }
}

