/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.vfs.hdfs;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.URLFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class HDFSFileNameParser
extends URLFileNameParser {
    private static final HDFSFileNameParser INSTANCE = new HDFSFileNameParser();

    private HDFSFileNameParser() {
        super(-1);
    }

    public static HDFSFileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        URLFileName fileNameURLFileName = (URLFileName)super.parseUri(context, base, filename);
        return new URLFileName(fileNameURLFileName.getScheme(), this.getHostNameCaseSensitive(filename), fileNameURLFileName.getPort(), fileNameURLFileName.getDefaultPort(), fileNameURLFileName.getUserName(), fileNameURLFileName.getPassword(), fileNameURLFileName.getPath(), fileNameURLFileName.getType(), fileNameURLFileName.getQueryString());
    }

    private String getHostNameCaseSensitive(String fileUri) throws FileSystemException {
        StringBuilder fullNameBuilder = new StringBuilder();
        UriParser.extractScheme((String)fileUri, (StringBuilder)fullNameBuilder);
        if (fullNameBuilder.length() < 2 || fullNameBuilder.charAt(0) != '/' || fullNameBuilder.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)fileUri);
        }
        fullNameBuilder.delete(0, 2);
        this.extractPort(fullNameBuilder, fileUri);
        this.extractUserInfo(fullNameBuilder);
        return this.extractHostName(fullNameBuilder);
    }
}

