/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.repo.RepositoryConnectController;
import org.pentaho.di.ui.repo.RepositoryDialog;
import org.pentaho.di.ui.repository.ILoginCallback;
import org.pentaho.di.ui.spoon.Spoon;

@ExtensionPoint(id="RequestLoginToRepositoryExtensionPoint", extensionPointId="RequestLoginToRepository", description="Handles login requests")
public class RequestLoginToRepositoryExtensionPoint
implements ExtensionPointInterface {
    private static Class<?> PKG = RequestLoginToRepositoryExtensionPoint.class;
    private static final String KETTE_FILE_REPOSITORY_ID = "KettleFileRepository";
    private final ILoginCallback defaultLoginCallback = new DefaultLoginCallback();
    private final RepositoryConnectController repositoryConnectController;

    public RequestLoginToRepositoryExtensionPoint(RepositoryConnectController repositoryConnectController) {
        this.repositoryConnectController = repositoryConnectController;
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        RepositoryMeta repositoryMeta;
        ILoginCallback loginCallback = this.defaultLoginCallback;
        if (object instanceof ILoginCallback) {
            loginCallback = (ILoginCallback)object;
        }
        if ((repositoryMeta = this.findRepositoryToConnect()) != null) {
            if (RequestLoginToRepositoryExtensionPoint.isKettleFileRepository(repositoryMeta)) {
                this.repositoryConnectController.connectToRepository(repositoryMeta);
                loginCallback.onSuccess(this.repositoryConnectController.getConnectedRepositoryInstance());
            } else {
                this.loginToRepository(repositoryMeta, loginCallback);
            }
        } else {
            String errorMessage = BaseMessages.getString(PKG, (String)"Repository.NoDefinedRepositoryToConnect", (String[])new String[0]);
            KettleException exception = new KettleException(errorMessage);
            loginCallback.onError((Throwable)exception);
        }
    }

    void loginToRepository(RepositoryMeta repositoryMeta, ILoginCallback loginCallback) {
        RepositoryDialog dialog = this.getRepositoryDialog();
        boolean result = dialog.openLogin(repositoryMeta);
        if (result) {
            loginCallback.onSuccess(this.repositoryConnectController.getConnectedRepositoryInstance());
        } else {
            loginCallback.onCancel();
        }
    }

    RepositoryDialog getRepositoryDialog() {
        return new RepositoryDialog(this.getSpoon().getShell(), this.repositoryConnectController);
    }

    RepositoryMeta findRepositoryToConnect() {
        RepositoryMeta repositoryMeta = this.repositoryConnectController.getCurrentRepository();
        if (repositoryMeta == null) {
            repositoryMeta = this.repositoryConnectController.getDefaultRepositoryMeta();
        }
        return repositoryMeta;
    }

    static boolean isKettleFileRepository(RepositoryMeta repositoryMeta) {
        return KETTE_FILE_REPOSITORY_ID.equals(repositoryMeta.getId());
    }

    private Spoon getSpoon() {
        return Spoon.getInstance();
    }

    private final class DefaultLoginCallback
    implements ILoginCallback {
        private DefaultLoginCallback() {
        }

        public void onSuccess(Repository repository) {
        }

        public void onCancel() {
        }

        public void onError(Throwable t) {
        }
    }
}

