/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.repo.RepositoryConnectController;
import org.pentaho.di.ui.repo.RepositoryDialog;
import org.pentaho.di.ui.spoon.Spoon;

public class RepositoryConnectMenu {
    private static Class<?> PKG = RepositoryConnectMenu.class;
    private static LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create(RepositoryConnectMenu.class);
    private static final int MAX_REPO_NAME_PIXEL_LENGTH = 230;
    private Spoon spoon;
    private ToolBar toolBar;
    private ToolItem connectButton;
    private ToolItem connectDropdown;
    private RepositoriesMeta repositoriesMeta;
    private final RepositoryConnectController repoConnectController;

    public RepositoryConnectMenu(Spoon spoon, ToolBar toolBar, RepositoryConnectController repoConnectController) {
        this.toolBar = toolBar;
        this.spoon = spoon;
        this.repoConnectController = repoConnectController;
        repoConnectController.addListener(new RepositoryConnectController.RepositoryContollerListener(){

            @Override
            public void update() {
                RepositoryConnectMenu.this.renderAndUpdate();
            }
        });
    }

    public void update() {
        Rectangle rect = this.toolBar.getBounds();
        if (this.connectDropdown != null && !this.connectDropdown.isDisposed()) {
            if (this.spoon.rep != null) {
                StringBuilder connectionLabel = new StringBuilder();
                if (this.spoon.rep.getUserInfo() != null) {
                    connectionLabel.append(this.spoon.rep.getUserInfo().getLogin());
                    connectionLabel.append("  |  ");
                }
                StringBuilder connectionLabelTip = new StringBuilder(connectionLabel.toString());
                if (this.repoConnectController != null && this.repoConnectController.getConnectedRepository() != null) {
                    connectionLabel.append(this.truncateName(this.repoConnectController.getConnectedRepository().getName()));
                    connectionLabelTip.append(this.repoConnectController.getConnectedRepository().getName());
                }
                this.connectDropdown.setText(connectionLabel.toString());
                this.connectDropdown.setToolTipText(connectionLabelTip.toString());
            } else {
                this.connectDropdown.setText(BaseMessages.getString(PKG, (String)"RepositoryConnectMenu.Connect", (String[])new String[0]));
            }
        }
        this.toolBar.pack();
        this.toolBar.setBounds(rect);
    }

    public void render() {
        this.repositoriesMeta = new RepositoriesMeta();
        try {
            if (this.repositoriesMeta.readData() && this.repositoriesMeta.nrRepositories() > 0) {
                this.renderConnectDropdown();
            } else {
                this.renderConnectButton();
            }
        }
        catch (KettleException e) {
            log.logError(BaseMessages.getString((String)"RepositoryConnectMenu.ErrorLoadingRepositories"), (Throwable)e);
        }
    }

    private void renderAndUpdate() {
        if (this.connectDropdown != null && !this.connectDropdown.isDisposed()) {
            this.connectDropdown.dispose();
        }
        if (this.connectButton != null && !this.connectButton.isDisposed()) {
            this.connectButton.dispose();
        }
        this.render();
        this.update();
    }

    private void renderConnectButton() {
        this.connectButton = new ToolItem(this.toolBar, this.toolBar.getItems().length);
        this.connectButton.setText(BaseMessages.getString(PKG, (String)"RepositoryConnectMenu.Connect", (String[])new String[0]));
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new RepositoryDialog(RepositoryConnectMenu.this.spoon.getShell(), RepositoryConnectMenu.this.repoConnectController).openCreation();
                RepositoryConnectMenu.this.renderAndUpdate();
            }
        });
    }

    private void renderConnectDropdown() {
        this.connectDropdown = new ToolItem(this.toolBar, 4, this.toolBar.getItems().length);
        this.connectDropdown.setText(BaseMessages.getString(PKG, (String)"RepositoryConnectMenu.Connect", (String[])new String[0]));
        this.connectDropdown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Menu connectionMenu = new Menu((Control)RepositoryConnectMenu.this.toolBar.getShell());
                if (RepositoryConnectMenu.this.repositoriesMeta != null) {
                    for (int i = 0; i < RepositoryConnectMenu.this.repositoriesMeta.nrRepositories(); ++i) {
                        MenuItem item = new MenuItem(connectionMenu, 32);
                        String truncatedName = RepositoryConnectMenu.this.truncateName(RepositoryConnectMenu.this.repositoriesMeta.getRepository(i).getName());
                        item.setText(truncatedName);
                        item.setData((Object)RepositoryConnectMenu.this.repositoriesMeta.getRepository(i).getName());
                        if (((RepositoryConnectMenu)RepositoryConnectMenu.this).spoon.rep != null && ((RepositoryConnectMenu)RepositoryConnectMenu.this).spoon.rep.getName().equals(RepositoryConnectMenu.this.repositoriesMeta.getRepository(i).getName())) {
                            item.setSelection(true);
                            continue;
                        }
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                String repoName = (String)((MenuItem)selectionEvent.widget).getData();
                                RepositoryMeta repositoryMeta = RepositoryConnectMenu.this.repositoriesMeta.findRepository(repoName);
                                if (repositoryMeta != null) {
                                    try {
                                        RepositoryConnectMenu.this.spoon.promptForSave();
                                    }
                                    catch (KettleException ke) {
                                        log.logError("Error prompting for save", (Throwable)ke);
                                    }
                                    if (repositoryMeta.getId().equals("KettleFileRepository")) {
                                        RepositoryConnectMenu.this.repoConnectController.connectToRepository(repositoryMeta);
                                    } else {
                                        new RepositoryDialog(RepositoryConnectMenu.this.spoon.getShell(), RepositoryConnectMenu.this.repoConnectController).openLogin(repositoryMeta);
                                    }
                                    RepositoryConnectMenu.this.renderAndUpdate();
                                }
                            }
                        });
                    }
                }
                new MenuItem(connectionMenu, 2);
                MenuItem managerItem = new MenuItem(connectionMenu, 0);
                managerItem.setText(BaseMessages.getString((Class)PKG, (String)"RepositoryConnectMenu.RepositoryManager", (String[])new String[0]));
                managerItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        new RepositoryDialog(RepositoryConnectMenu.this.spoon.getShell(), RepositoryConnectMenu.this.repoConnectController).openManager();
                        RepositoryConnectMenu.this.renderAndUpdate();
                    }
                });
                new MenuItem(connectionMenu, 2);
                MenuItem disconnectItem = new MenuItem(connectionMenu, 0);
                disconnectItem.setEnabled(((RepositoryConnectMenu)RepositoryConnectMenu.this).spoon.rep != null);
                disconnectItem.setText(BaseMessages.getString((Class)PKG, (String)"RepositoryConnectMenu.Disconnect", (String[])new String[0]));
                disconnectItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        RepositoryConnectMenu.this.spoon.closeRepository();
                        RepositoryConnectMenu.this.repoConnectController.setConnectedRepository(null);
                        RepositoryConnectMenu.this.renderAndUpdate();
                    }
                });
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y + rect.height));
                connectionMenu.setLocation(pt.x, pt.y);
                connectionMenu.setVisible(true);
            }
        });
    }

    private String truncateName(String name) {
        GC gc = new GC((Drawable)this.toolBar);
        Point size = gc.textExtent(name);
        if (size.x <= 230) {
            gc.dispose();
            return name;
        }
        String originalName = name;
        while (gc.textExtent((String)new StringBuilder().append((String)name).append((String)"...").toString()).x > 230) {
            name = name.substring(0, name.length() - 1);
        }
        gc.dispose();
        name = name + "...";
        return name;
    }
}

