/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MemStoreChunkPool;

@InterfaceAudience.Private
public class MemStoreLAB {
    private AtomicReference<Chunk> curChunk = new AtomicReference();
    private BlockingQueue<Chunk> chunkQueue = new LinkedBlockingQueue<Chunk>();
    static final String CHUNK_SIZE_KEY = "hbase.hregion.memstore.mslab.chunksize";
    static final int CHUNK_SIZE_DEFAULT = 0x200000;
    final int chunkSize;
    static final String MAX_ALLOC_KEY = "hbase.hregion.memstore.mslab.max.allocation";
    static final int MAX_ALLOC_DEFAULT = 262144;
    final int maxAlloc;
    private final MemStoreChunkPool chunkPool;
    private volatile boolean closed = false;
    private AtomicBoolean reclaimed = new AtomicBoolean(false);
    private final AtomicInteger openScannerCount = new AtomicInteger();

    public MemStoreLAB() {
        this(new Configuration());
    }

    private MemStoreLAB(Configuration conf) {
        this(conf, MemStoreChunkPool.getPool(conf));
    }

    public MemStoreLAB(Configuration conf, MemStoreChunkPool pool) {
        this.chunkSize = conf.getInt(CHUNK_SIZE_KEY, 0x200000);
        this.maxAlloc = conf.getInt(MAX_ALLOC_KEY, 262144);
        this.chunkPool = pool;
        Preconditions.checkArgument((this.maxAlloc <= this.chunkSize ? 1 : 0) != 0, (Object)"hbase.hregion.memstore.mslab.max.allocation must be less than hbase.hregion.memstore.mslab.chunksize");
    }

    public Allocation allocateBytes(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"negative size");
        if (size > this.maxAlloc) {
            return null;
        }
        Chunk c;
        int allocOffset;
        while ((allocOffset = (c = this.getOrMakeChunk()).alloc(size)) == -1) {
            this.tryRetireChunk(c);
        }
        return new Allocation(c.data, allocOffset);
    }

    void close() {
        this.closed = true;
        if (this.chunkPool != null && this.openScannerCount.get() == 0 && this.reclaimed.compareAndSet(false, true)) {
            this.chunkPool.putbackChunks(this.chunkQueue);
        }
    }

    void incScannerCount() {
        this.openScannerCount.incrementAndGet();
    }

    void decScannerCount() {
        int count = this.openScannerCount.decrementAndGet();
        if (this.chunkPool != null && count == 0 && this.closed && this.reclaimed.compareAndSet(false, true)) {
            this.chunkPool.putbackChunks(this.chunkQueue);
        }
    }

    private void tryRetireChunk(Chunk c) {
        this.curChunk.compareAndSet(c, null);
    }

    private Chunk getOrMakeChunk() {
        Chunk c;
        while ((c = this.curChunk.get()) == null) {
            Chunk chunk = c = this.chunkPool != null ? this.chunkPool.getChunk() : new Chunk(this.chunkSize);
            if (this.curChunk.compareAndSet(null, c)) {
                c.init();
                this.chunkQueue.add(c);
                return c;
            }
            if (this.chunkPool == null) continue;
            this.chunkPool.putbackChunk(c);
        }
        return c;
    }

    public static class Allocation {
        private final byte[] data;
        private final int offset;

        private Allocation(byte[] data, int off) {
            this.data = data;
            this.offset = off;
        }

        public String toString() {
            return "Allocation(capacity=" + this.data.length + ", off=" + this.offset + ")";
        }

        byte[] getData() {
            return this.data;
        }

        int getOffset() {
            return this.offset;
        }
    }

    static class Chunk {
        private byte[] data;
        private static final int UNINITIALIZED = -1;
        private static final int OOM = -2;
        private AtomicInteger nextFreeOffset = new AtomicInteger(-1);
        private AtomicInteger allocCount = new AtomicInteger();
        private final int size;

        Chunk(int size) {
            this.size = size;
        }

        public void init() {
            assert (this.nextFreeOffset.get() == -1);
            try {
                if (this.data == null) {
                    this.data = new byte[this.size];
                }
            }
            catch (OutOfMemoryError e) {
                boolean failInit = this.nextFreeOffset.compareAndSet(-1, -2);
                assert (failInit);
                throw e;
            }
            boolean initted = this.nextFreeOffset.compareAndSet(-1, 0);
            Preconditions.checkState((boolean)initted, (Object)"Multiple threads tried to init same chunk");
        }

        void reset() {
            if (this.nextFreeOffset.get() != -1) {
                this.nextFreeOffset.set(-1);
                this.allocCount.set(0);
            }
        }

        public int alloc(int size) {
            int oldOffset;
            while (true) {
                if ((oldOffset = this.nextFreeOffset.get()) == -1) {
                    Thread.yield();
                    continue;
                }
                if (oldOffset == -2) {
                    return -1;
                }
                if (oldOffset + size > this.data.length) {
                    return -1;
                }
                if (this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size)) break;
            }
            this.allocCount.incrementAndGet();
            return oldOffset;
        }

        public String toString() {
            return "Chunk@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.length - this.nextFreeOffset.get());
        }
    }
}

