/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.springframework.util.StringUtils;

public class RepositoryFilenameUtils {
    private static final char SEPARATOR = "/".charAt(0);
    private static final Character DEFAULT_ESCAPE_CHAR = Character.valueOf('%');
    private static final String ESCAPE_CHAR_SYSTEM_PROPERTY = "pentaho.repository.client.escapeChar";
    private static Character escapeChar;

    private RepositoryFilenameUtils() {
    }

    public static String normalize(String filename) {
        return FilenameUtils.normalize((String)filename, (boolean)true);
    }

    public static String normalize(String filename, boolean leadingSlash) {
        String normalizedFilename = null;
        if (filename != null) {
            normalizedFilename = RepositoryFilenameUtils.normalize(filename.trim());
            if (leadingSlash && normalizedFilename != null && normalizedFilename.indexOf("/") != 0) {
                normalizedFilename = "/" + normalizedFilename;
            }
        }
        return normalizedFilename;
    }

    public static String normalizeNoEndSeparator(String filename) {
        return FilenameUtils.normalizeNoEndSeparator((String)filename, (boolean)true);
    }

    public static String concat(String basePath, String fullFilenameToAdd) {
        int prefix = 0;
        if (StringUtils.hasLength((String)fullFilenameToAdd)) {
            prefix = RepositoryFilenameUtils.getPrefixLength(fullFilenameToAdd.replace(":", "_"));
        }
        if (prefix < 0) {
            return null;
        }
        if (prefix > 0) {
            return RepositoryFilenameUtils.normalize(fullFilenameToAdd);
        }
        if (basePath == null) {
            return null;
        }
        int len = basePath.length();
        if (len == 0) {
            return RepositoryFilenameUtils.normalize(fullFilenameToAdd);
        }
        char ch = basePath.charAt(len - 1);
        if (SEPARATOR == ch) {
            return RepositoryFilenameUtils.normalize(basePath + fullFilenameToAdd);
        }
        return RepositoryFilenameUtils.normalize(basePath + SEPARATOR + fullFilenameToAdd);
    }

    public static String separatorsToRepository(String path) {
        return FilenameUtils.separatorsToUnix((String)path);
    }

    public static int getPrefixLength(String filename) {
        return FilenameUtils.getPrefixLength((String)filename);
    }

    public static int indexOfLastSeparator(String filename) {
        return FilenameUtils.indexOfLastSeparator((String)filename);
    }

    public static int indexOfExtension(String filename) {
        return FilenameUtils.indexOfExtension((String)filename);
    }

    public static String getPrefix(String filename) {
        return FilenameUtils.getPrefix((String)filename);
    }

    public static String getPath(String filename) {
        return FilenameUtils.getPath((String)filename);
    }

    public static String getPathNoEndSeparator(String filename) {
        return FilenameUtils.getPathNoEndSeparator((String)filename);
    }

    public static String getFullPath(String filename) {
        return FilenameUtils.getFullPath((String)filename);
    }

    public static String getFullPathNoEndSeparator(String filename) {
        return FilenameUtils.getFullPathNoEndSeparator((String)filename);
    }

    public static String getName(String filename) {
        return FilenameUtils.getName((String)filename);
    }

    public static String getBaseName(String filename) {
        return FilenameUtils.getBaseName((String)filename);
    }

    public static String getExtension(String filename) {
        return FilenameUtils.getExtension((String)filename);
    }

    public static String removeExtension(String filename) {
        return FilenameUtils.removeExtension((String)filename);
    }

    public static boolean equals(String filename1, String filename2) {
        return FilenameUtils.equals((String)filename1, (String)filename2, (boolean)false, (IOCase)IOCase.SENSITIVE);
    }

    public static boolean equalsNormalized(String filename1, String filename2) {
        return FilenameUtils.equals((String)filename1, (String)filename2, (boolean)true, (IOCase)IOCase.SENSITIVE);
    }

    public static boolean isExtension(String filename, String extension) {
        return FilenameUtils.isExtension((String)filename, (String)extension);
    }

    public static boolean isExtension(String filename, String[] extensions) {
        return FilenameUtils.isExtension((String)filename, (String[])extensions);
    }

    public static boolean isExtension(String filename, Collection extensions) {
        return FilenameUtils.isExtension((String)filename, (Collection)extensions);
    }

    public static boolean wildcardMatch(String filename, String wildcardMatcher) {
        return FilenameUtils.wildcardMatch((String)filename, (String)wildcardMatcher, (IOCase)IOCase.SENSITIVE);
    }

    public static String escape(String name, List<Character> reservedChars) {
        if (name == null || reservedChars == null) {
            throw new IllegalArgumentException();
        }
        if (reservedChars.contains(escapeChar)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Character> mergedReservedChars = new ArrayList<Character>(reservedChars);
        mergedReservedChars.add(escapeChar);
        StringBuilder buffer = new StringBuilder(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (mergedReservedChars.contains(Character.valueOf(ch))) {
                buffer.append(escapeChar);
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String unescape(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder buffer = new StringBuilder(name.length());
        String str = name;
        int i = str.indexOf(escapeChar.charValue());
        while (i > -1 && i + 2 < str.length()) {
            buffer.append(str.toCharArray(), 0, i);
            int a = Character.digit(str.charAt(i + 1), 16);
            int b = Character.digit(str.charAt(i + 2), 16);
            if (a > -1 && b > -1) {
                buffer.append((char)(a * 16 + b));
                str = str.substring(i + 3);
            } else {
                buffer.append(escapeChar);
                str = str.substring(i + 1);
            }
            i = str.indexOf(escapeChar.charValue());
        }
        buffer.append(str);
        return buffer.toString();
    }

    static {
        String escapeCharStr = System.getProperty(ESCAPE_CHAR_SYSTEM_PROPERTY);
        escapeChar = escapeCharStr != null && escapeCharStr.trim().length() != 1 ? new Character(escapeCharStr.charAt(0)) : DEFAULT_ESCAPE_CHAR;
    }
}

