/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl.handlers.pluginxml;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.pentaho.osgi.platform.plugin.deployer.impl.handlers.PluginXmlFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginXmlLifecycleListenerHandler
extends PluginXmlFileHandler {
    public PluginXmlLifecycleListenerHandler() {
        super("//lifecycle-listener");
    }

    @Override
    protected void handle(String relativePath, List<Node> nodes, PluginMetadata pluginMetadata) throws PluginHandlingException {
        Document blueprint = pluginMetadata.getBlueprint();
        for (Node node : nodes) {
            Map<String, String> attributes = this.getAttributes(node);
            if (attributes.containsKey("ignore")) continue;
            String clazz = attributes.get("class");
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return "http://www.osgi.org/xmlns/blueprint/v1.0.0";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return null;
                }

                public Iterator getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            String expression = "//bp:bean[@class='" + clazz + "']";
            try {
                XPathExpression compiledExpression = xpath.compile(expression);
                NodeList nodeList = (NodeList)compiledExpression.evaluate(blueprint, XPathConstants.NODESET);
                if (nodeList.getLength() > 0) {
                    continue;
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            Element bean = blueprint.createElementNS("http://www.osgi.org/xmlns/blueprint/v1.0.0", "bean");
            bean.setAttribute("class", clazz);
            bean.setAttribute("init-method", "init");
            blueprint.getDocumentElement().appendChild(bean);
        }
    }
}

