/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import de.simplicit.vjdbc.serial.SerialStruct;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

public class SerialArray
implements Array,
Externalizable {
    private static final long serialVersionUID = 3256722892212418873L;
    private int _baseType;
    private String _baseTypeName;
    private Object _array;

    public SerialArray() {
    }

    public SerialArray(int baseType, String typeName, Object[] elements) {
        this._baseType = baseType;
        this._baseTypeName = typeName;
        this._array = elements;
    }

    public SerialArray(String typeName, Object[] elements) {
        if ("array".equalsIgnoreCase(typeName)) {
            this._baseType = 2003;
        } else if ("bigint".equalsIgnoreCase(typeName)) {
            this._baseType = -5;
        } else if ("binary".equalsIgnoreCase(typeName)) {
            this._baseType = -2;
        } else if ("bit".equalsIgnoreCase(typeName)) {
            this._baseType = -7;
        } else if ("blob".equalsIgnoreCase(typeName)) {
            this._baseType = 2004;
        } else if ("boolean".equalsIgnoreCase(typeName)) {
            this._baseType = 16;
        } else if ("char".equalsIgnoreCase(typeName)) {
            this._baseType = 1;
        } else if ("clob".equalsIgnoreCase(typeName)) {
            this._baseType = 2005;
        } else if ("datalink".equalsIgnoreCase(typeName)) {
            this._baseType = 70;
        } else if ("date".equalsIgnoreCase(typeName)) {
            this._baseType = 91;
        } else if ("decimal".equalsIgnoreCase(typeName)) {
            this._baseType = 3;
        } else if ("distinct".equalsIgnoreCase(typeName)) {
            this._baseType = 2001;
        } else if ("double".equalsIgnoreCase(typeName)) {
            this._baseType = 8;
        } else if ("float".equalsIgnoreCase(typeName)) {
            this._baseType = 6;
        } else if ("integer".equalsIgnoreCase(typeName)) {
            this._baseType = 4;
        } else if ("java_object".equalsIgnoreCase(typeName)) {
            this._baseType = 2000;
        } else if ("longnvarchar".equalsIgnoreCase(typeName)) {
            this._baseType = -16;
        } else if ("longvarbinary".equalsIgnoreCase(typeName)) {
            this._baseType = -4;
        } else if ("longvarchar".equalsIgnoreCase(typeName)) {
            this._baseType = -1;
        } else if ("nchar".equalsIgnoreCase(typeName)) {
            this._baseType = -15;
        } else if ("nclob".equalsIgnoreCase(typeName)) {
            this._baseType = 2011;
        } else if ("null".equalsIgnoreCase(typeName)) {
            this._baseType = 0;
        } else if ("numeric".equalsIgnoreCase(typeName)) {
            this._baseType = 2;
        } else if ("nvarchar".equalsIgnoreCase(typeName)) {
            this._baseType = -9;
        } else if ("other".equalsIgnoreCase(typeName)) {
            this._baseType = 1111;
        } else if ("real".equalsIgnoreCase(typeName)) {
            this._baseType = 7;
        } else if ("ref".equalsIgnoreCase(typeName)) {
            this._baseType = 2006;
        } else if ("rowid".equalsIgnoreCase(typeName)) {
            this._baseType = -8;
        } else if ("smallint".equalsIgnoreCase(typeName)) {
            this._baseType = 5;
        } else if ("sqlxml".equalsIgnoreCase(typeName)) {
            this._baseType = 2009;
        } else if ("struct".equalsIgnoreCase(typeName)) {
            this._baseType = 2002;
        } else if ("time".equalsIgnoreCase(typeName)) {
            this._baseType = 92;
        } else if ("timestamp".equalsIgnoreCase(typeName)) {
            this._baseType = 93;
        } else if ("tinyint".equalsIgnoreCase(typeName)) {
            this._baseType = -6;
        } else if ("varbinary".equalsIgnoreCase(typeName)) {
            this._baseType = -3;
        } else if ("varchar".equalsIgnoreCase(typeName)) {
            this._baseType = 12;
        }
        this._baseTypeName = typeName;
        this._array = elements;
    }

    public SerialArray(Array arr) throws SQLException {
        this._baseType = arr.getBaseType();
        this._baseTypeName = arr.getBaseTypeName();
        this._array = arr.getArray();
        if (this._baseType == 2002) {
            Object[] orig = (Object[])this._array;
            SerialStruct[] cpy = new SerialStruct[orig.length];
            for (int i = 0; i < orig.length; ++i) {
                cpy[i] = new SerialStruct((Struct)orig[i]);
            }
            this._array = cpy;
        }
        arr.free();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._baseType);
        out.writeObject(this._baseTypeName);
        out.writeObject(this._array);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._baseType = in.readInt();
        this._baseTypeName = (String)in.readObject();
        this._array = in.readObject();
    }

    @Override
    public void free() throws SQLException {
        this._array = null;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this._baseTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this._baseType;
    }

    @Override
    public Object getArray() throws SQLException {
        return this._array;
    }

    public Object getArray(Map map) throws SQLException {
        throw new UnsupportedOperationException("getArray(Map) not supported");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        throw new UnsupportedOperationException("getArray(index, count) not supported");
    }

    public Object getArray(long index, int count, Map map) throws SQLException {
        throw new UnsupportedOperationException("getArray(index, count, Map) not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException("getResultSet() not supported");
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        throw new UnsupportedOperationException("getResultSet(Map) not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new UnsupportedOperationException("getResultSet(index, count) not supported");
    }

    public ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        throw new UnsupportedOperationException("getResultSet(index, count, Map) not supported");
    }
}

