/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.net.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslogWriter;
import org.productivity.java.syslog4j.impl.net.AbstractNetSyslog;

public class UDPNetSyslog
extends AbstractNetSyslog {
    private static final long serialVersionUID = 5259485504549037999L;
    protected DatagramSocket socket = null;

    public void initialize() throws SyslogRuntimeException {
        super.initialize();
        this.createDatagramSocket(true);
    }

    protected synchronized void createDatagramSocket(boolean bl) {
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            if (bl) {
                if (this.syslogConfig.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(socketException);
                }
            }
            throw new SyslogRuntimeException(socketException);
        }
        if (this.socket == null) {
            throw new SyslogRuntimeException("Cannot seem to get a Datagram socket");
        }
    }

    protected void write(byte[] byArray) throws SyslogRuntimeException {
        if (this.socket == null) {
            this.createDatagramSocket(false);
        }
        InetAddress inetAddress = this.getHostAddress();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, this.syslogConfig.getPort());
        int n = 0;
        while (n != -1 && n < this.netSyslogConfig.getWriteRetries() + 1) {
            try {
                this.socket.send(datagramPacket);
                n = -1;
            }
            catch (IOException iOException) {
                if (n != this.netSyslogConfig.getWriteRetries() + 1) continue;
                throw new SyslogRuntimeException(iOException);
            }
        }
    }

    public void flush() throws SyslogRuntimeException {
        this.shutdown();
        this.createDatagramSocket(true);
    }

    public void shutdown() throws SyslogRuntimeException {
        this.socket.close();
        this.socket = null;
    }

    public AbstractSyslogWriter getWriter() {
        return null;
    }

    public void returnWriter(AbstractSyslogWriter abstractSyslogWriter) {
    }
}

