/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.pdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.repository.usersettings.pojo.UserSetting;

public class AgileBIUserSettingService
implements IUserSettingService {
    Map<String, String> globalUserSettings = new HashMap<String, String>();
    Map<String, String> userSettings = new HashMap<String, String>();

    public void init(IPentahoSession arg0) {
    }

    public void deleteUserSettings() {
        this.userSettings.clear();
    }

    public IUserSetting getGlobalUserSetting(String settingName, String defaultValue) {
        return this.getSetting(this.globalUserSettings, settingName, defaultValue);
    }

    public List<IUserSetting> getGlobalUserSettings() {
        return this.getSettingsList(this.globalUserSettings);
    }

    public IUserSetting getUserSetting(String settingName, String defaultValue) {
        return this.getSetting(this.userSettings, settingName, defaultValue);
    }

    public List<IUserSetting> getUserSettings() {
        return this.getSettingsList(this.userSettings);
    }

    public void setGlobalUserSetting(String settingName, String settingValue) {
        this.setSettingValue(this.globalUserSettings, settingName, settingValue);
    }

    public void setUserSetting(String settingName, String settingValue) {
        this.setSettingValue(this.userSettings, settingName, settingValue);
    }

    private IUserSetting getSetting(Map<String, String> settingsMap, String settingName, String defaultValue) {
        String value = settingsMap.get(settingName);
        UserSetting setting = new UserSetting();
        setting.setSettingName(settingName);
        setting.setSettingValue(value != null ? value : defaultValue);
        return setting;
    }

    private List<IUserSetting> getSettingsList(Map<String, String> settingsMap) {
        ArrayList<IUserSetting> settingsList = new ArrayList<IUserSetting>();
        if (settingsMap != null) {
            for (Map.Entry<String, String> me : settingsMap.entrySet()) {
                UserSetting userSetting = new UserSetting();
                userSetting.setSettingName(me.getKey());
                userSetting.setSettingValue(me.getValue());
                settingsList.add((IUserSetting)userSetting);
            }
        }
        return settingsList;
    }

    private void setSettingValue(Map<String, String> settingsMap, String settingName, String settingValue) {
        settingsMap.put(settingName, settingValue);
    }
}

