/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.pentaho.di.core.util.ExecutorUtil;
import org.pentaho.di.repository.pur.ActiveCacheCallable;
import org.pentaho.di.repository.pur.ActiveCacheLoader;
import org.pentaho.di.repository.pur.ActiveCacheResult;

public class ActiveCache<Key, Value> {
    private final Map<Key, ActiveCacheResult<Value>> valueMap;
    private final Map<Key, Future<ActiveCacheResult<Value>>> loadingMap;
    private final ActiveCacheLoader<Key, Value> loader;
    private final long timeout;
    private final ExecutorServiceGetter executorServiceGetter;

    public ActiveCache(ActiveCacheLoader<Key, Value> loader, long timeout) {
        this(loader, timeout, new ExecutorServiceGetter(){

            @Override
            public ExecutorService getExecutor() {
                return ExecutorUtil.getExecutor();
            }
        });
    }

    public ActiveCache(ActiveCacheLoader<Key, Value> loader, long timeout, ExecutorServiceGetter executorServiceGetter) {
        this(loader, new HashMap(), new HashMap(), timeout, executorServiceGetter);
    }

    public ActiveCache(ActiveCacheLoader<Key, Value> loader, Map<Key, ActiveCacheResult<Value>> valueMap, Map<Key, Future<ActiveCacheResult<Value>>> loadingMap, long timeout, ExecutorServiceGetter executorServiceGetter) {
        this.valueMap = valueMap;
        this.loadingMap = loadingMap;
        this.loader = loader;
        this.timeout = timeout;
        this.executorServiceGetter = executorServiceGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value get(Key key) throws Exception {
        Exception exception;
        ActiveCacheResult<Value> result = null;
        Future<ActiveCacheResult<Object>> futureResult = null;
        ActiveCache activeCache = this;
        synchronized (activeCache) {
            result = this.valueMap.get(key);
            boolean shouldReload = false;
            long time = System.currentTimeMillis();
            if (result == null || result.getTimeLoaded() + this.timeout < time) {
                result = null;
                shouldReload = true;
            } else if ((double)result.getTimeLoaded() + (double)this.timeout / 2.0 < (double)time) {
                shouldReload = true;
            }
            if (shouldReload && (futureResult = this.loadingMap.get(key)) == null) {
                futureResult = this.executorServiceGetter.getExecutor().submit(new ActiveCacheCallable<Key, Value>(this, this.valueMap, this.loadingMap, key, this.loader));
                this.loadingMap.put(key, futureResult);
            }
        }
        if (result == null) {
            result = futureResult.get();
        }
        if ((exception = result.getException()) != null) {
            throw exception;
        }
        return result.getValue();
    }

    public static interface ExecutorServiceGetter {
        public ExecutorService getExecutor();
    }
}

