/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;

@Explain(displayName="Mux Operator")
public class MuxDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private List<List<ExprNodeDesc>> parentToKeyCols;
    private List<List<ExprNodeDesc>> parentToValueCols;
    private List<List<String>> parentToOutputKeyColumnNames;
    private List<List<String>> parentToOutputValueColumnNames;
    private List<Integer> parentToTag;
    private Map<Integer, Integer> newParentIndexToOldParentIndex;

    public MuxDesc() {
    }

    public MuxDesc(List<Operator<? extends OperatorDesc>> ops) {
        int numParents = ops.size();
        this.parentToKeyCols = new ArrayList<List<ExprNodeDesc>>(numParents);
        this.parentToOutputKeyColumnNames = new ArrayList<List<String>>(numParents);
        this.parentToValueCols = new ArrayList<List<ExprNodeDesc>>(numParents);
        this.parentToOutputValueColumnNames = new ArrayList<List<String>>(numParents);
        this.parentToTag = new ArrayList<Integer>(numParents);
        for (Operator<? extends OperatorDesc> op : ops) {
            if (op != null && op instanceof ReduceSinkOperator) {
                ReduceSinkOperator rsop = (ReduceSinkOperator)op;
                ArrayList<ExprNodeDesc> keyCols = ((ReduceSinkDesc)rsop.getConf()).getKeyCols();
                ArrayList<ExprNodeDesc> valueCols = ((ReduceSinkDesc)rsop.getConf()).getValueCols();
                ArrayList<String> outputKeyColumnNames = ((ReduceSinkDesc)rsop.getConf()).getOutputKeyColumnNames();
                ArrayList<String> outputValueColumnNames = ((ReduceSinkDesc)rsop.getConf()).getOutputValueColumnNames();
                int tag = ((ReduceSinkDesc)rsop.getConf()).getTag();
                this.parentToKeyCols.add(keyCols);
                this.parentToValueCols.add(valueCols);
                this.parentToOutputKeyColumnNames.add(outputKeyColumnNames);
                this.parentToOutputValueColumnNames.add(outputValueColumnNames);
                this.parentToTag.add(tag);
                continue;
            }
            this.parentToKeyCols.add(null);
            this.parentToValueCols.add(null);
            this.parentToOutputKeyColumnNames.add(null);
            this.parentToOutputValueColumnNames.add(null);
            this.parentToTag.add(null);
        }
    }

    public List<List<ExprNodeDesc>> getParentToKeyCols() {
        return this.parentToKeyCols;
    }

    public void setParentToKeyCols(List<List<ExprNodeDesc>> parentToKeyCols) {
        this.parentToKeyCols = parentToKeyCols;
    }

    public List<List<ExprNodeDesc>> getParentToValueCols() {
        return this.parentToValueCols;
    }

    public void setParentToValueCols(List<List<ExprNodeDesc>> parentToValueCols) {
        this.parentToValueCols = parentToValueCols;
    }

    public List<List<String>> getParentToOutputKeyColumnNames() {
        return this.parentToOutputKeyColumnNames;
    }

    public void setParentToOutputKeyColumnNames(List<List<String>> parentToOutputKeyColumnNames) {
        this.parentToOutputKeyColumnNames = parentToOutputKeyColumnNames;
    }

    public List<List<String>> getParentToOutputValueColumnNames() {
        return this.parentToOutputValueColumnNames;
    }

    public void setParentToOutputValueColumnNames(List<List<String>> parentToOutputValueColumnNames) {
        this.parentToOutputValueColumnNames = parentToOutputValueColumnNames;
    }

    public List<Integer> getParentToTag() {
        return this.parentToTag;
    }

    public void setParentToTag(List<Integer> parentToTag) {
        this.parentToTag = parentToTag;
    }

    public Map<Integer, Integer> getNewParentIndexToOldParentIndex() {
        return this.newParentIndexToOldParentIndex;
    }

    public void setNewParentIndexToOldParentIndex(Map<Integer, Integer> newParentIndexToOldParentIndex) {
        this.newParentIndexToOldParentIndex = newParentIndexToOldParentIndex;
    }
}

