/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.ssh;

import com.trilead.ssh2.Connection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ssh.SSHData;
import org.pentaho.di.trans.steps.ssh.SSHMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SSHDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SSHMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wGeneralTab;
    private CTabItem wSettingsTab;
    private Composite wGeneralComp;
    private Composite wSettingsComp;
    private FormData fdGeneralComp;
    private FormData fdSettingsComp;
    private Label wlCommandField;
    private CCombo wCommandField;
    private FormData fdlCommandField;
    private FormData fdCommandField;
    private Group wSettingsGroup;
    private FormData fdSettingsGroup;
    private Group wOutput;
    private FormData fdOutput;
    private FormData fdTimeOut;
    private LabelTextVar wTimeOut;
    private SSHMeta input;
    private Group wCommands;
    private FormData fdLogSettings;
    private Label wldynamicCommand;
    private FormData fdlynamicBase;
    private Button wdynamicCommand;
    private FormData fdynamicCommand;
    private FormData fdPort;
    private LabelTextVar wPort;
    private LabelTextVar wUserName;
    private FormData fdUserName;
    private LabelTextVar wPassword;
    private FormData fdPassword;
    private Label wlUseKey;
    private FormData fdlUseKey;
    private Button wUseKey;
    private FormData fdUseKey;
    private LabelTextVar wPrivateKey;
    private FormData fdPrivateKey;
    private LabelTextVar wPassphrase;
    private FormData fdPassphrase;
    private LabelTextVar wResultOutFieldName;
    private LabelTextVar wResultErrFieldName;
    private FormData fdResultOutFieldName;
    private FormData fdResultErrFieldName;
    private Label wlCommand;
    private StyledTextComp wCommand;
    private FormData fdlCommand;
    private FormData fdCommand;
    private Button wTest;
    private FormData fdTest;
    private Listener lsTest;
    private LabelTextVar wProxyHost;
    private FormData fdProxyHost;
    private LabelTextVar wProxyPort;
    private FormData fdProxyPort;
    private LabelTextVar wProxyUsername;
    private FormData fdProxyUsername;
    private LabelTextVar wProxyPassword;
    private FormData fdProxyPassword;
    private LabelTextVar wServerName;
    private FormData fdServerName;
    private Button wbFilename;
    private FormData fdbFilename;
    private boolean gotPreviousFields = false;

    public SSHDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (SSHMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SSHDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SSHDialog.General.Tab", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)fileLayout);
        this.wSettingsGroup = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wSettingsGroup);
        this.wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"SSHDialog.wSettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        this.wSettingsGroup.setLayout((Layout)settingGroupLayout);
        this.wServerName = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Server.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        this.fdServerName = new FormData();
        this.fdServerName.left = new FormAttachment(0, 0);
        this.fdServerName.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData(this.fdServerName);
        this.wPort = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Port.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        this.fdPort = new FormData();
        this.fdPort.left = new FormAttachment(0, 0);
        this.fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData(this.fdPort);
        this.wTimeOut = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.TimeOut.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.TimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        this.fdTimeOut = new FormData();
        this.fdTimeOut.left = new FormAttachment(0, 0);
        this.fdTimeOut.top = new FormAttachment((Control)this.wPort, margin);
        this.fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData(this.fdTimeOut);
        this.wUserName = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.UserName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.UserName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        this.fdUserName = new FormData();
        this.fdUserName.left = new FormAttachment(0, 0);
        this.fdUserName.top = new FormAttachment((Control)this.wTimeOut, margin);
        this.fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData(this.fdUserName);
        this.wPassword = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Password.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Password.Tooltip", (String[])new String[0]), true);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        this.fdPassword = new FormData();
        this.fdPassword.left = new FormAttachment(0, 0);
        this.fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        this.fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData(this.fdPassword);
        this.wlUseKey = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlUseKey.setText(BaseMessages.getString(PKG, (String)"SSHDialog.UseKey.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUseKey);
        this.fdlUseKey = new FormData();
        this.fdlUseKey.left = new FormAttachment(0, 0);
        this.fdlUseKey.top = new FormAttachment((Control)this.wPassword, margin);
        this.fdlUseKey.right = new FormAttachment(middle, -margin);
        this.wlUseKey.setLayoutData((Object)this.fdlUseKey);
        this.wUseKey = new Button((Composite)this.wSettingsGroup, 32);
        this.props.setLook((Control)this.wUseKey);
        this.wUseKey.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.UseKey.Tooltip", (String[])new String[0]));
        this.fdUseKey = new FormData();
        this.fdUseKey.left = new FormAttachment(middle, margin);
        this.fdUseKey.top = new FormAttachment((Control)this.wPassword, margin);
        this.fdUseKey.right = new FormAttachment(100, 0);
        this.wUseKey.setLayoutData((Object)this.fdUseKey);
        this.wUseKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHDialog.this.input.setChanged();
                SSHDialog.this.activateKey();
            }
        });
        this.wbFilename = new Button((Composite)this.wSettingsGroup, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, -margin);
        this.fdbFilename.top = new FormAttachment((Control)this.wUseKey, margin);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SSHDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.pem", "*"});
                if (SSHDialog.this.wPrivateKey.getText() != null) {
                    dialog.setFileName(SSHDialog.this.transMeta.environmentSubstitute(SSHDialog.this.wPrivateKey.getText()));
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.PEMFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    SSHDialog.this.wPrivateKey.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
                }
            }
        });
        this.wPrivateKey = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.PrivateKey.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.PrivateKey.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPassword);
        this.wPrivateKey.addModifyListener(lsMod);
        this.fdPrivateKey = new FormData();
        this.fdPrivateKey.left = new FormAttachment(0, 5 * margin);
        this.fdPrivateKey.top = new FormAttachment((Control)this.wUseKey, margin);
        this.fdPrivateKey.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wPrivateKey.setLayoutData(this.fdPrivateKey);
        this.wPassphrase = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Passphrase.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Passphrase.Tooltip", (String[])new String[0]), true);
        this.props.setLook((Control)this.wPassphrase);
        this.wPassphrase.addModifyListener(lsMod);
        this.fdPassphrase = new FormData();
        this.fdPassphrase.left = new FormAttachment(0, 0);
        this.fdPassphrase.top = new FormAttachment((Control)this.wbFilename, margin);
        this.fdPassphrase.right = new FormAttachment(100, 0);
        this.wPassphrase.setLayoutData(this.fdPassphrase);
        this.wProxyHost = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        this.fdProxyHost = new FormData();
        this.fdProxyHost.left = new FormAttachment(0, 0);
        this.fdProxyHost.top = new FormAttachment((Control)this.wPassphrase, 2 * margin);
        this.fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData(this.fdProxyHost);
        this.wProxyPort = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        this.fdProxyPort = new FormData();
        this.fdProxyPort.left = new FormAttachment(0, 0);
        this.fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        this.fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData(this.fdProxyPort);
        this.wProxyUsername = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyUsername.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        this.fdProxyUsername = new FormData();
        this.fdProxyUsername.left = new FormAttachment(0, 0);
        this.fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        this.fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData(this.fdProxyUsername);
        this.wProxyPassword = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPassword.Tooltip", (String[])new String[0]), true);
        this.props.setLook((Control)this.wProxyUsername);
        this.wProxyPassword.addModifyListener(lsMod);
        this.fdProxyPassword = new FormData();
        this.fdProxyPassword.left = new FormAttachment(0, 0);
        this.fdProxyPassword.top = new FormAttachment((Control)this.wProxyUsername, margin);
        this.fdProxyPassword.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData(this.fdProxyPassword);
        this.wTest = new Button((Composite)this.wSettingsGroup, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"SSHDialog.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTest);
        this.fdTest = new FormData();
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.TestConnection.Tooltip", (String[])new String[0]));
        this.fdTest.top = new FormAttachment((Control)this.wProxyPassword, 2 * margin);
        this.fdTest.right = new FormAttachment(100, 0);
        this.wTest.setLayoutData((Object)this.fdTest);
        this.fdSettingsGroup = new FormData();
        this.fdSettingsGroup.left = new FormAttachment(0, margin);
        this.fdSettingsGroup.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdSettingsGroup.right = new FormAttachment(100, -margin);
        this.wSettingsGroup.setLayoutData((Object)this.fdSettingsGroup);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.wSettingsTab = new CTabItem(this.wTabFolder, 0);
        this.wSettingsTab.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Settings.Tab", (String[])new String[0]));
        FormLayout SettingsLayout = new FormLayout();
        SettingsLayout.marginWidth = 3;
        SettingsLayout.marginHeight = 3;
        this.wSettingsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wSettingsComp);
        this.wSettingsComp.setLayout((Layout)SettingsLayout);
        this.wOutput = new Group(this.wSettingsComp, 32);
        this.props.setLook((Control)this.wOutput);
        this.wOutput.setText(BaseMessages.getString(PKG, (String)"SSHDialog.wOutput.Label", (String[])new String[0]));
        FormLayout outputGroupLayout = new FormLayout();
        outputGroupLayout.marginWidth = 10;
        outputGroupLayout.marginHeight = 10;
        this.wOutput.setLayout((Layout)outputGroupLayout);
        this.wResultOutFieldName = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wOutput, BaseMessages.getString(PKG, (String)"SSHDialog.ResultOutFieldName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ResultOutFieldName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wResultOutFieldName);
        this.wResultOutFieldName.addModifyListener(lsMod);
        this.fdResultOutFieldName = new FormData();
        this.fdResultOutFieldName.left = new FormAttachment(0, 0);
        this.fdResultOutFieldName.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdResultOutFieldName.right = new FormAttachment(100, 0);
        this.wResultOutFieldName.setLayoutData(this.fdResultOutFieldName);
        this.wResultErrFieldName = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wOutput, BaseMessages.getString(PKG, (String)"SSHDialog.ResultErrFieldName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ResultErrFieldName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wResultErrFieldName);
        this.wResultErrFieldName.addModifyListener(lsMod);
        this.fdResultErrFieldName = new FormData();
        this.fdResultErrFieldName.left = new FormAttachment(0, 0);
        this.fdResultErrFieldName.top = new FormAttachment((Control)this.wResultOutFieldName, margin);
        this.fdResultErrFieldName.right = new FormAttachment(100, 0);
        this.wResultErrFieldName.setLayoutData(this.fdResultErrFieldName);
        this.fdOutput = new FormData();
        this.fdOutput.left = new FormAttachment(0, margin);
        this.fdOutput.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdOutput.right = new FormAttachment(100, -margin);
        this.wOutput.setLayoutData((Object)this.fdOutput);
        this.wCommands = new Group(this.wSettingsComp, 32);
        this.props.setLook((Control)this.wCommands);
        this.wCommands.setText(BaseMessages.getString(PKG, (String)"SSHDialog.LogSettings.Group.Label", (String[])new String[0]));
        FormLayout LogSettingsgroupLayout = new FormLayout();
        LogSettingsgroupLayout.marginWidth = 10;
        LogSettingsgroupLayout.marginHeight = 10;
        this.wCommands.setLayout((Layout)LogSettingsgroupLayout);
        this.wldynamicCommand = new Label((Composite)this.wCommands, 131072);
        this.wldynamicCommand.setText(BaseMessages.getString(PKG, (String)"SSHDialog.dynamicCommand.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wldynamicCommand);
        this.fdlynamicBase = new FormData();
        this.fdlynamicBase.left = new FormAttachment(0, margin);
        this.fdlynamicBase.top = new FormAttachment((Control)this.wOutput, margin);
        this.fdlynamicBase.right = new FormAttachment(middle, -margin);
        this.wldynamicCommand.setLayoutData((Object)this.fdlynamicBase);
        this.wdynamicCommand = new Button((Composite)this.wCommands, 32);
        this.props.setLook((Control)this.wdynamicCommand);
        this.wdynamicCommand.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.dynamicCommand.Tooltip", (String[])new String[0]));
        this.fdynamicCommand = new FormData();
        this.fdynamicCommand.left = new FormAttachment(middle, margin);
        this.fdynamicCommand.top = new FormAttachment((Control)this.wOutput, margin);
        this.wdynamicCommand.setLayoutData((Object)this.fdynamicCommand);
        SelectionAdapter ldynamicCommand = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SSHDialog.this.activateDynamicCommand();
                SSHDialog.this.input.setChanged();
            }
        };
        this.wdynamicCommand.addSelectionListener((SelectionListener)ldynamicCommand);
        this.wlCommandField = new Label((Composite)this.wCommands, 131072);
        this.wlCommandField.setText(BaseMessages.getString(PKG, (String)"SSHDialog.MessageNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommandField);
        this.fdlCommandField = new FormData();
        this.fdlCommandField.left = new FormAttachment(0, margin);
        this.fdlCommandField.right = new FormAttachment(middle, -margin);
        this.fdlCommandField.top = new FormAttachment((Control)this.wdynamicCommand, margin);
        this.wlCommandField.setLayoutData((Object)this.fdlCommandField);
        this.wCommandField = new CCombo((Composite)this.wCommands, 2056);
        this.props.setLook((Control)this.wCommandField);
        this.wCommandField.setEditable(true);
        this.wCommandField.addModifyListener(lsMod);
        this.fdCommandField = new FormData();
        this.fdCommandField.left = new FormAttachment(middle, margin);
        this.fdCommandField.top = new FormAttachment((Control)this.wdynamicCommand, margin);
        this.fdCommandField.right = new FormAttachment(100, 0);
        this.wCommandField.setLayoutData((Object)this.fdCommandField);
        this.wCommandField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                SSHDialog.this.get();
            }
        });
        this.wlCommand = new Label((Composite)this.wCommands, 131072);
        this.wlCommand.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Command.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommand);
        this.fdlCommand = new FormData();
        this.fdlCommand.left = new FormAttachment(0, margin);
        this.fdlCommand.top = new FormAttachment((Control)this.wCommandField, margin);
        this.fdlCommand.right = new FormAttachment(middle, -2 * margin);
        this.wlCommand.setLayoutData((Object)this.fdlCommand);
        this.wCommand = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.wCommands, 19202, "");
        this.wCommand.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.Command.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCommand);
        this.wCommand.addModifyListener(lsMod);
        this.fdCommand = new FormData();
        this.fdCommand.left = new FormAttachment(middle, margin);
        this.fdCommand.top = new FormAttachment((Control)this.wCommandField, margin);
        this.fdCommand.right = new FormAttachment(100, -2 * margin);
        this.fdCommand.bottom = new FormAttachment(100, -margin);
        this.wCommand.setLayoutData(this.fdCommand);
        this.fdLogSettings = new FormData();
        this.fdLogSettings.left = new FormAttachment(0, margin);
        this.fdLogSettings.top = new FormAttachment((Control)this.wOutput, margin);
        this.fdLogSettings.right = new FormAttachment(100, -margin);
        this.fdLogSettings.bottom = new FormAttachment(100, -margin);
        this.wCommands.setLayoutData((Object)this.fdLogSettings);
        this.fdSettingsComp = new FormData();
        this.fdSettingsComp.left = new FormAttachment(0, 0);
        this.fdSettingsComp.top = new FormAttachment(0, 0);
        this.fdSettingsComp.right = new FormAttachment(100, 0);
        this.fdSettingsComp.bottom = new FormAttachment(100, 0);
        this.wSettingsComp.setLayoutData((Object)this.fdSettingsComp);
        this.wSettingsComp.layout();
        this.wSettingsTab.setControl((Control)this.wSettingsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Button.PreviewRows", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SSHDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                SSHDialog.this.preview();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SSHDialog.this.cancel();
            }
        };
        this.lsTest = new Listener(){

            public void handleEvent(Event e) {
                SSHDialog.this.test();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.wTest.addListener(13, this.lsTest);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SSHDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SSHDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.activateKey();
        this.activateDynamicCommand();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wdynamicCommand.setSelection(this.input.isDynamicCommand());
        if (this.input.getCommand() != null) {
            this.wCommand.setText(this.input.getCommand());
        }
        if (this.input.getcommandfieldname() != null) {
            this.wCommandField.setText(this.input.getcommandfieldname());
        }
        if (this.input.getServerName() != null) {
            this.wServerName.setText(this.input.getServerName());
        }
        if (this.input.getPort() != null) {
            this.wPort.setText(this.input.getPort());
        }
        if (this.input.getuserName() != null) {
            this.wUserName.setText(this.input.getuserName());
        }
        if (this.input.getpassword() != null) {
            this.wPassword.setText(this.input.getpassword());
        }
        this.wUseKey.setSelection(this.input.isusePrivateKey());
        if (this.input.getKeyFileName() != null) {
            this.wPrivateKey.setText(this.input.getKeyFileName());
        }
        if (this.input.getPassphrase() != null) {
            this.wPassphrase.setText(this.input.getPassphrase());
        }
        if (this.input.getStdOutFieldName() != null) {
            this.wResultOutFieldName.setText(this.input.getStdOutFieldName());
        }
        if (this.input.getStdErrFieldName() != null) {
            this.wResultErrFieldName.setText(this.input.getStdErrFieldName());
        }
        this.wTimeOut.setText(Const.NVL((String)this.input.getTimeOut(), (String)"0"));
        if (this.input.getProxyHost() != null) {
            this.wProxyHost.setText(this.input.getProxyHost());
        }
        if (this.input.getProxyPort() != null) {
            this.wProxyPort.setText(this.input.getProxyPort());
        }
        if (this.input.getProxyUsername() != null) {
            this.wProxyUsername.setText(this.input.getProxyUsername());
        }
        if (this.input.getProxyPassword() != null) {
            this.wProxyPassword.setText(this.input.getProxyPassword());
        }
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(SSHMeta in) throws KettleException {
        this.stepname = this.wStepname.getText();
        in.setDynamicCommand(this.wdynamicCommand.getSelection());
        in.setCommand(this.wCommand.getText());
        in.setcommandfieldname(this.wCommandField.getText());
        in.setServerName(this.wServerName.getText());
        in.setPort(this.wPort.getText());
        in.setuserName(this.wUserName.getText());
        in.setpassword(this.wPassword.getText());
        in.usePrivateKey(this.wUseKey.getSelection());
        in.setKeyFileName(this.wPrivateKey.getText());
        in.setPassphrase(this.wPassphrase.getText());
        in.setstdOutFieldName(this.wResultOutFieldName.getText());
        in.setStdErrFieldName(this.wResultErrFieldName.getText());
        in.setTimeOut(this.wTimeOut.getText());
        in.setProxyHost(this.wProxyHost.getText());
        in.setProxyPort(this.wProxyPort.getText());
        in.setProxyUsername(this.wProxyUsername.getText());
        in.setProxyPassword(this.wProxyPassword.getText());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, "Error", "Error while previewing data", (Exception)((Object)e));
        }
        this.dispose();
    }

    private void activateKey() {
        this.wPrivateKey.setEnabled(this.wUseKey.getSelection());
        this.wPassphrase.setEnabled(this.wUseKey.getSelection());
    }

    private void activateDynamicCommand() {
        this.wlCommand.setEnabled(!this.wdynamicCommand.getSelection());
        this.wCommand.setEnabled(!this.wdynamicCommand.getSelection());
        this.wlCommandField.setEnabled(this.wdynamicCommand.getSelection());
        this.wCommandField.setEnabled(this.wdynamicCommand.getSelection());
        this.wPreview.setEnabled(!this.wdynamicCommand.getSelection());
    }

    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String source = this.wCommandField.getText();
                this.wCommandField.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wCommandField.setItems(r.getFieldNames());
                    if (source != null) {
                        this.wCommandField.setText(source);
                    }
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SSHDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        MessageBox mb;
        boolean testOK = false;
        String errMsg = null;
        String servername = this.transMeta.environmentSubstitute(this.wServerName.getText());
        int nrPort = Const.toInt((String)this.transMeta.environmentSubstitute(this.wPort.getText()), (int)22);
        String username = this.transMeta.environmentSubstitute(this.wUserName.getText());
        String password = this.transMeta.environmentSubstitute(this.wPassword.getText());
        String keyFilename = this.transMeta.environmentSubstitute(this.wPrivateKey.getText());
        String passphrase = this.transMeta.environmentSubstitute(this.wPassphrase.getText());
        int timeOut = Const.toInt((String)this.transMeta.environmentSubstitute(this.wTimeOut.getText()), (int)0);
        String proxyhost = this.transMeta.environmentSubstitute(this.wProxyHost.getText());
        int proxyport = Const.toInt((String)this.transMeta.environmentSubstitute(this.wProxyPort.getText()), (int)0);
        String proxyusername = this.transMeta.environmentSubstitute(this.wProxyUsername.getText());
        String proxypassword = this.transMeta.environmentSubstitute(this.wProxyPassword.getText());
        Connection conn = null;
        try {
            conn = SSHData.OpenConnection((String)servername, (int)nrPort, (String)username, (String)password, (boolean)this.wUseKey.getSelection(), (String)keyFilename, (String)passphrase, (int)timeOut, (VariableSpace)this.transMeta, (String)proxyhost, (int)proxyport, (String)proxyusername, (String)proxypassword);
            testOK = true;
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        if (testOK) {
            mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SSHDialog.Connected.OK", (String[])new String[]{servername, username}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SSHDialog.Connected.NOK.ConnectionBad", (String[])new String[]{servername, username}) + Const.CR + errMsg + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Connected.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }

    private void preview() {
        try {
            SSHMeta oneMeta = new SSHMeta();
            this.getInfo(oneMeta);
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, 1, BaseMessages.getString(PKG, (String)"SSHDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Trans trans = progressDialog.getTrans();
                    String loggingText = progressDialog.getLoggingText();
                    if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, "Error", "Error while previewing data", (Exception)((Object)e));
        }
    }
}

