/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.sasinput;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sasinput.SasInputField;
import org.pentaho.di.trans.steps.sasinput.SasInputHelper;
import org.pentaho.di.trans.steps.sasinput.SasInputMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SasInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SasInputMeta.class;
    private CCombo wAccField;
    private SasInputMeta input;
    private boolean backupChanged;
    private TableView wFields;

    public SasInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (SasInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SasInputDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SASInputDialog.Dialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Text lastControl = this.wStepname;
        Label wlAccField = new Label((Composite)this.shell, 131072);
        wlAccField.setText(BaseMessages.getString(PKG, (String)"SASInputDialog.AcceptField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAccField);
        FormData fdlAccField = new FormData();
        fdlAccField.top = new FormAttachment((Control)lastControl, margin);
        fdlAccField.left = new FormAttachment(0, 0);
        fdlAccField.right = new FormAttachment(middle, -margin);
        wlAccField.setLayoutData((Object)fdlAccField);
        this.wAccField = new CCombo((Composite)this.shell, 18436);
        this.wAccField.setToolTipText(BaseMessages.getString(PKG, (String)"SASInputDialog.AcceptField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAccField);
        FormData fdAccField = new FormData();
        fdAccField.top = new FormAttachment((Control)lastControl, margin);
        fdAccField.left = new FormAttachment(middle, 0);
        fdAccField.right = new FormAttachment(100, 0);
        this.wAccField.setLayoutData((Object)fdAccField);
        lastControl = this.wAccField;
        try {
            RowMetaInterface fields = this.transMeta.getPrevStepFields(this.stepMeta);
            this.wAccField.setItems(fields.getFieldNames());
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Couldn't get input fields for step '" + this.stepMeta + "'", (Throwable)e);
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SasInputDialog.this.ok();
            }
        });
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SasInputDialog.this.get();
            }
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SasInputDialog.this.cancel();
            }
        });
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 16384);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SASInputDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(100, 0);
        wlFields.setLayoutData((Object)fdlFields);
        lastControl = wlFields;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Rename", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Type", (String[])new String[0]), 2, ValueMeta.getTypes(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Mask", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SASInputDialog.OutputFieldColumn.TrimType", (String[])new String[0]), 2, ValueMeta.trimTypeDesc)};
        colinf[3].setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            @Override
            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = new String[]{};
                int type = ValueMeta.getType((String)tableItem.getText(colNr - 1));
                switch (type) {
                    case 3: {
                        comboValues = Const.getDateFormats();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        comboValues = Const.getNumberFormats();
                        break;
                    }
                }
                return comboValues;
            }
        });
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 65538, colinf, 1, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)lastControl, margin * 2);
        fdFields.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData(fdFields);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SasInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SasInputDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wAccField.setText(Const.NVL((String)this.input.getAcceptingField(), (String)""));
        for (int i = 0; i < this.input.getOutputFields().size(); ++i) {
            SasInputField field = (SasInputField)this.input.getOutputFields().get(i);
            TableItem item = new TableItem(this.wFields.table, 0);
            int colnr = 1;
            item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getRename(), (String)""));
            item.setText(colnr++, ValueMeta.getTypeDesc((int)field.getType()));
            item.setText(colnr++, Const.NVL((String)field.getConversionMask(), (String)""));
            item.setText(colnr++, field.getLength() >= 0 ? Integer.toString(field.getLength()) : "");
            item.setText(colnr++, field.getPrecision() >= 0 ? Integer.toString(field.getPrecision()) : "");
            item.setText(colnr++, Const.NVL((String)field.getDecimalSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getGroupingSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getTrimTypeDesc(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    public void getInfo(SasInputMeta meta) throws KettleStepException {
        meta.setAcceptingField(this.wAccField.getText());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        meta.getOutputFields().clear();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            int colnr = 1;
            SasInputField field = new SasInputField();
            field.setName(item.getText(colnr++));
            field.setRename(item.getText(colnr++));
            if (Utils.isEmpty((CharSequence)field.getRename())) {
                field.setRename(field.getName());
            }
            field.setType(ValueMeta.getType((String)item.getText(colnr++)));
            field.setConversionMask(item.getText(colnr++));
            field.setLength(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setDecimalSymbol(item.getText(colnr++));
            field.setGroupingSymbol(item.getText(colnr++));
            field.setTrimType(ValueMeta.getTrimTypeByDesc((String)item.getText(colnr++)));
            meta.getOutputFields().add(field);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        try {
            this.stepname = this.wStepname.getText();
            this.getInfo(this.input);
        }
        catch (KettleStepException e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(e.toString());
            mb.setText(BaseMessages.getString(PKG, (String)"System.Warning", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    public void get() {
        try {
            FileDialog dialog = new FileDialog(this.shell, 4096);
            dialog.setFilterExtensions(new String[]{"*.sas7bdat;*.SAS7BDAT", "*.*"});
            dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"SASInputDialog.FileType.SAS7BAT", (String[])new String[0]) + ", " + BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
            if (dialog.open() != null) {
                String filename = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                SasInputHelper helper = new SasInputHelper(filename);
                BaseStepDialog.getFieldsFromPrevious(helper.getRowMeta(), this.wFields, 1, new int[]{1}, new int[]{3}, 4, 5, null);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error reading information from file", e);
        }
    }
}

