/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.databaselookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class DatabaseLookupDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = DatabaseLookupMeta.class;
    private CCombo wConnection;
    private Label wlCache;
    private Button wCache;
    private FormData fdlCache;
    private FormData fdCache;
    private Label wlCacheLoadAll;
    private Button wCacheLoadAll;
    private FormData fdlCacheLoadAll;
    private FormData fdCacheLoadAll;
    private Label wlCachesize;
    private Text wCachesize;
    private FormData fdlCachesize;
    private FormData fdCachesize;
    private Label wlKey;
    private TableView wKey;
    private FormData fdlKey;
    private FormData fdKey;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Button wbSchema;
    private FormData fdbSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Label wlOrderBy;
    private Text wOrderBy;
    private FormData fdlOrderBy;
    private FormData fdOrderBy;
    private Label wlFailMultiple;
    private Button wFailMultiple;
    private FormData fdlFailMultiple;
    private FormData fdFailMultiple;
    private Label wlEatRows;
    private Button wEatRows;
    private FormData fdlEatRows;
    private FormData fdEatRows;
    private Button wGet;
    private Button wGetLU;
    private Listener lsGet;
    private Listener lsGetLU;
    private DatabaseLookupMeta input;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private List<ColumnInfo> fieldColumns = new ArrayList<ColumnInfo>();
    private RowMetaInterface prevFields = null;

    public DatabaseLookupDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (DatabaseLookupMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
            }
        };
        ModifyListener lsConnectionMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.setTableFieldCombo();
            }
        };
        ModifyListener lsTableMod = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.setTableFieldCombo();
            }
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsConnectionMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSchema = new FormData();
        this.fdbSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)this.fdbSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Lookuptable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.wlCache = new Label((Composite)this.shell, 131072);
        this.wlCache.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Cache.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCache);
        this.fdlCache = new FormData();
        this.fdlCache.left = new FormAttachment(0, 0);
        this.fdlCache.right = new FormAttachment(middle, -margin);
        this.fdlCache.top = new FormAttachment((Control)this.wTable, margin);
        this.wlCache.setLayoutData((Object)this.fdlCache);
        this.wCache = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wCache);
        this.fdCache = new FormData();
        this.fdCache.left = new FormAttachment(middle, 0);
        this.fdCache.top = new FormAttachment((Control)this.wTable, margin);
        this.wCache.setLayoutData((Object)this.fdCache);
        this.wCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        this.wlCachesize = new Label((Composite)this.shell, 131072);
        this.wlCachesize.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Cachesize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCachesize);
        this.wlCachesize.setEnabled(this.input.isCached());
        this.fdlCachesize = new FormData();
        this.fdlCachesize.left = new FormAttachment(0, 0);
        this.fdlCachesize.right = new FormAttachment(middle, -margin);
        this.fdlCachesize.top = new FormAttachment((Control)this.wCache, margin);
        this.wlCachesize.setLayoutData((Object)this.fdlCachesize);
        this.wCachesize = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCachesize);
        this.wCachesize.setEnabled(this.input.isCached());
        this.wCachesize.addModifyListener(lsMod);
        this.fdCachesize = new FormData();
        this.fdCachesize.left = new FormAttachment(middle, 0);
        this.fdCachesize.right = new FormAttachment(100, 0);
        this.fdCachesize.top = new FormAttachment((Control)this.wCache, margin);
        this.wCachesize.setLayoutData((Object)this.fdCachesize);
        this.wlCacheLoadAll = new Label((Composite)this.shell, 131072);
        this.wlCacheLoadAll.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.CacheLoadAll.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCacheLoadAll);
        this.fdlCacheLoadAll = new FormData();
        this.fdlCacheLoadAll.left = new FormAttachment(0, 0);
        this.fdlCacheLoadAll.right = new FormAttachment(middle, -margin);
        this.fdlCacheLoadAll.top = new FormAttachment((Control)this.wCachesize, margin);
        this.wlCacheLoadAll.setLayoutData((Object)this.fdlCacheLoadAll);
        this.wCacheLoadAll = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wCacheLoadAll);
        this.fdCacheLoadAll = new FormData();
        this.fdCacheLoadAll.left = new FormAttachment(middle, 0);
        this.fdCacheLoadAll.top = new FormAttachment((Control)this.wCachesize, margin);
        this.wCacheLoadAll.setLayoutData((Object)this.fdCacheLoadAll);
        this.wCacheLoadAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        this.wlKey = new Label((Composite)this.shell, 0);
        this.wlKey.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Keys.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKey);
        this.fdlKey = new FormData();
        this.fdlKey.left = new FormAttachment(0, 0);
        this.fdlKey.top = new FormAttachment((Control)this.wCacheLoadAll, margin);
        this.wlKey.setLayoutData((Object)this.fdlKey);
        int nrKeyCols = 4;
        int nrKeyRows = this.input.getStreamKeyField1() != null ? this.input.getStreamKeyField1().length : 1;
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Tablefield", (String[])new String[0]), 2, new String[]{""}, false);
        ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, DatabaseLookupMeta.conditionStrings);
        ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Field1", (String[])new String[0]), 2, new String[]{""}, false);
        ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Field2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(ciKey[0]);
        this.fieldColumns.add(ciKey[2]);
        this.fieldColumns.add(ciKey[3]);
        this.wKey = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciKey, nrKeyRows, lsMod, this.props);
        this.fdKey = new FormData();
        this.fdKey.left = new FormAttachment(0, 0);
        this.fdKey.top = new FormAttachment((Control)this.wlKey, margin);
        this.fdKey.right = new FormAttachment(100, 0);
        this.fdKey.bottom = new FormAttachment((Control)this.wlKey, 250);
        this.wKey.setLayoutData(this.fdKey);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetFields.Button", (String[])new String[0]));
        this.wGetLU = new Button((Composite)this.shell, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetLookupFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet, this.wGetLU}, margin, null);
        this.wlOrderBy = new Label((Composite)this.shell, 131072);
        this.wlOrderBy.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Orderby.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOrderBy);
        this.fdlOrderBy = new FormData();
        this.fdlOrderBy.left = new FormAttachment(0, 0);
        this.fdlOrderBy.right = new FormAttachment(middle, -margin);
        this.fdlOrderBy.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wlOrderBy.setLayoutData((Object)this.fdlOrderBy);
        this.wOrderBy = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wOrderBy);
        this.fdOrderBy = new FormData();
        this.fdOrderBy.left = new FormAttachment(middle, 0);
        this.fdOrderBy.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.fdOrderBy.right = new FormAttachment(100, 0);
        this.wOrderBy.setLayoutData((Object)this.fdOrderBy);
        this.wOrderBy.addModifyListener(lsMod);
        this.wlFailMultiple = new Label((Composite)this.shell, 131072);
        this.wlFailMultiple.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.FailMultiple.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFailMultiple);
        this.fdlFailMultiple = new FormData();
        this.fdlFailMultiple.left = new FormAttachment(0, 0);
        this.fdlFailMultiple.right = new FormAttachment(middle, -margin);
        this.fdlFailMultiple.bottom = new FormAttachment((Control)this.wOrderBy, -margin);
        this.wlFailMultiple.setLayoutData((Object)this.fdlFailMultiple);
        this.wFailMultiple = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wFailMultiple);
        this.fdFailMultiple = new FormData();
        this.fdFailMultiple.left = new FormAttachment(middle, 0);
        this.fdFailMultiple.bottom = new FormAttachment((Control)this.wOrderBy, -margin);
        this.wFailMultiple.setLayoutData((Object)this.fdFailMultiple);
        this.wFailMultiple.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        this.wlEatRows = new Label((Composite)this.shell, 131072);
        this.wlEatRows.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.EatRows.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEatRows);
        this.fdlEatRows = new FormData();
        this.fdlEatRows.left = new FormAttachment(0, 0);
        this.fdlEatRows.right = new FormAttachment(middle, -margin);
        this.fdlEatRows.bottom = new FormAttachment((Control)this.wFailMultiple, -margin);
        this.wlEatRows.setLayoutData((Object)this.fdlEatRows);
        this.wEatRows = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wEatRows);
        this.fdEatRows = new FormData();
        this.fdEatRows.left = new FormAttachment(middle, 0);
        this.fdEatRows.bottom = new FormAttachment((Control)this.wFailMultiple, -margin);
        this.wEatRows.setLayoutData((Object)this.fdEatRows);
        this.wEatRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.input.setChanged();
                DatabaseLookupDialog.this.enableFields();
            }
        });
        this.wlReturn = new Label((Composite)this.shell, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Return.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wKey, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        int UpInsCols = 4;
        int UpInsRows = this.input.getReturnValueField() != null ? this.input.getReturnValueField().length : 1;
        ColumnInfo[] ciReturn = new ColumnInfo[UpInsCols];
        ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[0], false);
        ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Newname", (String[])new String[0]), 1, false);
        ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Default", (String[])new String[0]), 1, false);
        ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMeta.getTypes());
        this.tableFieldColumns.add(ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciReturn, UpInsRows, lsMod, this.props);
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment(100, 0);
        this.fdReturn.bottom = new FormAttachment((Control)this.wEatRows, -margin);
        this.wReturn.setLayoutData(this.fdReturn);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                DatabaseLookupDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                DatabaseLookupDialog.this.get();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                DatabaseLookupDialog.this.getlookup();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                DatabaseLookupDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wOrderBy.addSelectionListener((SelectionListener)this.lsDef);
        this.wCachesize.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DatabaseLookupDialog.this.cancel();
            }
        });
        this.wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.getSchemaNames();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseLookupDialog.this.getTableName();
            }
        });
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.setComboValues();
        this.setTableFieldCombo();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void setComboValues() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                try {
                    DatabaseLookupDialog.this.prevFields = DatabaseLookupDialog.this.transMeta.getPrevStepFields(DatabaseLookupDialog.this.stepname);
                }
                catch (KettleException e) {
                    DatabaseLookupDialog.this.prevFields = (RowMetaInterface)new RowMeta();
                    String msg = BaseMessages.getString((Class)PKG, (String)"DatabaseLookupDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                    DatabaseLookupDialog.this.logError(msg);
                }
                Object[] prevStepFieldNames = DatabaseLookupDialog.this.prevFields.getFieldNames();
                Arrays.sort(prevStepFieldNames);
                for (ColumnInfo colInfo : DatabaseLookupDialog.this.fieldColumns) {
                    colInfo.setComboValues((String[])prevStepFieldNames);
                }
            }
        };
        new Thread(fieldLoader).start();
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!(DatabaseLookupDialog.this.wTable.isDisposed() || DatabaseLookupDialog.this.wConnection.isDisposed() || DatabaseLookupDialog.this.wSchema.isDisposed())) {
                    DatabaseMeta ci;
                    String tableName = DatabaseLookupDialog.this.wTable.getText();
                    String connectionName = DatabaseLookupDialog.this.wConnection.getText();
                    String schemaName = DatabaseLookupDialog.this.wSchema.getText();
                    if (!Utils.isEmpty((CharSequence)tableName) && (ci = DatabaseLookupDialog.this.transMeta.findDatabase(connectionName)) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        db.shareVariablesWith((VariableSpace)DatabaseLookupDialog.this.transMeta);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(schemaName, tableName);
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null != r && null != (fieldNames = r.getFieldNames())) {
                                for (ColumnInfo colInfo : DatabaseLookupDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(fieldNames);
                                }
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : DatabaseLookupDialog.this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                        finally {
                            try {
                                if (db != null) {
                                    db.disconnect();
                                }
                            }
                            catch (Exception ignored) {
                                db = null;
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    private void enableFields() {
        this.wlOrderBy.setEnabled(!this.wFailMultiple.getSelection());
        this.wOrderBy.setEnabled(!this.wFailMultiple.getSelection());
        this.wCachesize.setEnabled(this.wCache.getSelection() && !this.wCacheLoadAll.getSelection());
        this.wlCachesize.setEnabled(this.wCache.getSelection() && !this.wCacheLoadAll.getSelection());
        this.wCacheLoadAll.setEnabled(this.wCache.getSelection());
        this.wlCacheLoadAll.setEnabled(this.wCache.getSelection());
        this.wFailMultiple.setEnabled(!this.wCache.getSelection());
        this.wlFailMultiple.setEnabled(!this.wCache.getSelection());
    }

    public void getData() {
        TableItem item;
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wCache.setSelection(this.input.isCached());
        this.wCachesize.setText("" + this.input.getCacheSize());
        this.wCacheLoadAll.setSelection(this.input.isLoadingAllDataInCache());
        if (this.input.getStreamKeyField1() != null) {
            for (i = 0; i < this.input.getStreamKeyField1().length; ++i) {
                item = this.wKey.table.getItem(i);
                if (this.input.getTableKeyField()[i] != null) {
                    item.setText(1, this.input.getTableKeyField()[i]);
                }
                if (this.input.getKeyCondition()[i] != null) {
                    item.setText(2, this.input.getKeyCondition()[i]);
                }
                if (this.input.getStreamKeyField1()[i] != null) {
                    item.setText(3, this.input.getStreamKeyField1()[i]);
                }
                if (this.input.getStreamKeyField2()[i] == null) continue;
                item.setText(4, this.input.getStreamKeyField2()[i]);
            }
        }
        if (this.input.getReturnValueField() != null) {
            for (i = 0; i < this.input.getReturnValueField().length; ++i) {
                item = this.wReturn.table.getItem(i);
                if (this.input.getReturnValueField()[i] != null) {
                    item.setText(1, this.input.getReturnValueField()[i]);
                }
                if (this.input.getReturnValueNewName()[i] != null && !this.input.getReturnValueNewName()[i].equals(this.input.getReturnValueField()[i])) {
                    item.setText(2, this.input.getReturnValueNewName()[i]);
                }
                if (this.input.getReturnValueDefault()[i] != null) {
                    item.setText(3, this.input.getReturnValueDefault()[i]);
                }
                item.setText(4, ValueMeta.getTypeDesc((int)this.input.getReturnValueDefaultType()[i]));
            }
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTablename() != null) {
            this.wTable.setText(this.input.getTablename());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getOrderByClause() != null) {
            this.wOrderBy.setText(this.input.getOrderByClause());
        }
        this.wFailMultiple.setSelection(this.input.isFailingOnMultipleResults());
        this.wEatRows.setSelection(this.input.isEatingRowOnLookupFailure());
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.enableFields();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        int nrkeys = this.wKey.nrNonEmpty();
        int nrfields = this.wReturn.nrNonEmpty();
        this.input.allocate(nrkeys, nrfields);
        this.input.setCached(this.wCache.getSelection());
        this.input.setCacheSize(Const.toInt((String)this.wCachesize.getText(), (int)0));
        this.input.setLoadingAllDataInCache(this.wCacheLoadAll.getSelection());
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.FoundKeys", (String[])new String[]{String.valueOf(nrkeys)}));
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            this.input.getTableKeyField()[i] = item.getText(1);
            this.input.getKeyCondition()[i] = item.getText(2);
            this.input.getStreamKeyField1()[i] = item.getText(3);
            this.input.getStreamKeyField2()[i] = item.getText(4);
        }
        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.FoundFields", (String[])new String[]{String.valueOf(nrfields)}));
        for (i = 0; i < nrfields; ++i) {
            item = this.wReturn.getNonEmpty(i);
            this.input.getReturnValueField()[i] = item.getText(1);
            this.input.getReturnValueNewName()[i] = item.getText(2);
            if (this.input.getReturnValueNewName()[i] == null || this.input.getReturnValueNewName()[i].length() == 0) {
                this.input.getReturnValueNewName()[i] = this.input.getReturnValueField()[i];
            }
            this.input.getReturnValueDefault()[i] = item.getText(3);
            this.input.getReturnValueDefaultType()[i] = ValueMeta.getType((String)item.getText(4));
            if (this.input.getReturnValueDefaultType()[i] >= 0) continue;
            this.input.getReturnValueDefaultType()[i] = 2;
        }
        this.input.setSchemaName(this.wSchema.getText());
        this.input.setTablename(this.wTable.getText());
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setOrderByClause(this.wOrderBy.getText());
        this.input.setFailingOnMultipleResults(this.wFailMultiple.getSelection());
        this.input.setEatingRowOnLookupFailure(this.wEatRows.getSelection());
        this.stepname = this.wStepname.getText();
        if (this.transMeta.findDatabase(this.wConnection.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(2, "=");
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wKey, 1, new int[]{1, 3}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetFieldsFailed.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetFieldsFailed.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getlookup() {
        block5: {
            DatabaseMeta ci = this.transMeta.findDatabase(this.wConnection.getText());
            if (ci != null) {
                Database db = new Database(loggingObject, ci);
                db.shareVariablesWith((VariableSpace)this.transMeta);
                try {
                    db.connect();
                    if (Utils.isEmpty((CharSequence)this.wTable.getText())) break block5;
                    String schemaTable = ci.getQuotedSchemaTableCombination(db.environmentSubstitute(this.wSchema.getText()), db.environmentSubstitute(this.wTable.getText()));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null && !r.isEmpty()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.Log.FoundTableFields", (String[])new String[0]) + schemaTable + " --> " + r.toStringMeta());
                        BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1, 2}, new int[]{4}, -1, -1, null);
                        break block5;
                    }
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.CouldNotReadTableInfo.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.CouldNotReadTableInfo.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
                catch (KettleException e) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ErrorOccurred.DialogMessage", (String[])new String[0]) + Const.CR + e.getMessage());
                    mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ErrorOccurred.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnectionName.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.InvalidConnectionName.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseLookupDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }
}

