/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.trans.TransGraph;

public final class ExpandedContentManager {
    static Supplier<Spoon> spoonSupplier = Spoon::getInstance;

    public static boolean isVisible() {
        return ExpandedContentManager.isVisible(ExpandedContentManager.spoonInstance().getActiveTransGraph());
    }

    public static boolean isVisible(TransGraph graph) {
        if (graph != null && graph.getChildren().length > 0) {
            return graph.getChildren()[0] instanceof Browser;
        }
        return false;
    }

    public static void createExpandedContent(String url) {
        ExpandedContentManager.createExpandedContent(ExpandedContentManager.spoonInstance().getActiveTransGraph(), url);
    }

    public static void createExpandedContent(TransGraph parent, String url) {
        if (parent == null) {
            return;
        }
        Browser browser = ExpandedContentManager.getExpandedContentForTransGraph(parent);
        if (browser == null) {
            browser = new Browser((Composite)parent, 0);
            browser.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    boolean zoomContent;
                    int state = keyEvent.stateMask;
                    int key = keyEvent.keyCode;
                    boolean copyContent = state == 262144 && key == 0x100000F;
                    boolean arrowNavigation = !(state != 0x400000 && state != 65536 || key != 0x1000003 && key != 0x1000004);
                    boolean backslashNavigation = state == 131072 && key == 8;
                    boolean reloadContent = state == 262144 && (key == 0x100000E || key == 114) || key == 0x100000E;
                    boolean bl = zoomContent = state == 262144 && (key == 16777259 || key == 16777261 || key == 61 || key == 45);
                    if (copyContent) {
                        Browser thisBrowser = (Browser)keyEvent.getSource();
                        Clipboard clipboard = new Clipboard(thisBrowser.getDisplay());
                        clipboard.setContents((Object[])new String[]{thisBrowser.getUrl()}, new Transfer[]{TextTransfer.getInstance()});
                        clipboard.dispose();
                    } else if (arrowNavigation || backslashNavigation || reloadContent || zoomContent) {
                        keyEvent.doit = false;
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            });
        }
        browser.setUrl(url);
    }

    public static void showExpandedContent() {
        ExpandedContentManager.showExpandedContent(ExpandedContentManager.spoonInstance().getActiveTransGraph());
    }

    public static void showExpandedContent(TransGraph graph) {
        if (graph == null) {
            return;
        }
        Browser browser = ExpandedContentManager.getExpandedContentForTransGraph(graph);
        if (browser == null) {
            return;
        }
        if (!ExpandedContentManager.isVisible(graph)) {
            ExpandedContentManager.maximizeExpandedContent(browser);
        }
        browser.moveAbove(null);
        browser.getParent().layout(true);
        browser.getParent().redraw();
    }

    public static Browser getExpandedContentForTransGraph(TransGraph graph) {
        for (Control control : graph.getChildren()) {
            if (!(control instanceof Browser)) continue;
            return (Browser)control;
        }
        return null;
    }

    public static void hideExpandedContent() {
        ExpandedContentManager.hideExpandedContent(ExpandedContentManager.spoonInstance().getActiveTransGraph());
    }

    public static void closeExpandedContent() {
        ExpandedContentManager.closeExpandedContent(ExpandedContentManager.spoonInstance().getActiveTransGraph());
    }

    public static void hideExpandedContent(TransGraph graph) {
        ExpandedContentManager.doToExpandedContent(graph, browser -> {
            browser.moveBelow(null);
            browser.getParent().layout(true);
            browser.getParent().redraw();
        });
    }

    public static void closeExpandedContent(TransGraph graph) {
        ExpandedContentManager.doToExpandedContent(graph, Browser::close);
    }

    private static void doToExpandedContent(TransGraph graph, Consumer<Browser> browserAction) {
        Browser browser = ExpandedContentManager.getExpandedContentForTransGraph(graph);
        if (browser == null) {
            return;
        }
        SashForm sash = (SashForm)ExpandedContentManager.spoonInstance().getDesignParent();
        sash.setWeights(ExpandedContentManager.spoonInstance().getTabSet().getSelected().getSashWeights());
        browserAction.accept(browser);
    }

    private static Spoon spoonInstance() {
        return spoonSupplier.get();
    }

    private static void maximizeExpandedContent(Browser browser) {
        SashForm sash = (SashForm)ExpandedContentManager.spoonInstance().getDesignParent();
        int[] weights = sash.getWeights();
        int[] savedSashWeights = new int[weights.length];
        System.arraycopy(weights, 0, savedSashWeights, 0, weights.length);
        ExpandedContentManager.spoonInstance().getTabSet().getSelected().setSashWeights(savedSashWeights);
        weights[0] = 0;
        weights[1] = 1000;
        sash.setWeights(weights);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(100, 0);
        browser.setLayoutData((Object)formData);
        browser.getParent().layout(true);
        browser.getParent().redraw();
    }
}

