/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class HandledTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected HandledTransportAction(Settings settings, String actionName, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Class<Request> request) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver);
        transportService.registerRequestHandler(actionName, request, "same", new TransportHandler());
    }

    class TransportHandler
    implements TransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public final void messageReceived(Request request, final TransportChannel channel) throws Exception {
            HandledTransportAction.this.execute(request, new ActionListener<Response>((ActionRequest)request){
                final /* synthetic */ ActionRequest val$request;
                {
                    this.val$request = actionRequest;
                }

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        HandledTransportAction.this.logger.warn("Failed to send error response for action [{}] and request [{}]", e1, HandledTransportAction.this.actionName, this.val$request);
                    }
                }
            });
        }
    }
}

