/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputStepMeta;
import org.pentaho.di.trans.steps.jsoninput.JsonInput;
import org.pentaho.di.trans.steps.jsoninput.JsonInputData;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="JsonInput", image="JSI.svg", i18nPackageName="org.pentaho.di.trans.steps.jsoninput", name="JsonInput.name", description="JsonInput.description", categoryDescription="JsonInput.category")
public class JsonInputMeta
extends BaseFileInputStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = JsonInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    protected AdditionalFileOutputFields additionalFileOutputFields = new AdditionalFileOutputFields();
    private InputFiles jsonInputFiles;
    private String valueField;
    private boolean inFields;
    private boolean isAFile;
    private boolean addResultFile;
    private boolean isIgnoreEmptyFile;
    private boolean doNotFailIfNoFile;
    private boolean ignoreMissingPath;
    private boolean defaultPathLeafToNull;
    private boolean readurl;
    private boolean removeSourceField;

    protected void setInputFiles(InputFiles inputFiles) {
        this.jsonInputFiles = inputFiles;
        this.inputFiles = inputFiles;
    }

    protected InputFiles getInputFiles() {
        return this.jsonInputFiles;
    }

    public JsonInputMeta() {
        this.setInputFiles(new InputFiles());
    }

    public String getShortFileNameField() {
        return this.additionalFileOutputFields.shortFilenameField;
    }

    public void setShortFileNameField(String field) {
        this.additionalFileOutputFields.shortFilenameField = field;
    }

    public String getPathField() {
        return this.additionalFileOutputFields.pathField;
    }

    public void setPathField(String field) {
        this.additionalFileOutputFields.pathField = field;
    }

    public String isHiddenField() {
        return this.additionalFileOutputFields.hiddenField;
    }

    public void setIsHiddenField(String field) {
        this.additionalFileOutputFields.hiddenField = field;
    }

    public String getLastModificationDateField() {
        return this.additionalFileOutputFields.lastModificationField;
    }

    public void setLastModificationDateField(String field) {
        this.additionalFileOutputFields.lastModificationField = field;
    }

    public String getUriField() {
        return this.additionalFileOutputFields.uriField;
    }

    public void setUriField(String field) {
        this.additionalFileOutputFields.uriField = field;
    }

    public String getRootUriField() {
        return this.additionalFileOutputFields.rootUriField;
    }

    public void setRootUriField(String field) {
        this.additionalFileOutputFields.rootUriField = field;
    }

    public String getExtensionField() {
        return this.additionalFileOutputFields.extensionField;
    }

    public void setExtensionField(String field) {
        this.additionalFileOutputFields.extensionField = field;
    }

    public String getSizeField() {
        return this.additionalFileOutputFields.sizeField;
    }

    public void setSizeField(String field) {
        this.additionalFileOutputFields.sizeField = field;
    }

    public boolean addResultFile() {
        return this.addResultFile;
    }

    public boolean isReadUrl() {
        return this.readurl;
    }

    public void setReadUrl(boolean readurl) {
        this.readurl = readurl;
    }

    public boolean isRemoveSourceField() {
        return this.removeSourceField;
    }

    public void setRemoveSourceField(boolean removeSourceField) {
        this.removeSourceField = removeSourceField;
    }

    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    public JsonInputField[] getInputFields() {
        return this.jsonInputFiles.inputFields;
    }

    public void setInputFields(JsonInputField[] inputFields) {
        this.jsonInputFiles.inputFields = inputFields;
    }

    public String[] getExludeFileMask() {
        return this.getExcludeFileMask();
    }

    public String[] getExcludeFileMask() {
        return this.inputFiles.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.inputFiles.excludeFileMask = excludeFileMask;
    }

    public String getFieldValue() {
        return this.valueField;
    }

    public void setFieldValue(String value) {
        this.valueField = value;
        this.inputFiles.acceptingField = value;
    }

    public boolean isInFields() {
        return this.inFields;
    }

    public void setInFields(boolean inFields) {
        this.inFields = inFields;
        this.inputFiles.acceptingFilenames = inFields;
    }

    public String[] getFileMask() {
        return this.inputFiles.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.inputFiles.fileMask = fileMask;
    }

    public String[] getFileRequired() {
        return this.inputFiles.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.inputFiles.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.inputFiles.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String[] getFileName() {
        return this.inputFiles.fileName;
    }

    public void setFileName(String[] fileName) {
        this.inputFiles.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public boolean isIgnoreEmptyFile() {
        return this.isIgnoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean isIgnoreEmptyFile) {
        this.isIgnoreEmptyFile = isIgnoreEmptyFile;
    }

    @Deprecated
    public boolean isdoNotFailIfNoFile() {
        return this.isDoNotFailIfNoFile();
    }

    @Deprecated
    public void setdoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.setDoNotFailIfNoFile(doNotFailIfNoFile);
    }

    public boolean isDoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    public void setDoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    public boolean isDefaultPathLeafToNull() {
        return this.defaultPathLeafToNull;
    }

    public void setIgnoreMissingPath(boolean ignoreMissingPath) {
        this.ignoreMissingPath = ignoreMissingPath;
    }

    public void setDefaultPathLeafToNull(boolean defaultPathLeafToNull) {
        this.defaultPathLeafToNull = defaultPathLeafToNull;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public boolean getIsAFile() {
        return this.isAFile;
    }

    public void setIsAFile(boolean isAFile) {
        this.isAFile = isAFile;
    }

    public String[] getIncludeSubFolders() {
        return this.inputFiles.includeSubFolders;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public JsonInputMeta clone() {
        JsonInputMeta clone = (JsonInputMeta)((Object)super.clone());
        return clone;
    }

    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(400);
        retval.append("    ").append(XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addresultfile", (boolean)this.addResultFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"readurl", (boolean)this.readurl));
        retval.append("    ").append(XMLHandler.addTagValue((String)"removeSourceField", (boolean)this.removeSourceField));
        retval.append("    " + XMLHandler.addTagValue((String)"IsIgnoreEmptyFile", (boolean)this.isIgnoreEmptyFile));
        retval.append("    " + XMLHandler.addTagValue((String)"doNotFailIfNoFile", (boolean)this.doNotFailIfNoFile));
        retval.append("    " + XMLHandler.addTagValue((String)"ignoreMissingPath", (boolean)this.ignoreMissingPath));
        retval.append("    " + XMLHandler.addTagValue((String)"defaultPathLeafToNull", (boolean)this.defaultPathLeafToNull));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.getFileName().length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.getFileName()[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.getFileMask()[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.getExcludeFileMask()[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.getFileRequired()[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.getIncludeSubFolders()[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.getInputFields().length; ++i) {
            JsonInputField field = this.getInputFields()[i];
            retval.append(field.getXML());
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"IsInFields", (boolean)this.inFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"IsAFile", (boolean)this.isAFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"valueField", (String)this.valueField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.getShortFileNameField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.getPathField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.isHiddenField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.getLastModificationDateField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.getUriField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.getUriField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.getExtensionField()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.getSizeField()));
        return retval.toString();
    }

    public String getRequiredFilesDesc(String tt) {
        if (Const.isEmpty((String)tt)) {
            return RequiredFilesDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.addResultFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addresultfile"));
            this.readurl = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"readurl"));
            this.removeSourceField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"removeSourceField"));
            this.isIgnoreEmptyFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsIgnoreEmptyFile"));
            this.ignoreMissingPath = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ignoreMissingPath"));
            this.defaultPathLeafToNull = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"defaultPathLeafToNull"));
            this.doNotFailIfNoFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"doNotFailIfNoFile"));
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.initArrayFields(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.getFileName()[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.getFileMask()[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.getExcludeFileMask()[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.getFileRequired()[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.getIncludeSubFolders()[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                JsonInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.getInputFields()[i] = field = new JsonInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.setInFields("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsInFields")));
            this.isAFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsAFile"));
            this.setFieldValue(XMLHandler.getTagValue((Node)stepnode, (String)"valueField"));
            this.setShortFileNameField(XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName"));
            this.setPathField(XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName"));
            this.setIsHiddenField(XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName"));
            this.setLastModificationDateField(XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName"));
            this.setUriField(XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName"));
            this.setRootUriField(XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName"));
            this.setExtensionField(XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName"));
            this.setSizeField(XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JsonInputMeta.Exception.ErrorLoadingXML", (String[])new String[]{e.toString()}));
        }
    }

    @Deprecated
    public void allocate(int nrFiles, int nrFields) {
        this.initArrayFields(nrFiles, nrFields);
    }

    private void initArrayFields(int nrfiles, int nrfields) {
        this.setInputFields(new JsonInputField[nrfields]);
        this.getInputFiles().allocate(nrfiles, nrfields);
    }

    public void setDefault() {
        this.additionalFileOutputFields = new AdditionalFileOutputFields();
        this.isIgnoreEmptyFile = false;
        this.ignoreMissingPath = false;
        this.defaultPathLeafToNull = false;
        this.doNotFailIfNoFile = true;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.isAFile = false;
        this.addResultFile = false;
        this.readurl = false;
        this.removeSourceField = false;
        int nrFiles = 0;
        int nrFields = 0;
        this.initArrayFields(nrFiles, nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.getInputFields()[i] = new JsonInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.inFields = false;
        this.valueField = "";
    }

    public void getFields(RowMetaInterface rowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v;
        for (JsonInputField field : this.getInputFields()) {
            try {
                rowMeta.addValueMeta(field.toValueMeta(name, space));
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            v = new ValueMetaString(space.environmentSubstitute(this.filenameField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            rowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            rowMeta.addValueMeta((ValueMetaInterface)v);
        }
        this.additionalFileOutputFields.normalize();
        this.additionalFileOutputFields.getFields(rowMeta, name, info, space, repository, metaStore);
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.addResultFile = rep.getStepAttributeBoolean(id_step, "addresultfile");
            this.readurl = rep.getStepAttributeBoolean(id_step, "readurl");
            this.removeSourceField = rep.getStepAttributeBoolean(id_step, "removeSourceField");
            this.isIgnoreEmptyFile = rep.getStepAttributeBoolean(id_step, "IsIgnoreEmptyFile");
            this.ignoreMissingPath = rep.getStepAttributeBoolean(id_step, "ignoreMissingPath");
            this.defaultPathLeafToNull = rep.getStepAttributeBoolean(id_step, "defaultPathLeafToNull");
            this.doNotFailIfNoFile = rep.getStepAttributeBoolean(id_step, "doNotFailIfNoFile");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.initArrayFields(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.getFileName()[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.getFileMask()[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.getExcludeFileMask()[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.getFileRequired()[i] = rep.getStepAttributeString(id_step, i, "file_required");
                this.getIncludeSubFolders()[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
            }
            for (i = 0; i < nrFields; ++i) {
                JsonInputField field = new JsonInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setPath(rep.getStepAttributeString(id_step, i, "field_path"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(ValueMetaBase.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.getInputFields()[i] = field;
            }
            this.inFields = rep.getStepAttributeBoolean(id_step, "IsInFields");
            this.isAFile = rep.getStepAttributeBoolean(id_step, "IsAFile");
            this.valueField = rep.getStepAttributeString(id_step, "valueField");
            this.setShortFileNameField(rep.getStepAttributeString(id_step, "shortFileFieldName"));
            this.setPathField(rep.getStepAttributeString(id_step, "pathFieldName"));
            this.setIsHiddenField(rep.getStepAttributeString(id_step, "hiddenFieldName"));
            this.setLastModificationDateField(rep.getStepAttributeString(id_step, "lastModificationTimeFieldName"));
            this.setRootUriField(rep.getStepAttributeString(id_step, "rootUriNameFieldName"));
            this.setExtensionField(rep.getStepAttributeString(id_step, "extensionFieldName"));
            this.setSizeField(rep.getStepAttributeString(id_step, "sizeFieldName"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "addresultfile", this.addResultFile);
            rep.saveStepAttribute(id_transformation, id_step, "readurl", this.readurl);
            rep.saveStepAttribute(id_transformation, id_step, "removeSourceField", this.removeSourceField);
            rep.saveStepAttribute(id_transformation, id_step, "IsIgnoreEmptyFile", this.isIgnoreEmptyFile);
            rep.saveStepAttribute(id_transformation, id_step, "ignoreMissingPath", this.ignoreMissingPath);
            rep.saveStepAttribute(id_transformation, id_step, "defaultPathLeafToNull", this.defaultPathLeafToNull);
            rep.saveStepAttribute(id_transformation, id_step, "doNotFailIfNoFile", this.doNotFailIfNoFile);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.getFileName().length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.getFileName()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.getFileMask()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.getExcludeFileMask()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.getFileRequired()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.getIncludeSubFolders()[i]);
            }
            for (i = 0; i < this.getInputFields().length; ++i) {
                JsonInputField field = this.getInputFields()[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_path", field.getPath());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", (long)field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", (long)field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "IsInFields", this.inFields);
            rep.saveStepAttribute(id_transformation, id_step, "IsAFile", this.isAFile);
            rep.saveStepAttribute(id_transformation, id_step, "valueField", this.valueField);
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.getShortFileNameField());
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.getPathField());
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.isHiddenField());
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.getLastModificationDateField());
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.getUriField());
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.getRootUriField());
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.getExtensionField());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.getFileName(), (String[])this.getFileMask(), (String[])this.getExcludeFileMask(), (String[])this.getFileRequired(), (boolean[])this.includeSubFolderBoolean());
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (!this.isInFields()) {
            if (input.length <= 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (this.getInputFields().length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoInputField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.isInFields()) {
            if (Const.isEmpty((String)this.getFieldValue())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.FieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles((VariableSpace)transMeta);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new JsonInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new JsonInputData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            FileInputList fileList;
            ArrayList<String> newFilenames = new ArrayList<String>();
            if (!this.isInFields() && (fileList = this.getFiles(space)).getFiles().size() > 0) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject.getName().getPath());
                }
                this.setFileName(newFilenames.toArray(new String[newFilenames.size()]));
                this.setFileMask(new String[newFilenames.size()]);
                this.setFileRequired(new String[newFilenames.size()]);
                Arrays.fill(this.getFileRequired(), "Y");
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public static class AdditionalFileOutputFields
    extends BaseFileInputStepMeta.AdditionalOutputFields {
        public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
            ValueMetaString v;
            if (this.shortFilenameField != null) {
                v = new ValueMetaString(space.environmentSubstitute(this.shortFilenameField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((ValueMetaInterface)v);
            }
            if (this.extensionField != null) {
                v = new ValueMetaString(space.environmentSubstitute(this.extensionField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((ValueMetaInterface)v);
            }
            if (this.pathField != null) {
                v = new ValueMetaString(space.environmentSubstitute(this.pathField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((ValueMetaInterface)v);
            }
            if (this.sizeField != null) {
                v = new ValueMetaInteger(space.environmentSubstitute(this.sizeField));
                v.setOrigin(name);
                v.setLength(9);
                r.addValueMeta((ValueMetaInterface)v);
            }
            if (this.hiddenField != null) {
                v = new ValueMetaBoolean(space.environmentSubstitute(this.hiddenField));
                v.setOrigin(name);
                r.addValueMeta((ValueMetaInterface)v);
            }
            if (this.lastModificationField != null) {
                v = new ValueMetaDate(space.environmentSubstitute(this.lastModificationField));
                v.setOrigin(name);
                r.addValueMeta((ValueMetaInterface)v);
            }
            if (this.uriField != null) {
                v = new ValueMetaString(space.environmentSubstitute(this.uriField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((ValueMetaInterface)v);
            }
            if (this.rootUriField != null) {
                v = new ValueMetaString(space.environmentSubstitute(this.rootUriField));
                v.setLength(100, -1);
                v.setOrigin(name);
                r.addValueMeta((ValueMetaInterface)v);
            }
        }
    }

    public static class InputFiles
    extends BaseFileInputStepMeta.InputFiles {
        public JsonInputField[] inputFields;

        public void allocate(int nrFiles, int nrFields) {
            this.fileName = new String[nrFiles];
            this.fileMask = new String[nrFiles];
            this.excludeFileMask = new String[nrFiles];
            this.fileRequired = new String[nrFiles];
            this.includeSubFolders = new String[nrFiles];
            this.inputFields = new JsonInputField[nrFields];
            Arrays.fill(this.fileName, "");
            Arrays.fill(this.fileMask, "");
            Arrays.fill(this.excludeFileMask, "");
            Arrays.fill(this.fileRequired, "N");
            Arrays.fill(this.includeSubFolders, "N");
        }

        public InputFiles clone() {
            InputFiles clone = (InputFiles)((Object)super.clone());
            clone.allocate(this.fileName.length, this.inputFields.length);
            for (int i = 0; i < this.inputFields.length; ++i) {
                clone.inputFields[i] = this.inputFields[i].clone();
            }
            return clone;
        }
    }
}

