/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.notifier;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.lifecycle.OSGIServiceLifecycleListener;
import org.pentaho.di.osgi.service.notifier.DelayedServiceNotifierListener;
import org.pentaho.osgi.api.BeanFactory;

public class DelayedServiceNotifier
implements Runnable {
    private final Map<Class, List<OSGIServiceLifecycleListener>> listeners;
    private final ScheduledExecutorService scheduler;
    private final OSGIPluginTracker osgiPluginTracker;
    private final Class<?> classToTrack;
    private final LifecycleEvent eventType;
    private final Object serviceObject;
    private final DelayedServiceNotifierListener delayedServiceNotifierListener;

    public DelayedServiceNotifier(OSGIPluginTracker osgiPluginTracker, Class<?> classToTrack, LifecycleEvent eventType, Object serviceObject, Map<Class, List<OSGIServiceLifecycleListener>> listeners, ScheduledExecutorService scheduler, DelayedServiceNotifierListener delayedServiceNotifierListener) {
        this.osgiPluginTracker = osgiPluginTracker;
        this.classToTrack = classToTrack;
        this.eventType = eventType;
        this.serviceObject = serviceObject;
        this.listeners = listeners;
        this.scheduler = scheduler;
        this.delayedServiceNotifierListener = delayedServiceNotifierListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BeanFactory factory = this.osgiPluginTracker.findOrCreateBeanFactoryFor(this.serviceObject);
        if ((factory == null || this.osgiPluginTracker.getProxyUnwrapper() == null) && this.eventType != LifecycleEvent.STOP) {
            ScheduledFuture<?> scheduledFuture = this.scheduler.schedule(this, 100L, TimeUnit.MILLISECONDS);
        } else {
            try {
                List<OSGIServiceLifecycleListener> listenerList = this.listeners.get(this.classToTrack);
                if (listenerList != null) {
                    block8: for (OSGIServiceLifecycleListener listener : listenerList) {
                        switch (this.eventType) {
                            case START: {
                                listener.pluginAdded(this.serviceObject);
                                continue block8;
                            }
                            case STOP: {
                                listener.pluginRemoved(this.serviceObject);
                                continue block8;
                            }
                            case MODIFY: {
                                listener.pluginChanged(this.serviceObject);
                                continue block8;
                            }
                        }
                        throw new IllegalStateException("Unhandled enum value: " + (Object)((Object)this.eventType));
                    }
                }
            }
            finally {
                if (this.delayedServiceNotifierListener != null) {
                    this.delayedServiceNotifierListener.onRun(this.eventType, this.serviceObject);
                }
            }
        }
    }
}

