/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.verticabulkload.nativebinary;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.verticabulkload.nativebinary.ColumnSpec;

public class StreamEncoder {
    private static final byte BYTE_ZERO = 0;
    private static final byte BYTE_FULL = -1;
    private static final byte BYTE_LF = 10;
    private static final byte BYTE_CR = 13;
    private static final int MAX_CHAR_LENGTH = 65000;
    private static final int NUM_ROWS_TO_BUFFER = 500;
    private static final int MAXIMUM_BUFFER_SIZE = 0x7FFFFFF7;
    private int columnCount;
    private int rowMaxSize;
    private int rowHeaderSize;
    private ByteBuffer buffer;
    private Charset charset;
    PipedOutputStream pipedOutputStream;
    WritableByteChannel channel;
    private final List<ColumnSpec> columns;
    private final BitSet rowNulls;

    public void close() throws IOException {
        this.flushAndClose();
    }

    public StreamEncoder(List<ColumnSpec> columns, PipedInputStream inputStream) throws IOException {
        this.columns = Collections.unmodifiableList(columns);
        this.columnCount = this.columns.size();
        this.rowNulls = new BitSet(this.columnCount);
        this.charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = CharBuffer.allocate(65000);
        CharsetEncoder charEncoder = this.charset.newEncoder();
        this.pipedOutputStream = new PipedOutputStream(inputStream);
        this.channel = Channels.newChannel(this.pipedOutputStream);
        this.rowMaxSize = this.rowHeaderSize = 4 + this.rowNulls.numBytes();
        for (ColumnSpec column : columns) {
            switch (column.type) {
                case NUMERIC: 
                case CHAR: 
                case VARCHAR: {
                    column.setCharBuffer(charBuffer);
                    column.setCharEncoder(charEncoder);
                    break;
                }
            }
            this.rowMaxSize += column.getMaxLength();
        }
        this.buffer = ByteBuffer.allocate(this.countMainByteBufferSize());
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.clear();
        for (ColumnSpec column : columns) {
            column.setMainBuffer(this.buffer);
        }
    }

    int countMainByteBufferSize() {
        long bufferSize = (long)this.getRowMaxSize() * 500L;
        return (int)(bufferSize > 0L && bufferSize < 0x7FFFFFF7L ? bufferSize : 0x7FFFFFF7L);
    }

    public void writeHeader() throws IOException {
        this.buffer.put("NATIVE".getBytes(this.charset)).put((byte)10).put((byte)-1).put((byte)13).put((byte)10).put((byte)0);
        this.buffer.putInt(5 + 4 * this.columnCount);
        this.buffer.putShort((short)1);
        this.buffer.put((byte)0);
        this.buffer.putShort((short)this.columnCount);
        for (ColumnSpec column : this.columns) {
            this.buffer.putInt(column.bytes);
        }
    }

    public void writeRow(RowMetaInterface rowMeta, Object[] row) throws IOException, KettleValueException {
        if (row == null) {
            this.flushAndClose();
            return;
        }
        if (row.length < this.columnCount) {
            throw new IllegalArgumentException("Invalid incoming row for given column spec.");
        }
        this.rowNulls.clear();
        this.checkAndFlushBuffer();
        int rowDataSize = 0;
        int rowDataSizeFieldPosition = this.buffer.position();
        this.buffer.putInt(rowDataSize);
        int rowNullsFieldPosition = this.buffer.position();
        this.rowNulls.writeBytesTo(this.buffer);
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSpec colSpec = this.columns.get(i);
            Object value = row[i];
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
            if (value == null) {
                this.rowNulls.setBit(i);
                continue;
            }
            colSpec.encode(valueMeta, value);
            rowDataSize += colSpec.bytes;
        }
        this.buffer.putInt(rowDataSizeFieldPosition, rowDataSize);
        this.rowNulls.writeBytesTo(rowNullsFieldPosition, this.buffer);
    }

    private void flushAndClose() throws IOException {
        this.flushBuffer();
        this.channel.close();
        this.pipedOutputStream.flush();
        this.pipedOutputStream.close();
    }

    private void checkAndFlushBuffer() throws IOException {
        if (this.buffer.position() + this.rowMaxSize > this.buffer.capacity()) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    int getRowMaxSize() {
        return this.rowMaxSize;
    }

    private class BitSet {
        private byte[] bytes;
        private boolean dirty = false;
        private int numBits;
        private int numBytes;

        private BitSet(int numBits) {
            this.numBits = numBits;
            this.numBytes = (int)Math.ceil((double)numBits / 8.0);
            this.bytes = new byte[this.numBytes];
        }

        private void setBit(int bitIndex) {
            if (bitIndex < 0 || bitIndex >= this.numBits) {
                throw new IllegalArgumentException("Invalid bit index");
            }
            int byteIdx = (int)Math.floor((double)bitIndex / 8.0);
            int bitIdx = bitIndex - byteIdx * 8;
            int n = byteIdx;
            this.bytes[n] = (byte)(this.bytes[n] | 1 << 7 - bitIdx);
            this.dirty = true;
        }

        private void clear() {
            if (this.dirty) {
                for (int i = 0; i < this.numBytes; ++i) {
                    this.bytes[i] = 0;
                }
                this.dirty = false;
            }
        }

        private int numBytes() {
            return this.bytes.length;
        }

        private void writeBytesTo(ByteBuffer buf) {
            buf.put(this.bytes);
        }

        private void writeBytesTo(int index, ByteBuffer buf) {
            for (int i = 0; i < this.bytes.length; ++i) {
                buf.put(index + i, this.bytes[i]);
            }
        }
    }
}

